/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core;

import java.util.HashSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.dltk.compiler.CharOperation;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.core.ScriptProject;
import org.eclipse.dltk.internal.core.util.Util;

public class ProjectReferenceChange {
    private ScriptProject project;
    private IBuildpathEntry[] oldResolvedBuildpath;

    public ProjectReferenceChange(ScriptProject project, IBuildpathEntry[] oldResolvedBuildpath) {
        this.project = project;
        this.oldResolvedBuildpath = oldResolvedBuildpath;
    }

    public void updateProjectReferencesIfNecessary() throws ModelException {
        block12: {
            if (!this.project.getProject().isAccessible()) {
                return;
            }
            String[] oldRequired = this.oldResolvedBuildpath == null ? CharOperation.NO_STRINGS : this.project.projectPrerequisites(this.oldResolvedBuildpath);
            IBuildpathEntry[] newResolvedBuildpath = this.project.getResolvedBuildpath();
            String[] newRequired = this.project.projectPrerequisites(newResolvedBuildpath);
            final IProject projectResource = this.project.getProject();
            try {
                int newSize;
                HashSet newReferences;
                block11: {
                    String projectName;
                    IProjectDescription description = projectResource.getDescription();
                    IProject[] projectReferences = description.getDynamicReferences();
                    HashSet<String> oldReferences = new HashSet<String>(projectReferences.length);
                    int i = 0;
                    while (i < projectReferences.length) {
                        String projectName2 = projectReferences[i].getName();
                        oldReferences.add(projectName2);
                        ++i;
                    }
                    newReferences = (HashSet)oldReferences.clone();
                    int i2 = 0;
                    while (i2 < oldRequired.length) {
                        projectName = oldRequired[i2];
                        newReferences.remove(projectName);
                        ++i2;
                    }
                    i2 = 0;
                    while (i2 < newRequired.length) {
                        projectName = newRequired[i2];
                        newReferences.add(projectName);
                        ++i2;
                    }
                    newSize = newReferences.size();
                    if (oldReferences.size() == newSize) {
                        for (String newRef : newReferences) {
                            if (oldReferences.contains(newRef)) {
                                continue;
                            }
                            break block11;
                        }
                        return;
                    }
                }
                String[] requiredProjectNames = new String[newSize];
                int index = 0;
                for (String newRef : newReferences) {
                    requiredProjectNames[index++] = newRef;
                }
                Util.sort(requiredProjectNames);
                final IProject[] requiredProjectArray = new IProject[newSize];
                IWorkspaceRoot wksRoot = projectResource.getWorkspace().getRoot();
                int i = 0;
                while (i < newSize) {
                    requiredProjectArray[i] = wksRoot.getProject(requiredProjectNames[i]);
                    ++i;
                }
                IWorkspace workspace = projectResource.getWorkspace();
                ISchedulingRule rule = workspace.getRuleFactory().modifyRule((IResource)projectResource);
                IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

                    public void run(IProgressMonitor monitor) throws CoreException {
                        IProjectDescription description = projectResource.getDescription();
                        description.setDynamicReferences(requiredProjectArray);
                        projectResource.setDescription(description, 64, null);
                    }
                };
                workspace.run(runnable, rule, 1, null);
            }
            catch (CoreException e) {
                if (" ".equals(this.project.getElementName())) break block12;
                throw new ModelException(e);
            }
        }
    }
}

