/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core.index2;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IModelElementVisitor;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.index2.ProjectIndexer2;
import org.eclipse.dltk.internal.core.BuiltinProjectFragment;
import org.eclipse.dltk.internal.core.index2.AbstractIndexRequest;
import org.eclipse.dltk.internal.core.index2.BuiltinProjectFragmentRequest;
import org.eclipse.dltk.internal.core.index2.ExternalProjectFragmentRequest;
import org.eclipse.dltk.internal.core.index2.ProgressJob;
import org.eclipse.dltk.internal.core.index2.SourceModulesRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectRequest
extends AbstractIndexRequest {
    private final IScriptProject project;

    public ProjectRequest(ProjectIndexer2 indexer, IScriptProject project, ProgressJob progressJob) {
        super(indexer, progressJob);
        this.project = project;
    }

    @Override
    protected String getName() {
        return this.project.getElementName();
    }

    @Override
    protected void run() throws CoreException {
        IProjectFragment[] fragments = this.project.getAllProjectFragments();
        HashSet<ISourceModule> sourceModules = new HashSet<ISourceModule>();
        IProjectFragment[] iProjectFragmentArray = fragments;
        int n = fragments.length;
        int n2 = 0;
        while (n2 < n) {
            IProjectFragment fragment = iProjectFragmentArray[n2];
            if (this.isCancelled) {
                return;
            }
            if (fragment instanceof BuiltinProjectFragment) {
                this.projectIndexer.request(new BuiltinProjectFragmentRequest(this.projectIndexer, fragment, this.progressJob));
            } else if (fragment.isExternal()) {
                this.projectIndexer.request(new ExternalProjectFragmentRequest(this.projectIndexer, fragment, this.progressJob));
            } else {
                this.getSourceModules(fragment, sourceModules);
            }
            ++n2;
        }
        this.projectIndexer.request(new SourceModulesRequest(this.projectIndexer, this.project.getPath(), sourceModules, this.progressJob));
    }

    private void getSourceModules(IProjectFragment fragment, final Set<ISourceModule> sourceModules) throws ModelException {
        IModelElementVisitor visitor = new IModelElementVisitor(){

            public boolean visit(IModelElement element) {
                if (element.getElementType() == 5) {
                    sourceModules.add((ISourceModule)element);
                    return false;
                }
                return true;
            }
        };
        fragment.accept(visitor);
    }

    @Override
    public boolean belongsTo(String jobFamily) {
        return jobFamily.equals(this.project.getProject().getName());
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.project == null ? 0 : this.project.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProjectRequest other = (ProjectRequest)obj;
        return !(this.project == null ? other.project != null : !this.project.equals(other.project));
    }
}

