/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.koneki.ldt.ui.wizards.pages;

import java.text.MessageFormat;
import java.util.List;
import java.util.Observable;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.koneki.ldt.core.internal.LuaLanguageToolkit;
import org.eclipse.koneki.ldt.core.internal.buildpath.LuaExecutionEnvironment;
import org.eclipse.koneki.ldt.ui.LuaExecutionEnvironmentUIManager;
import org.eclipse.koneki.ldt.ui.internal.buildpath.LuaExecutionEnvironmentContentProvider;
import org.eclipse.koneki.ldt.ui.wizards.pages.Messages;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public class LuaExecutionEnvironmentGroup
extends Observable {
    private final ComboViewer installedEEsComboViewer;
    private boolean isListAvailable = false;
    private ISelection selection;
    private final Button eeButton;
    private final Button noEEButton;
    private boolean hasToCreateMain = true;
    private Button mainCheckBox;
    private final SelectionListener eeChoiceListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            if (LuaExecutionEnvironmentGroup.this.eeButton.getSelection()) {
                LuaExecutionEnvironmentGroup.this.isListAvailable = true;
            } else if (LuaExecutionEnvironmentGroup.this.noEEButton.getSelection()) {
                LuaExecutionEnvironmentGroup.this.isListAvailable = false;
            }
            LuaExecutionEnvironmentGroup.this.installedEEsComboViewer.getCombo().setEnabled(LuaExecutionEnvironmentGroup.this.isListAvailable);
        }
    };

    public LuaExecutionEnvironmentGroup(final Composite parent) {
        Group group = new Group(parent, 0);
        group.setText(Messages.LuaExecutionEnvironmentGroupTitle);
        GridDataFactory.swtDefaults().align(4, 0x1000000).applyTo((Control)group);
        GridLayoutFactory.swtDefaults().numColumns(3).applyTo((Composite)group);
        this.noEEButton = new Button((Composite)group, 16);
        this.noEEButton.setText(Messages.LuaExecutionEnvironmentGroupNoEEForProjectCreation);
        this.noEEButton.addSelectionListener(this.eeChoiceListener);
        GridDataFactory.swtDefaults().span(3, 1).applyTo((Control)this.noEEButton);
        this.eeButton = new Button((Composite)group, 16);
        this.eeButton.setText(Messages.LuaExecutionEnvironmentGroupSelectEE);
        this.eeButton.addSelectionListener(this.eeChoiceListener);
        this.installedEEsComboViewer = new ComboViewer((Composite)group, 2056);
        this.installedEEsComboViewer.setContentProvider((IContentProvider)new LuaExecutionEnvironmentContentProvider());
        GridDataFactory.swtDefaults().align(4, 1).grab(true, false).applyTo(this.installedEEsComboViewer.getControl());
        Link link = new Link((Composite)group, 0);
        link.setFont(group.getFont());
        link.setText(MessageFormat.format("<a>{0}</a>", Messages.LuaExecutionEnvironmentGroupManageExecutionEnvironment));
        GridDataFactory.swtDefaults().align(0x1000008, 0x1000000).applyTo((Control)link);
        this.mainCheckBox = new Button((Composite)group, 32);
        this.mainCheckBox.setText(Messages.LuaExecutionEnvironmentGroupTemplateLabel);
        this.mainCheckBox.setSelection(this.hasToCreateMain);
        GridDataFactory.swtDefaults().span(3, 1).applyTo((Control)this.mainCheckBox);
        this.mainCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LuaExecutionEnvironmentGroup.this.hasToCreateMain = LuaExecutionEnvironmentGroup.this.mainCheckBox.getSelection();
            }
        });
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreferencesUtil.createPreferenceDialogOn((Shell)parent.getShell(), (String)"org.eclipse.koneki.ldt.ui.executionenvironmentpreferencepage", (String[])new String[]{"org.eclipse.koneki.ldt.ui.executionenvironmentpreferencepage"}, null).open();
                LuaExecutionEnvironmentGroup.this.updateExecutionEnvironmentList();
            }
        });
        this.updateExecutionEnvironmentList();
    }

    public LuaExecutionEnvironment getSelectedLuaExecutionEnvironment() {
        if (this.isListAvailable) {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    if (LuaExecutionEnvironmentGroup.this.installedEEsComboViewer != null) {
                        LuaExecutionEnvironmentGroup.this.selection = LuaExecutionEnvironmentGroup.this.installedEEsComboViewer.getSelection();
                    } else {
                        LuaExecutionEnvironmentGroup.this.selection = null;
                    }
                }
            });
            if (this.selection != null && !this.selection.isEmpty() && this.selection instanceof IStructuredSelection) {
                return (LuaExecutionEnvironment)((IStructuredSelection)this.selection).getFirstElement();
            }
        }
        return null;
    }

    public boolean hasToCreateMain() {
        return this.hasToCreateMain;
    }

    private void updateExecutionEnvironmentList() {
        if (this.installedEEsComboViewer != null && this.eeButton != null && this.noEEButton != null) {
            List<LuaExecutionEnvironment> installedExecutionEnvironments = LuaExecutionEnvironmentUIManager.getAvailableExecutionEnvironments();
            this.installedEEsComboViewer.setInput(installedExecutionEnvironments);
            if (installedExecutionEnvironments.size() > 0) {
                ScopedPreferenceStore preferenceStore = new ScopedPreferenceStore(InstanceScope.INSTANCE, LuaLanguageToolkit.getDefault().getPreferenceQualifier());
                String defaultEEId = preferenceStore.getString("EE__default_id");
                for (LuaExecutionEnvironment execEnv : installedExecutionEnvironments) {
                    if (!execEnv.getEEIdentifier().equals(defaultEEId)) continue;
                    this.installedEEsComboViewer.setSelection((ISelection)new StructuredSelection((Object)execEnv));
                }
                if (this.installedEEsComboViewer.getSelection().isEmpty()) {
                    this.installedEEsComboViewer.setSelection((ISelection)new StructuredSelection((Object)installedExecutionEnvironments.get(0)));
                }
                this.eeButton.setEnabled(true);
                this.eeButton.setSelection(true);
                this.noEEButton.setSelection(false);
                this.eeChoiceListener.widgetSelected(null);
            } else {
                this.eeButton.setEnabled(false);
                this.noEEButton.setSelection(true);
            }
            this.setChanged();
            this.notifyObservers();
        }
    }
}

