/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.koneki.tema.core;

import java.io.File;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.koneki.tema.core.I18N;
import org.eclipse.koneki.tema.core.TemaCoreActivator;
import org.eclipse.koneki.tema.core.exceptions.TemplateException;
import org.eclipse.koneki.tema.core.model.ITemplate;
import org.eclipse.koneki.tema.core.model.ITemplateListener;
import org.eclipse.koneki.tema.core.preferences.PreferencesManager;

public class TemaProcessor {
    private ITemplate _template;
    private IPath _prjPath;
    private boolean _putInCache;
    private boolean _hasInCache;

    public TemaProcessor(ITemplate template, IPath prjPath) {
        this._template = template;
        this._prjPath = prjPath;
    }

    protected IPath getProjectPath() {
        return this._prjPath;
    }

    protected ITemplate getTemplate() {
        return this._template;
    }

    public void setPutInCache(boolean putInCache) {
        this._putInCache = putInCache;
    }

    public boolean isPutInCache() {
        return this._putInCache;
    }

    public void setHasInCache(boolean hasInCache) {
        this._hasInCache = hasInCache;
    }

    public boolean hasInCache() {
        return this._hasInCache;
    }

    public IProject extractTemplate(IProgressMonitor monitor) throws TemplateException {
        return this.extractTemplate(monitor, true);
    }

    public IProject extractTemplate(IProgressMonitor monitor, boolean isProject) throws TemplateException {
        ProjectCreationListener listener = new ProjectCreationListener(monitor);
        try {
            this.getTemplate().addTemplateListener(listener);
            if (this.isPutInCache()) {
                try {
                    this.getTemplate().downloadWithCache(this._prjPath.toFile(), new File(PreferencesManager.getCacheFolder()), true);
                    PreferencesManager.addTemplateInCache(this.getTemplate());
                }
                catch (TemplateException te) {
                    TemaCoreActivator.log(te);
                    this.setPutInCache(false);
                }
            }
            if (!this.isPutInCache() && !this.hasInCache()) {
                this.getTemplate().download(this._prjPath.toFile());
            }
            IProject project = null;
            if (isProject) {
                project = ResourcesPlugin.getWorkspace().getRoot().getProject(this.getTemplate().getProjectName());
                IProjectDescription desc = project.getWorkspace().newProjectDescription(this.getTemplate().getProjectName());
                IPath projectPath = this.getProjectPath();
                if (!project.getWorkspace().getRoot().getLocation().isPrefixOf(projectPath)) {
                    desc.setLocation(this.getProjectPath());
                }
                project.create(desc, null);
                project.open(null);
            }
            this.getTemplate().removeTemplateListener(listener);
            return project;
        }
        catch (TemplateException te) {
            TemaCoreActivator.log(te);
            this.getTemplate().removeTemplateListener(listener);
            throw new TemplateException(I18N.getResourceString("message.project.downloadError", this.getTemplate().getName()), this.getTemplate());
        }
        catch (CoreException ce) {
            TemaCoreActivator.log(ce);
            this.performCancel();
            this.getTemplate().removeTemplateListener(listener);
            throw new TemplateException(I18N.getResourceString("message.project.creationError", this.getTemplate().getProjectName()), this.getTemplate());
        }
    }

    public boolean performCancel() throws TemplateException {
        if (this.getTemplate() == null) {
            return true;
        }
        String prjName = this.getTemplate().getProjectName();
        if (prjName == null || "".equals(prjName)) {
            return true;
        }
        if (this._prjPath == null) {
            return true;
        }
        if (!this.getTemplate().exists()) {
            return true;
        }
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(this.getTemplate().getProjectName());
        if (project != null && project.exists()) {
            try {
                project.delete(true, false, null);
            }
            catch (CoreException ce) {
                TemaCoreActivator.log(ce);
                throw new TemplateException(I18N.getResourceString("message.project.cancelError", new String[]{this.getTemplate().getProjectName(), this.getProjectPath().toOSString()}), this.getTemplate());
            }
        }
        return true;
    }

    private class ProjectCreationListener
    implements ITemplateListener {
        private IProgressMonitor _monitor;

        public ProjectCreationListener(IProgressMonitor monitor) {
            this._monitor = monitor;
            this._monitor.beginTask(I18N.getResourceString("project.creation.task.name", new String[]{TemaProcessor.this.getTemplate().getProjectName(), TemaProcessor.this.getTemplate().getName()}), 4);
        }

        @Override
        public void downloadFinished() {
            this._monitor.done();
        }

        @Override
        public void downloadStarted() {
            this._monitor.worked(1);
            this._monitor.subTask(I18N.getResourceString("project.creation.task.init"));
        }

        @Override
        public void parametersProcess() {
            this._monitor.worked(1);
            this._monitor.subTask(I18N.getResourceString("project.creation.task.process"));
        }

        @Override
        public void templateUnzipped() {
            this._monitor.worked(1);
        }

        @Override
        public void templateUnzipping() {
            this._monitor.worked(1);
            this._monitor.subTask(I18N.getResourceString("project.creation.task.unzipping"));
        }
    }
}

