/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.koneki.tema.core.model;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.koneki.tema.core.exceptions.TemplateSiteException;
import org.eclipse.koneki.tema.core.model.ITemplate;
import org.eclipse.koneki.tema.core.model.ITemplateFilter;
import org.eclipse.koneki.tema.core.model.ITemplateSite;

public class JavaTemplateSite
implements ITemplateSite {
    private String _name;
    private Collection<ITemplate> _templates;

    public JavaTemplateSite(String name) {
        this._name = name;
        this._templates = new ArrayList<ITemplate>();
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public Collection<ITemplate> getTemplates(boolean clearCache) throws TemplateSiteException {
        return this._templates;
    }

    @Override
    public Collection<ITemplate> getTemplates(boolean clearCache, ITemplateFilter[] filters) throws TemplateSiteException {
        Collection<ITemplate> templates = this.getTemplates(clearCache);
        int i = 0;
        while (i < filters.length) {
            ITemplateFilter filter = filters[i];
            if (filter != null) {
                templates = filters[i].apply(templates);
            }
            ++i;
        }
        return templates;
    }

    @Override
    public URL getURL() {
        return null;
    }

    @Override
    public void setName(String name) {
        this._name = name;
    }

    @Override
    public void setURL(URL url) {
    }

    @Override
    public void test() throws TemplateSiteException {
    }

    public void clearTemplateSite() {
        this._templates.clear();
    }

    public void addTemplate(ITemplate template) {
        this._templates.add(template);
    }
}

