/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.koneki.tema.core.preferences;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.koneki.tema.core.TemaCoreActivator;
import org.eclipse.koneki.tema.core.internal.model.TemplateSite;
import org.eclipse.koneki.tema.core.model.ITemplate;
import org.eclipse.koneki.tema.core.model.ITemplateSite;
import org.eclipse.koneki.tema.core.model.Template;
import org.osgi.service.prefs.BackingStoreException;

public final class PreferencesManager {
    private static IEclipsePreferences preferences = new InstanceScope().getNode("org.eclipse.koneki.tema.core");
    private static Collection<ITemplateSite> sites = new ArrayList<ITemplateSite>();
    private static Collection<ITemplate> templates = new ArrayList<ITemplate>();

    private PreferencesManager() {
    }

    public static Collection<ITemplateSite> getSites() {
        if (!sites.isEmpty()) {
            return sites;
        }
        sites.clear();
        int sitesCount = preferences.getInt("sitesCount", 0);
        int i = 0;
        while (i < sitesCount) {
            String url;
            String name = preferences.get("template" + i + ".name", "");
            if (!"".equals(name) && !"".equals(url = preferences.get("template" + i + ".url", ""))) {
                try {
                    TemplateSite site = new TemplateSite(new URL(url), name);
                    sites.add(site);
                }
                catch (MalformedURLException malformedURLException) {}
            }
            ++i;
        }
        return sites;
    }

    public static void saveSites(Collection<ITemplateSite> sitesCollection) {
        int oldSitesCount = preferences.getInt("sitesCount", 0);
        int sitesCount = sitesCollection.size();
        preferences.putInt("sitesCount", sitesCount);
        int index = 0;
        for (ITemplateSite site : sitesCollection) {
            preferences.put("template" + index + ".name", site.getName());
            preferences.put("template" + index + ".url", site.getURL().toString());
            ++index;
        }
        int i = sitesCount;
        while (i < oldSitesCount) {
            preferences.put("template" + i + ".name", "");
            preferences.put("template" + i + ".url", "");
            ++i;
        }
        try {
            preferences.flush();
        }
        catch (BackingStoreException e) {
            TemaCoreActivator.log(e);
        }
        sites.clear();
        sites = sitesCollection;
    }

    public static Collection<ITemplate> getCachedTemplates() {
        if (!templates.isEmpty()) {
            return templates;
        }
        templates.clear();
        int count = preferences.getInt("cachedTemplatesCount", 0);
        int i = 0;
        while (i < count) {
            String name = preferences.get("cachedTemplate" + i + ".name", "");
            String version = preferences.get("cachedTemplate" + i + ".version", "");
            String file = preferences.get("cachedTemplate" + i + ".file", "");
            if (!("".equals(name) || "".equals(version) || "".equals(file))) {
                try {
                    URL cachedUrl = new File(PreferencesManager.getCacheFolder()).toURI().toURL();
                    Template template = new Template(cachedUrl);
                    template.setName(name);
                    template.setVersion(version);
                    template.setContent(file);
                    templates.add(template);
                }
                catch (MalformedURLException malformedURLException) {}
            }
            ++i;
        }
        return templates;
    }

    public static void saveCachedTemplates(Collection<ITemplate> templatesCollection) {
        int oldCachedCount = preferences.getInt("cachedTemplatescount", 0);
        int cachedCount = templatesCollection.size();
        preferences.putInt("cachedTemplatesCount", cachedCount);
        int index = 0;
        for (ITemplate template : templatesCollection) {
            String url = template.getURL().toString();
            preferences.put("cachedTemplate" + index + ".name", template.getName());
            preferences.put("cachedTemplate" + index + ".version", template.getVersion());
            preferences.put("cachedTemplate" + index + ".file", url.substring(url.lastIndexOf(47) + 1));
            ++index;
        }
        int i = cachedCount;
        while (i < oldCachedCount) {
            preferences.put("cachedTemplate" + i + ".name", "");
            preferences.put("cachedTemplate" + i + ".version", "");
            preferences.put("cachedTemplate" + i + ".file", "");
            ++i;
        }
        try {
            preferences.flush();
        }
        catch (BackingStoreException e) {
            TemaCoreActivator.log(e);
        }
        templates.clear();
        templates = templatesCollection;
    }

    public static void addTemplateInCache(ITemplate template) {
        if (template == null) {
            return;
        }
        templates.add(template);
        PreferencesManager.saveCachedTemplates(templates);
    }

    public static void removeTemplateFromCache(ITemplate template) {
        if (template == null) {
            return;
        }
        templates.remove(template);
        PreferencesManager.saveCachedTemplates(templates);
    }

    public static boolean getEnableCache() {
        return preferences.getBoolean("enableCache", true);
    }

    public static void saveEnableCache(boolean enableCache) {
        preferences.putBoolean("enableCache", enableCache);
        try {
            preferences.flush();
        }
        catch (BackingStoreException e) {
            TemaCoreActivator.log(e);
        }
    }

    public static boolean getAlwaysCache() {
        return preferences.getBoolean("alwaysCache", true);
    }

    public static void saveAlwaysCache(boolean alwaysCache) {
        preferences.putBoolean("alwaysCache", alwaysCache);
        try {
            preferences.flush();
        }
        catch (BackingStoreException e) {
            TemaCoreActivator.log(e);
        }
    }

    public static String getCacheFolder() {
        return preferences.get("cacheFolder", TemaCoreActivator.getCacheURL().getPath().substring(1));
    }

    public static void saveCacheFolder(String cacheFolder) {
        preferences.put("cacheFolder", cacheFolder);
        try {
            preferences.flush();
        }
        catch (BackingStoreException e) {
            TemaCoreActivator.log(e);
        }
    }

    public static boolean hasTemplateInCache(ITemplate template) {
        if (template == null) {
            return false;
        }
        Collection<ITemplate> templates = PreferencesManager.getCachedTemplates();
        for (ITemplate cached : templates) {
            if (!cached.getName().equals(template.getName()) || !cached.getVersion().equals(template.getVersion())) continue;
            return true;
        }
        return false;
    }
}

