/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.koneki.commons.ui.widgets;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;

public class ClickableIconAndLabel
extends Composite {
    private static final Font TEXT_FONT = JFaceResources.getFontRegistry().getBold(JFaceResources.getDefaultFont().toString());
    private Image enabledIcon;
    private Image disabledIcon;
    private Label iconLbl;
    private Label textLbl;
    private boolean createIconFirst;
    private List<SelectionListener> listeners = new ArrayList<SelectionListener>();

    public ClickableIconAndLabel(Composite parent, Image enabledIcon, Image disabledIcon, String text, boolean createIconFirst) {
        super(parent, 0);
        this.enabledIcon = enabledIcon;
        this.disabledIcon = disabledIcon;
        this.createIconFirst = createIconFirst;
        this.createContents(enabledIcon, text);
    }

    protected void createContents(Image enabledImage, String text) {
        GridLayoutFactory.fillDefaults().spacing(0, 0).applyTo((Composite)this);
        if (this.createIconFirst) {
            this.iconLbl = new Label((Composite)this, 0);
            this.iconLbl.setImage(enabledImage);
            GridDataFactory.fillDefaults().align(0x1000000, 1).grab(true, false).applyTo((Control)this.iconLbl);
        }
        this.textLbl = new Label((Composite)this, 0);
        this.textLbl.setText(text);
        this.textLbl.setFont(TEXT_FONT);
        GridDataFactory.fillDefaults().align(0x1000000, 1).grab(true, false).applyTo((Control)this.textLbl);
        if (!this.createIconFirst) {
            this.iconLbl = new Label((Composite)this, 0);
            this.iconLbl.setImage(enabledImage);
            GridDataFactory.fillDefaults().align(0x1000000, 1).grab(true, false).applyTo((Control)this.iconLbl);
        }
        ClickableMouseTrackAdapter clickableMouseTrackAdapter = new ClickableMouseTrackAdapter();
        MouseClickListener mouseClickListener = new MouseClickListener();
        this.iconLbl.addMouseTrackListener((MouseTrackListener)clickableMouseTrackAdapter);
        this.textLbl.addMouseTrackListener((MouseTrackListener)clickableMouseTrackAdapter);
        this.addMouseTrackListener((MouseTrackListener)clickableMouseTrackAdapter);
        this.iconLbl.addMouseListener((MouseListener)mouseClickListener);
        this.textLbl.addMouseListener((MouseListener)mouseClickListener);
        this.addMouseListener((MouseListener)mouseClickListener);
    }

    public void addSelectionListener(SelectionListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.listeners.remove(listener);
    }

    protected void doClick() {
        Event event = new Event();
        event.widget = this;
        SelectionEvent selectionEvent = new SelectionEvent(event);
        for (SelectionListener listener : this.listeners) {
            listener.widgetSelected(selectionEvent);
        }
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.iconLbl.setEnabled(enabled);
        this.iconLbl.setImage(enabled ? this.enabledIcon : this.disabledIcon);
        this.textLbl.setEnabled(enabled);
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        this.iconLbl.setBackground(color);
        this.textLbl.setBackground(color);
    }

    public void setForeground(Color color) {
        super.setForeground(color);
        this.textLbl.setForeground(color);
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.textLbl.setFont(font);
    }

    public void setText(String string) {
        this.textLbl.setText(string);
    }

    public void setToolTipText(String text) {
        this.iconLbl.setToolTipText(text);
        this.textLbl.setToolTipText(text);
    }

    private static class ClickableMouseTrackAdapter
    extends MouseTrackAdapter {
        private ClickableMouseTrackAdapter() {
        }

        public void mouseEnter(MouseEvent e) {
            ((Control)e.widget).setCursor(e.display.getSystemCursor(21));
        }

        public void mouseExit(MouseEvent e) {
            ((Control)e.widget).setCursor(e.display.getSystemCursor(0));
        }
    }

    private class MouseClickListener
    extends MouseAdapter {
        private MouseClickListener() {
        }

        public void mouseDown(MouseEvent e) {
            ClickableIconAndLabel.this.doClick();
        }
    }
}

