/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.koneki.dashboard.ui;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.common.CommandException;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.koneki.commons.ui.ANWRTToolkit;
import org.eclipse.koneki.commons.ui.ColorRegistry;
import org.eclipse.koneki.commons.ui.CommonImages;
import org.eclipse.koneki.commons.ui.ErrorHandlerUtil;
import org.eclipse.koneki.commons.ui.widgets.ClickableIconAndLabel;
import org.eclipse.koneki.dashboard.ui.Dashboard;
import org.eclipse.koneki.dashboard.ui.DashboardActivator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.IHandlerService;

public abstract class AbstractDashboardPage {
    public static final String NAV_BAR_BACKGROUND = "45,45,57";
    public static final String PREV_PAGE = "#prevPage";
    private ANWRTToolkit toolkit = new ANWRTToolkit(Display.getDefault());
    private Composite pageComposite;
    private Dashboard dashboard;
    private String dashboardID;
    private ClickableIconAndLabel goBackButton;
    private String fromPage;

    public abstract String getId();

    public void createContent(Composite parent) {
        this.pageComposite = this.toolkit.createComposite(parent);
        GridLayoutFactory.fillDefaults().margins(0, 0).applyTo(this.pageComposite);
        this.createPageControl(this.pageComposite);
        if (this.getDefaultPreviousPage() != null || this.getNextPage() != null) {
            Composite navigationComposite = this.toolkit.createComposite(this.pageComposite);
            navigationComposite.setBackground(ColorRegistry.getInstance().get(NAV_BAR_BACKGROUND));
            GridLayoutFactory.swtDefaults().numColumns(2).equalWidth(true).applyTo(navigationComposite);
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)navigationComposite);
            if (this.getDefaultPreviousPage() != null) {
                this.goBackButton = this.toolkit.createClickableIconAndLabel(navigationComposite, CommonImages.getImage((String)"icons/obj16/go-previous.png"), this.getInnerPreviousLabel(), true);
                GridDataFactory.fillDefaults().grab(true, false).align(1, 0x1000008).applyTo((Control)this.goBackButton);
                GridLayoutFactory.fillDefaults().numColumns(2).applyTo((Composite)this.goBackButton);
                this.goBackButton.setForeground(ColorRegistry.COLOR_WHITE);
                this.goBackButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        AbstractDashboardPage.this.switchtoPrevious();
                    }
                });
            }
            if (this.getNextPage() != null) {
                ClickableIconAndLabel goNext = this.toolkit.createClickableIconAndLabel(navigationComposite, CommonImages.getImage((String)"icons/obj16/go-next.png"), this.getNextPageLabel(), false);
                GridDataFactory.fillDefaults().grab(true, false).align(0x1000008, 0x1000008).applyTo((Control)goNext);
                GridLayoutFactory.fillDefaults().numColumns(2).applyTo((Composite)goNext);
                goNext.setForeground(ColorRegistry.COLOR_WHITE);
                goNext.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        AbstractDashboardPage.this.switchtoPage(AbstractDashboardPage.this.getNextPage());
                    }
                });
            }
        }
    }

    public Control getPageControl() {
        return this.pageComposite;
    }

    protected abstract void createPageControl(Composite var1);

    public ANWRTToolkit getToolkit() {
        return this.toolkit;
    }

    protected void switchtoPage(String pageID) {
        this.dashboard.switchPage(this.getDashboardID(), pageID);
    }

    protected void switchtoPrevious() {
        if (this.getFromPage() != null) {
            this.dashboard.switchtoPrevious(this.getDashboardID(), this.getFromPage());
        } else {
            this.switchtoPage(this.getDefaultPreviousPage());
        }
    }

    protected void switchtoPage(String previousPageID, String nextPageID) {
        this.dashboard.switchPage(this.getDashboardID(), previousPageID, nextPageID);
    }

    public Dashboard getDashboard() {
        return this.dashboard;
    }

    public void setDashboard(Dashboard dashboard) {
        this.dashboard = dashboard;
    }

    public String getDashboardID() {
        return this.dashboardID;
    }

    public void setDashboardID(String dashboardID) {
        this.dashboardID = dashboardID;
    }

    protected abstract String getDefaultPreviousPage();

    protected String getPreviousPageLabel() {
        return "Back";
    }

    protected abstract String getNextPage();

    protected String getNextPageLabel() {
        return "Next";
    }

    public void openNewWizard(String wizardId) throws CommandException {
        Command newProjectWizard = ((ICommandService)this.getDashboard().getSite().getService(ICommandService.class)).getCommand("org.eclipse.ui.newWizard");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("newWizardId", wizardId);
        ParameterizedCommand parameterizedCommand = ParameterizedCommand.generateCommand((Command)newProjectWizard, params);
        ExecutionEvent executionEvent = ((IHandlerService)this.getDashboard().getSite().getService(IHandlerService.class)).createExecutionEvent(parameterizedCommand, new Event());
        newProjectWizard.executeWithChecks(executionEvent);
    }

    public void openView(String viewId) throws PartInitException {
        this.getDashboard().getSite().getPage().showView(viewId);
    }

    public void switchPerspective(String perspectiveId) throws PartInitException {
        IPerspectiveDescriptor pers = PlatformUI.getWorkbench().getPerspectiveRegistry().findPerspectiveWithId(perspectiveId);
        this.getDashboard().getSite().getPage().setPerspective(pers);
    }

    public void handleError(String message, Exception e) {
        ErrorHandlerUtil.handleError((String)message, (Throwable)e);
        DashboardActivator.log(e);
    }

    protected void openBrowser(String url) throws PartInitException, MalformedURLException {
        IWorkbenchBrowserSupport browserSupport = PlatformUI.getWorkbench().getBrowserSupport();
        browserSupport.createBrowser(url).openURL(new URL(url));
    }

    protected abstract String getPageTitle();

    public String getFromPage() {
        return this.fromPage;
    }

    public void setFromPage(String pageId) {
        this.fromPage = pageId;
        if (this.goBackButton != null) {
            if (pageId != null && !pageId.equals(this.getDefaultPreviousPage())) {
                this.goBackButton.setText("Previous");
            } else {
                this.goBackButton.setText(this.getPreviousPageLabel());
            }
            this.goBackButton.getParent().layout();
        }
    }

    protected String getInnerPreviousLabel() {
        if (this.getFromPage() != null && !this.getFromPage().equals(this.getDefaultPreviousPage())) {
            return "Previous";
        }
        return this.getPreviousPageLabel();
    }

    public void showHelp(String resourcePath) {
        PlatformUI.getWorkbench().getHelpSystem().displayHelpResource(resourcePath);
    }
}

