/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.koneki.dashboard.ui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.koneki.commons.ui.ANWRTToolkit;
import org.eclipse.koneki.commons.ui.ColorRegistry;
import org.eclipse.koneki.commons.ui.dialogs.RoundedCornerBorderedComposite;
import org.eclipse.koneki.commons.ui.widgets.ClickableIconAndLabel;
import org.eclipse.koneki.dashboard.ui.AbstractDashboardPage;
import org.eclipse.koneki.dashboard.ui.DashboardActivator;
import org.eclipse.koneki.dashboard.ui.DashboardImages;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;

public class DashboardOutlineItem
extends Composite {
    private ANWRTToolkit toolkit;
    private AbstractDashboardPage page;
    private RoundedCornerBorderedComposite roundedCornerBorderedComposite;
    private List<SelectionListener> listeners;

    public DashboardOutlineItem(Composite parent, AbstractDashboardPage page) {
        super(parent, 0);
        this.page = page;
        this.toolkit = new ANWRTToolkit(Display.getDefault());
        this.listeners = new ArrayList<SelectionListener>();
        this.createContents();
    }

    private void createContents() {
        GridLayoutFactory.fillDefaults().margins(0, 0).applyTo((Composite)this);
        this.roundedCornerBorderedComposite = new RoundedCornerBorderedComposite((Composite)this);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.roundedCornerBorderedComposite);
        Composite contentComposite = this.roundedCornerBorderedComposite.getContentComposite();
        GridLayoutFactory.swtDefaults().numColumns(2).applyTo(contentComposite);
        ClickableIconAndLabel iconAndLabel = this.toolkit.createClickableIconAndLabel(contentComposite, DashboardImages.getImage("icons/32/page.png"), this.page.getPageTitle(), true);
        iconAndLabel.setFont(DashboardActivator.getDefault().getFontRegistry().get("header2"));
        iconAndLabel.setBackground(null);
        iconAndLabel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DashboardOutlineItem.this.fireSelectionChanged();
            }
        });
    }

    protected void fireSelectionChanged() {
        Event event = new Event();
        event.widget = this;
        SelectionEvent selectionEvent = new SelectionEvent(event);
        for (SelectionListener listener : this.listeners) {
            listener.widgetSelected(selectionEvent);
        }
    }

    public void addSelectionListener(SelectionListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.listeners.remove(listener);
    }

    public AbstractDashboardPage getDashboardPage() {
        return this.page;
    }

    public void setSelected(boolean state) {
        this.roundedCornerBorderedComposite.setBorderColor((Color)(state ? ColorRegistry.COLOR_GREEN : null));
    }
}

