/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.koneki.dashboard.ui.extension;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.koneki.dashboard.ui.AbstractDashboardPage;

public class DashboardInstance {
    private String id;
    private Map<String, AbstractDashboardPage> pagesById;
    private List<AbstractDashboardPage> pages;
    private String firstPageId;
    private int priority = 0;

    public DashboardInstance(String id) {
        this.id = id;
        this.pagesById = new HashMap<String, AbstractDashboardPage>();
        this.pages = new ArrayList<AbstractDashboardPage>();
    }

    public String getId() {
        return this.id;
    }

    public void addPage(String pageId, AbstractDashboardPage page) {
        if (!this.pagesById.containsKey(pageId)) {
            this.pagesById.put(pageId, page);
            this.pages.add(page);
        }
    }

    public Collection<AbstractDashboardPage> getPages() {
        return this.pages;
    }

    public AbstractDashboardPage getPage(String pageId) {
        if (pageId == null || this.pagesById.get(pageId) == null) {
            return this.getFirstPage();
        }
        return this.pagesById.get(pageId);
    }

    public void setFirstPageId(String firstPageId) {
        this.firstPageId = firstPageId;
    }

    public String getFirstPageId() {
        return this.firstPageId;
    }

    public AbstractDashboardPage getFirstPage() {
        return this.getPage(this.getFirstPageId());
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public int getPriority() {
        return this.priority;
    }
}

