/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.koneki.dashboard.ui.extension;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionDelta;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.koneki.dashboard.ui.AbstractDashboardPage;
import org.eclipse.koneki.dashboard.ui.DashboardActivator;
import org.eclipse.koneki.dashboard.ui.extension.AbstractExtensionManager;
import org.eclipse.koneki.dashboard.ui.extension.DashboardBinding;
import org.eclipse.koneki.dashboard.ui.extension.DashboardInstance;

public final class DashboardsManager
extends AbstractExtensionManager {
    public static final String ATT_PERSPECTIVE_ID = "perspectiveID";
    public static final String ATT_DASHBOARD_ID = "dashboardID";
    public static final String ATT_CLASS = "class";
    public static final String DASHBOARDS_EXTENSION_ID = "dashboards";
    public static final String TAG_DASHBOARD = "dashboard";
    public static final String TAG_BINDING = "binding";
    public static final String ATT_ID = "id";
    public static final String ATT_FIRST_PAGE = "firstPage";
    public static final String LAST_PAGE_PROP = "lastPage";
    public static final String ATT_PRIORITY = "priority";
    public static final String ATT_PRODUCT_ID = "productID";
    private static DashboardsManager instance;
    private Map<String, DashboardInstance> dashboards;
    private Map<String, List<DashboardBinding>> bindings4ProductIds;
    private File stateFile;
    private Properties dashboardConfig;

    private DashboardsManager() {
        super("org.eclipse.koneki.dashboard.ui", DASHBOARDS_EXTENSION_ID);
        this.initStateConfig();
        this.invalidateCache(null);
    }

    private void initStateConfig() {
        IPath stateLocation = DashboardActivator.getDefault().getStateLocation();
        String stateLocationPath = stateLocation.toOSString();
        try {
            this.stateFile = new File(String.valueOf(stateLocationPath) + File.separator + "state.dashboard");
            if (!this.stateFile.exists()) {
                this.stateFile.createNewFile();
            }
            this.dashboardConfig = new Properties();
            this.dashboardConfig.load(new FileInputStream(this.stateFile));
        }
        catch (FileNotFoundException e) {
            DashboardActivator.log(e);
        }
        catch (IOException e) {
            DashboardActivator.log(e);
        }
    }

    public void storeDashboardConfig() {
        try {
            this.dashboardConfig.store(new FileOutputStream(this.stateFile), "Last Dashboard state: the key is the dashboard ID and the value the last selected dashboard's page ID.");
        }
        catch (FileNotFoundException e) {
            DashboardActivator.log(e);
        }
        catch (IOException e) {
            DashboardActivator.log(e);
        }
    }

    public static DashboardsManager getInstance() {
        if (instance == null) {
            instance = new DashboardsManager();
        }
        return instance;
    }

    public Collection<DashboardInstance> getDashboards() {
        if (this.dashboards.isEmpty()) {
            this.initializeRegistry();
        }
        return this.dashboards.values();
    }

    private void initializeRegistry() {
        IExtension[] extensions;
        IExtension[] iExtensionArray = extensions = this.getExtensionPoint().getExtensions();
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] elements = extension.getConfigurationElements();
            int i = 0;
            while (i < elements.length) {
                IConfigurationElement element = elements[i];
                if (element.getName().equals(TAG_DASHBOARD)) {
                    DashboardInstance dashboard = this.buildDashboard(element);
                    if (dashboard != null) {
                        this.dashboards.put(dashboard.getId(), dashboard);
                    }
                } else if (element.getName().equals(TAG_BINDING)) {
                    this.bindDashboard(element);
                }
                ++i;
            }
            ++n2;
        }
    }

    private DashboardInstance buildDashboard(IConfigurationElement element) {
        DashboardInstance result = new DashboardInstance(element.getAttribute(ATT_ID));
        try {
            IConfigurationElement[] iConfigurationElementArray = element.getChildren();
            int n = iConfigurationElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement page = iConfigurationElementArray[n2];
                String pageId = page.getAttribute(ATT_ID);
                AbstractDashboardPage dashboardPage = (AbstractDashboardPage)page.createExecutableExtension(ATT_CLASS);
                dashboardPage.setDashboardID(result.getId());
                result.addPage(pageId, dashboardPage);
                String firstPage = page.getAttribute(ATT_FIRST_PAGE);
                boolean isFirstPage = Boolean.parseBoolean(firstPage);
                if (isFirstPage) {
                    result.setFirstPageId(pageId);
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            DashboardActivator.log(e);
        }
        return result;
    }

    private void bindDashboard(IConfigurationElement element) {
        String dashboardId = element.getAttribute(ATT_DASHBOARD_ID);
        String productId = element.getAttribute(ATT_PRODUCT_ID);
        String perspectiveId = element.getAttribute(ATT_PERSPECTIVE_ID);
        String priorityStr = element.getAttribute(ATT_PRIORITY);
        int priority = 0;
        if (priorityStr != null) {
            try {
                priority = Integer.parseInt(priorityStr);
            }
            catch (NumberFormatException nfe) {
                DashboardActivator.log(nfe);
            }
        }
        DashboardBinding dashboardBinding = new DashboardBinding();
        dashboardBinding.setDashboardId(dashboardId);
        dashboardBinding.setProductId(productId);
        dashboardBinding.setPerspectiveId(perspectiveId);
        dashboardBinding.setPriority(priority);
        List<DashboardBinding> dashboardBindings = this.bindings4ProductIds.get(productId);
        if (dashboardBindings == null) {
            dashboardBindings = new ArrayList<DashboardBinding>();
        }
        dashboardBindings.add(dashboardBinding);
        this.bindings4ProductIds.put(productId, dashboardBindings);
    }

    @Override
    protected void invalidateCache(IExtensionDelta[] extensionDeltas) {
        this.dashboards = new HashMap<String, DashboardInstance>();
        this.bindings4ProductIds = new HashMap<String, List<DashboardBinding>>();
    }

    public DashboardInstance getDashboard4Product(String id) {
        List<DashboardBinding> dashboardIds;
        if (this.bindings4ProductIds.isEmpty()) {
            this.initializeRegistry();
        }
        if ((dashboardIds = this.bindings4ProductIds.get(id)) == null) {
            return this.getDefaultDashboardWithHighestPriority();
        }
        return this.getHighestPriorityDashboard(dashboardIds);
    }

    private DashboardInstance getDefaultDashboardWithHighestPriority() {
        DashboardBinding dashboardBindingWithHighestPriority = null;
        for (Map.Entry<String, List<DashboardBinding>> dashboardBindingsForAGivenProduct : this.bindings4ProductIds.entrySet()) {
            for (DashboardBinding dashboardBinding : dashboardBindingsForAGivenProduct.getValue()) {
                if (dashboardBindingWithHighestPriority == null) {
                    dashboardBindingWithHighestPriority = dashboardBinding;
                    continue;
                }
                if (dashboardBinding.getPriority() <= dashboardBindingWithHighestPriority.getPriority()) continue;
                dashboardBindingWithHighestPriority = dashboardBinding;
            }
        }
        if (dashboardBindingWithHighestPriority == null) {
            DashboardActivator.log((IStatus)new Status(4, "org.eclipse.koneki.dashboard.ui", "No Dashboard defined."));
            return null;
        }
        return this.getDashboard(dashboardBindingWithHighestPriority.getDashboardId());
    }

    private DashboardInstance getHighestPriorityDashboard(List<DashboardBinding> dashboardBindings) {
        DashboardBinding dashboardBindingWithHighestPriority = null;
        for (DashboardBinding dashboardBinding : dashboardBindings) {
            if (dashboardBindingWithHighestPriority == null) {
                dashboardBindingWithHighestPriority = dashboardBinding;
                continue;
            }
            if (dashboardBinding.getPriority() <= dashboardBindingWithHighestPriority.getPriority()) continue;
            dashboardBindingWithHighestPriority = dashboardBinding;
        }
        if (dashboardBindingWithHighestPriority == null) {
            DashboardActivator.log((IStatus)new Status(4, "org.eclipse.koneki.dashboard.ui", "No Dashboard found for the current product."));
            return null;
        }
        return this.getDashboard(dashboardBindingWithHighestPriority.getDashboardId());
    }

    public DashboardInstance getDashboard(String dashboardId) {
        return this.dashboards.get(dashboardId);
    }

    public File getDashboardStateFile() {
        return this.stateFile;
    }

    public AbstractDashboardPage getLastPage() {
        String property = this.dashboardConfig.getProperty(LAST_PAGE_PROP);
        if (property == null) {
            return null;
        }
        String[] split = property.split("#");
        String dashboardId = split[0];
        String pageId = split[1];
        DashboardInstance dashboard = DashboardsManager.getInstance().getDashboard(dashboardId);
        if (dashboard == null) {
            DashboardActivator.log((IStatus)new Status(2, "org.eclipse.koneki.dashboard.ui", "No Dashboard found with the ID '" + dashboardId + "'"));
            return null;
        }
        return dashboard.getPage(pageId);
    }

    public boolean isStarted(DashboardInstance dashboard) {
        return this.dashboardConfig.getProperty(dashboard.getId()) != null;
    }

    public AbstractDashboardPage getLastPageForDashboard(DashboardInstance dashboard) {
        String pageId = this.dashboardConfig.getProperty(dashboard.getId());
        AbstractDashboardPage page = dashboard.getPage(pageId);
        if (pageId == null) {
            this.dashboardConfig.setProperty(dashboard.getId(), page.getId());
            this.dashboardConfig.setProperty(LAST_PAGE_PROP, String.valueOf(dashboard.getId()) + "#" + page.getId());
        }
        DashboardsManager.getInstance().storeDashboardConfig();
        return dashboard.getPage(pageId);
    }

    public void switchPage(String dashboardId, String pageId) {
        this.dashboardConfig.setProperty(dashboardId, pageId);
        this.dashboardConfig.setProperty(LAST_PAGE_PROP, String.valueOf(dashboardId) + "#" + pageId);
        this.storeDashboardConfig();
    }
}

