/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.koneki.tema.core.internal.model;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.koneki.tema.core.I18N;
import org.eclipse.koneki.tema.core.exceptions.TemplateSiteException;
import org.eclipse.koneki.tema.core.model.ITemplate;
import org.eclipse.koneki.tema.core.model.ITemplateFilter;
import org.eclipse.koneki.tema.core.model.ITemplateSite;
import org.eclipse.koneki.tema.core.model.Template;
import org.eclipse.koneki.tema.core.util.SPath;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class TemplateSite
implements ITemplateSite {
    private static final String DEFINITION_FILE = "templates.xml";
    private String _name;
    private URL _url;
    private URL _definitionUrl;
    private boolean _hasCache = false;
    private Collection<ITemplate> _cache;

    public TemplateSite(URL url, String name) {
        this.setURL(url);
        this.setName(name);
        this._cache = new ArrayList<ITemplate>();
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public void setName(String name) {
        if (name == null || "".equals(name)) {
            throw new IllegalArgumentException(I18N.getResourceString("exceptions.attribute.mandatory", new String[]{this.getClass().toString(), "name"}));
        }
        this._name = name;
    }

    @Override
    public URL getURL() {
        return this._url;
    }

    @Override
    public void setURL(URL url) {
        if (url == null) {
            throw new IllegalArgumentException(I18N.getResourceString("exceptions.attribute.mandatory", new String[]{this.getClass().toString(), "url"}));
        }
        try {
            String tmpUrl = url.toString();
            if (!tmpUrl.endsWith("/")) {
                tmpUrl = tmpUrl.concat("/");
            }
            tmpUrl = tmpUrl.concat(DEFINITION_FILE);
            this._definitionUrl = new URL(tmpUrl);
        }
        catch (MalformedURLException malformedURLException) {
            throw new IllegalArgumentException(I18N.getResourceString("exception.argument.invalid", new String[]{this.getClass().toString(), "url", url.toString()}));
        }
        this._url = url;
    }

    @Override
    public Collection<ITemplate> getTemplates(boolean clearCache) throws TemplateSiteException {
        if (clearCache || !this._hasCache) {
            try {
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                DocumentBuilder db = dbf.newDocumentBuilder();
                Document dom = db.parse(this._getDefinitionStream());
                this._cache.clear();
                Iterator<?> it = SPath.getIterator(dom.getDocumentElement(), "*");
                while (it.hasNext()) {
                    try {
                        Template template = new Template(this.getURL(), (Element)it.next());
                        this._cache.add(template);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {}
                }
            }
            catch (ParserConfigurationException pce) {
                throw new TemplateSiteException(I18N.getResourceString("exception.templateSite.cannotBuildParser", this.getName()), pce, this);
            }
            catch (IOException ioe) {
                throw new TemplateSiteException(I18N.getResourceString("exception.templateSite.cannotParseDefinition", this.getName()), ioe, this);
            }
            catch (SAXException pe) {
                throw new TemplateSiteException(I18N.getResourceString("exception.templateSite.invalidDefinition", this.getName()), pe, this);
            }
        }
        return this._cache;
    }

    @Override
    public Collection<ITemplate> getTemplates(boolean clearCache, ITemplateFilter[] filters) throws TemplateSiteException {
        Collection<ITemplate> templates = this.getTemplates(clearCache);
        int i = 0;
        while (i < filters.length) {
            ITemplateFilter filter = filters[i];
            if (filter != null) {
                templates = filters[i].apply(templates);
            }
            ++i;
        }
        return templates;
    }

    @Override
    public void test() throws TemplateSiteException {
        try {
            this._definitionUrl.openStream();
        }
        catch (IOException ioe) {
            throw new TemplateSiteException(I18N.getResourceString("exception.templateSite.notAvailable", new String[]{this.getName(), this.getURL().toString()}), ioe, this);
        }
    }

    public String toString() {
        return this.getName();
    }

    private InputStream _getDefinitionStream() throws TemplateSiteException {
        this.test();
        try {
            return this._definitionUrl.openStream();
        }
        catch (IOException ioe) {
            throw new TemplateSiteException(I18N.getResourceString("exception.templateSite.notAvailable", new String[]{this.getName(), this.getURL().toString()}), ioe, this);
        }
    }
}

