/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.koneki.tema.core.model;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.eclipse.koneki.tema.core.I18N;
import org.eclipse.koneki.tema.core.exceptions.TemplateException;
import org.eclipse.koneki.tema.core.internal.model.Parameter;
import org.eclipse.koneki.tema.core.internal.model.ParseSet;
import org.eclipse.koneki.tema.core.internal.model.TemplateSiteClassLoader;
import org.eclipse.koneki.tema.core.model.IParameter;
import org.eclipse.koneki.tema.core.model.IParseSet;
import org.eclipse.koneki.tema.core.model.ITemplate;
import org.eclipse.koneki.tema.core.model.ITemplateListener;
import org.eclipse.koneki.tema.core.util.FileUtils;
import org.eclipse.koneki.tema.core.util.SPath;
import org.w3c.dom.Element;

public class Template
implements ITemplate {
    public static final String PROJECT_NAME_PARAMETER = "projectName";
    private static final char DEFAULT_DELIMITER = '%';
    private static final char ESCAPE = '\\';
    private static final String TRANSLATION_IDENTIFIER = "%";
    private static final int DOWNLOAD_STARTED = 1;
    private static final int TEMPLATE_UNZIPPING = 2;
    private static final int TEMPLATE_UNZIPPED = 3;
    private static final int PARAMETERS_PROCESS = 4;
    private static final int DOWNLOAD_FINISHED = 5;
    private String _name;
    private String _version;
    private String _description;
    private List<String> _natures;
    private String _content;
    private String _projectName;
    private Map<String, IParameter> _parameters;
    private URL _baseUrl;
    private URL _url;
    private Collection<ITemplateListener> _listeners;
    private ResourceBundle _bundle;
    private char _delimiter;
    private IParseSet _parseSet;
    private Collection<String> _parsedFiles;

    public Template(URL baseUrl) {
        if (baseUrl == null) {
            throw new IllegalArgumentException(I18N.getResourceString("exception.argument.mandatory", new String[]{this.getClass().toString(), "baseURL"}));
        }
        try {
            this._natures = new ArrayList<String>();
            this._parameters = new LinkedHashMap<String, IParameter>();
            this._listeners = new ArrayList<ITemplateListener>();
            this._baseUrl = baseUrl;
            String url = baseUrl.toString();
            if (!url.endsWith("/")) {
                this._baseUrl = new URL(String.valueOf(url) + "/");
            }
        }
        catch (MalformedURLException malformedURLException) {
            throw new IllegalArgumentException(I18N.getResourceString("exception.argument.invalid", new String[]{this.getClass().toString(), "baseUrl", baseUrl.toString()}));
        }
        TemplateSiteClassLoader classLoader = AccessController.doPrivileged(new PrivilegedAction<TemplateSiteClassLoader>(){

            @Override
            public TemplateSiteClassLoader run() {
                return new TemplateSiteClassLoader(Template.this._baseUrl);
            }
        });
        try {
            this._bundle = ResourceBundle.getBundle("templates", Locale.getDefault(), classLoader);
        }
        catch (MissingResourceException missingResourceException) {
            this._bundle = null;
        }
    }

    public Template(URL baseUrl, Element element) {
        this(baseUrl);
        this.setName(this._getTranslatedValue(element, "@name"));
        this.setVersion(this._getTranslatedValue(element, "@version"));
        this.setDescription(this._getTranslatedValue(element, "description"));
        char delimiter = '\u0000';
        String strDelimiter = SPath.getValue(element, "@delimiter");
        if (strDelimiter != null) {
            delimiter = strDelimiter.toCharArray()[0];
        }
        this.setParameterDelimiter(delimiter);
        Iterator<?> it = SPath.getIterator(element, "natures/nature");
        while (it.hasNext()) {
            this.addNature(SPath.getValue((Element)it.next()));
        }
        if (!this.hasNatures()) {
            throw new IllegalArgumentException(I18N.getResourceString("exception.template.noNatures", this.getName()));
        }
        this.setContent(SPath.getValue(element, "content"));
        it = SPath.getIterator(element, "parameters/parameter");
        while (it.hasNext()) {
            Element param = (Element)it.next();
            String name = SPath.getValue(param, "@name");
            String displayName = this._getTranslatedValue(param, "@displayName");
            String value = this._getTranslatedValue(param, "@value");
            String description = this._getTranslatedValue(param, "description");
            String regExp = SPath.getValue(param, "@regExp");
            if (PROJECT_NAME_PARAMETER.equals(name)) {
                this.setProjectName(value);
                continue;
            }
            Parameter parameter = new Parameter(name, displayName, value, description);
            parameter.setRegExp(regExp);
            try {
                this.addParameter(parameter, false);
            }
            catch (TemplateException te) {
                throw new IllegalArgumentException(te.getMessage());
            }
        }
        this._parseSet = new ParseSet(SPath.findNamedElement(element, "parseSet"));
    }

    @Override
    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        if (name == null || "".equals(name)) {
            throw new IllegalArgumentException(I18N.getResourceString("exception.argument.mandatory", new String[]{this.getClass().toString(), "name"}));
        }
        this._name = name;
    }

    @Override
    public String getVersion() {
        return this._version;
    }

    public void setVersion(String version) {
        if (version == null || "".equals(version)) {
            throw new IllegalArgumentException(I18N.getResourceString("exception.argument.mandatory", new String[]{this.getClass().toString(), "version"}));
        }
        this._version = version;
    }

    @Override
    public String getDescription() {
        return this._description;
    }

    public void setDescription(String description) {
        this._description = description;
    }

    @Override
    public Collection<String> getNatures() {
        return this._natures;
    }

    public void addNature(String nature) {
        if (nature == null || "".equals(nature)) {
            throw new IllegalArgumentException(I18N.getResourceString("exception.argument.mandatory", new String[]{this.getClass().toString(), "nature"}));
        }
        if (!this.hasNature(nature)) {
            this._natures.add(nature);
        }
    }

    @Override
    public boolean hasNatures() {
        return this.getNatures().size() != 0;
    }

    @Override
    public boolean hasNature(String nature) {
        if (nature == null || "".equals(nature)) {
            return false;
        }
        return this._natures.contains(nature);
    }

    @Override
    public String getContent() {
        return this._content;
    }

    @Override
    public String getProjectName() {
        return this._projectName;
    }

    @Override
    public void setProjectName(String name) {
        this._projectName = name;
    }

    @Override
    public URL getURL() {
        return this._url;
    }

    public void setContent(String content) {
        if (content == null || "".equals(content)) {
            throw new IllegalArgumentException(I18N.getResourceString("exceptions.argument.mandatory", new String[]{this.getClass().toString(), "content"}));
        }
        try {
            this._url = new URL(content);
        }
        catch (MalformedURLException malformedURLException) {
            try {
                this._url = new URL(this._baseUrl, content);
            }
            catch (MalformedURLException malformedURLException2) {
                throw new IllegalArgumentException(I18N.getResourceString("exception.argument.invalid", new String[]{this.getClass().toString(), "content", content}));
            }
        }
        this._content = content;
    }

    @Override
    public Collection<IParameter> getParameters() {
        return this._parameters.values();
    }

    @Override
    public IParameter getParameter(String name) {
        if (name == null || "".equals(name)) {
            return null;
        }
        return this._parameters.get(name);
    }

    public void addParameter(IParameter parameter, boolean overwrite) throws TemplateException {
        if (parameter == null) {
            throw new IllegalArgumentException(I18N.getResourceString("exception.argument.mandatory", "parameter"));
        }
        if (!overwrite && this.hasParameter(parameter)) {
            throw new TemplateException(I18N.getResourceString("exception.template.hasAlreadyParameter", new String[]{this.getName(), parameter.getName()}), this);
        }
        this._parameters.put(parameter.getName(), parameter);
    }

    @Override
    public boolean hasParameters() {
        return !this._parameters.isEmpty();
    }

    @Override
    public boolean hasParameter(String name) {
        if (name == null || "".equals(name)) {
            return false;
        }
        return this._parameters.containsKey(name);
    }

    @Override
    public boolean hasParameter(IParameter parameter) {
        if (parameter == null) {
            return false;
        }
        return this._parameters.containsValue(parameter);
    }

    @Override
    public void clearParametersValues() {
        Iterator<IParameter> it = this.getParameters().iterator();
        while (it.hasNext()) {
            it.next().setValue(null);
        }
    }

    @Override
    public void download(File destination) throws TemplateException {
        this._fireTemplateEvent(1);
        boolean canDelete = false;
        if (destination == null) {
            throw new IllegalArgumentException(I18N.getResourceString("exception.argument.mandatory", new String[]{this.getClass().toString(), "destination"}));
        }
        if (!this.exists()) {
            throw new TemplateException(I18N.getResourceString("exception.template.notAvailable", new String[]{this.getName(), this.getURL().toString()}), this);
        }
        this._parsedFiles = new ArrayList<String>();
        File template = destination;
        if (!destination.exists()) {
            destination.mkdirs();
            canDelete = true;
        }
        try {
            this._fireTemplateEvent(2);
            InputStream is = this.getURL().openStream();
            ZipInputStream zis = new ZipInputStream(is);
            this._unZIP(zis, destination);
            is.close();
            zis.close();
            this._fireTemplateEvent(3);
            this._fireTemplateEvent(4);
            File[] files = destination.listFiles();
            int i = 0;
            while (i < files.length) {
                this._processFile(files[i], destination);
                ++i;
            }
            this._fireTemplateEvent(5);
        }
        catch (IOException e) {
            if (canDelete) {
                FileUtils.deleteDirectory(template);
            } else {
                this._deleteDownloadedResources(destination);
            }
            throw new TemplateException(I18N.getResourceString("exception.template.notAvailable", new String[]{this.getName(), this.getURL().toString()}), e, this);
        }
    }

    @Override
    public File downloadWithCache(File destination, File cache, boolean putInCache) throws TemplateException {
        String file = this.getURL().toString();
        File copy = new File(cache, file.substring(file.lastIndexOf(47) + 1));
        if (putInCache) {
            try {
                copy = this.copy(cache);
            }
            catch (TemplateException te) {
                throw new TemplateException(I18N.getResourceString("exception.template.notPutInCache", this.getName()), te, this);
            }
        }
        URL saveUrl = this.getURL();
        try {
            this._url = copy.toURI().toURL();
            this.download(destination);
            this._url = saveUrl;
            return copy;
        }
        catch (IOException e) {
            throw new TemplateException(I18N.getResourceString("exception.template.cannotGetCache", this.getName()), e, this);
        }
    }

    @Override
    public File copy(File destination) throws TemplateException {
        if (destination == null) {
            throw new IllegalArgumentException(I18N.getResourceString("exception.argument.mandatory", new String[]{this.getClass().toString(), "destination"}));
        }
        if (!this.exists()) {
            throw new TemplateException(I18N.getResourceString("exception.template.notAvailable", new String[]{this.getName(), this.getURL().toString()}), this);
        }
        if (!destination.exists()) {
            destination.mkdirs();
        }
        String file = this.getURL().toString();
        File template = new File(destination, file.substring(file.lastIndexOf(47) + 1));
        try {
            template.createNewFile();
            InputStream is = this.getURL().openStream();
            FileUtils.copyStream(is, template);
            return template;
        }
        catch (IOException e) {
            template.delete();
            throw new TemplateException(I18N.getResourceString("exception.template.notAvailable", new String[]{this.getName(), this.getURL().toString()}), e, this);
        }
    }

    @Override
    public boolean exists() {
        URL tplURL = this.getURL();
        if (tplURL == null) {
            return false;
        }
        try {
            InputStream is = tplURL.openStream();
            return is != null;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public void addTemplateListener(ITemplateListener listener) {
        if (listener != null && !this._listeners.contains(listener)) {
            this._listeners.add(listener);
        }
    }

    @Override
    public void removeTemplateListener(ITemplateListener listener) {
        this._listeners.remove(listener);
    }

    @Override
    public char getParameterDelimiter() {
        if (this._delimiter == '\u0000') {
            this._delimiter = (char)37;
        }
        return this._delimiter;
    }

    public void setParameterDelimiter(char delimiter) {
        this._delimiter = delimiter;
    }

    @Override
    public IParseSet getParseSet() {
        return this._parseSet;
    }

    public void setParseSet(IParseSet parseSet) {
        this._parseSet = parseSet;
    }

    public Collection<String> getParsedFiles() {
        return this._parsedFiles != null ? this._parsedFiles : Collections.emptyList();
    }

    protected void _fireTemplateEvent(int eventType) {
        for (ITemplateListener listener : this._listeners) {
            switch (eventType) {
                case 1: {
                    listener.downloadStarted();
                    break;
                }
                case 2: {
                    listener.templateUnzipping();
                    break;
                }
                case 3: {
                    listener.templateUnzipped();
                    break;
                }
                case 4: {
                    listener.parametersProcess();
                    break;
                }
                case 5: {
                    listener.downloadFinished();
                }
            }
        }
    }

    private void _unZIP(ZipInputStream zis, File destination) throws TemplateException {
        try {
            ZipEntry ze = zis.getNextEntry();
            while (ze != null) {
                String name = this._getProcessedString(ze.getName());
                File file = new File(destination, name);
                File parentDir = file.getParentFile();
                if (parentDir != null) {
                    parentDir.mkdirs();
                }
                if (ze.isDirectory()) {
                    file.mkdirs();
                } else {
                    int length;
                    FileOutputStream fos = new FileOutputStream(file);
                    byte[] buffer = new byte[8192];
                    while ((length = zis.read(buffer)) != -1) {
                        fos.write(buffer, 0, length);
                    }
                    fos.close();
                }
                ze = zis.getNextEntry();
            }
        }
        catch (IOException ioe) {
            throw new TemplateException(I18N.getResourceString("exception.template.cannotReadZIPFile", new String[]{this.getName(), this.getURL().toString()}), ioe, this);
        }
    }

    private String _getProcessedString(String source) throws TemplateException {
        if (source.indexOf(this.getParameterDelimiter()) == -1) {
            return source;
        }
        StringBuffer processed = new StringBuffer();
        boolean replace = false;
        int start = -1;
        int i = 0;
        while (i < source.length()) {
            char c = source.charAt(i);
            if (c == this.getParameterDelimiter()) {
                if (replace) {
                    String param = source.substring(start, i);
                    String value = null;
                    if (PROJECT_NAME_PARAMETER.equals(param)) {
                        value = this.getProjectName();
                    } else {
                        IParameter parameter = this.getParameter(param);
                        if (parameter != null) {
                            value = parameter.getValue();
                        }
                    }
                    if (value == null) {
                        processed.append(this.getParameterDelimiter());
                        processed.append(param);
                        start = i + 1;
                    } else {
                        processed.append(value);
                        replace = false;
                    }
                } else {
                    replace = true;
                    start = i + 1;
                }
            } else if (!replace) {
                processed.append(c);
            }
            ++i;
        }
        if (replace) {
            processed.append(this.getParameterDelimiter());
            processed.append(source.substring(start));
        }
        return processed.toString();
    }

    private void _processFile(File file, File destination) throws TemplateException {
        FileInputStream is = null;
        InputStreamReader reader = null;
        FileOutputStream fos = null;
        try {
            if (file.isDirectory()) {
                File[] files = file.listFiles();
                int i = 0;
                while (i < files.length) {
                    this._processFile(files[i], destination);
                    ++i;
                }
                return;
            }
            if (file.isFile() && ".temaignore".equals(file.getName())) {
                file.delete();
                return;
            }
            String relativePath = file.getAbsolutePath().substring(destination.getAbsolutePath().length() + 1);
            if (this._parseSet != null && !this._parseSet.mustParse(relativePath)) {
                return;
            }
            try {
                is = new FileInputStream(file);
                reader = new InputStreamReader(is);
                StringBuffer outBuffer = new StringBuffer();
                StringBuffer paramBuffer = new StringBuffer();
                char[] buffer = new char[1024];
                int read = 0;
                boolean escape = false;
                boolean replace = false;
                while (read != -1) {
                    read = reader.read(buffer);
                    int i = 0;
                    while (i < read) {
                        char c = buffer[i];
                        if (escape) {
                            if (c != this.getParameterDelimiter()) {
                                if (!replace) {
                                    outBuffer.append('\\');
                                } else {
                                    paramBuffer.append('\\');
                                }
                            }
                            if (!replace) {
                                outBuffer.append(c);
                            } else {
                                paramBuffer.append(c);
                            }
                            escape = false;
                        } else if (c == this.getParameterDelimiter()) {
                            if (replace) {
                                String param = paramBuffer.toString();
                                String value = null;
                                if (PROJECT_NAME_PARAMETER.equals(param)) {
                                    value = this.getProjectName();
                                    if (value != null && ".project".equals(file.getName())) {
                                        byte[] utf8 = value.getBytes("UTF-8");
                                        value = new String(utf8);
                                    }
                                } else {
                                    IParameter parameter = this.getParameter(param);
                                    if (parameter != null) {
                                        value = parameter.getValue();
                                    }
                                }
                                if (value == null) {
                                    outBuffer.append(this.getParameterDelimiter());
                                    outBuffer.append(paramBuffer);
                                } else {
                                    outBuffer.append(value);
                                    replace = false;
                                }
                                paramBuffer.delete(0, paramBuffer.length());
                            } else {
                                replace = true;
                            }
                        } else if (c == '\\') {
                            escape = true;
                        } else if (replace) {
                            paramBuffer.append(c);
                        } else {
                            outBuffer.append(c);
                        }
                        ++i;
                    }
                }
                if (replace) {
                    outBuffer.append(this.getParameterDelimiter());
                    outBuffer.append(paramBuffer);
                }
                fos = new FileOutputStream(file);
                fos.write(outBuffer.toString().getBytes());
                fos.flush();
                this._parsedFiles.add(file.getAbsolutePath());
            }
            catch (IOException e) {
                throw new TemplateException(I18N.getResourceString("exception.template.cannotReplaceParameter", this.getName()), e, this);
            }
        }
        finally {
            try {
                if (fos != null) {
                    fos.close();
                }
                if (reader != null) {
                    reader.close();
                }
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException ioe) {
                throw new TemplateException(I18N.getResourceString("exception.template.cannotReplaceParameter", this.getName()), ioe, this);
            }
        }
    }

    private void _deleteDownloadedResources(File destination) throws TemplateException {
        if (destination == null) {
            return;
        }
        ZipInputStream zis = null;
        try {
            try {
                InputStream is = this.getURL().openStream();
                zis = new ZipInputStream(is);
                ArrayList<File> parentDirectories = new ArrayList<File>();
                ZipEntry ze = zis.getNextEntry();
                while (ze != null) {
                    File file = new File(destination, this._getProcessedString(ze.getName()));
                    if (file.exists()) {
                        File parent = file.getParentFile();
                        if (parent != destination) {
                            parentDirectories.add(parent);
                        }
                        file.delete();
                    }
                    int i = 0;
                    while (i < parentDirectories.size()) {
                        File dir = (File)parentDirectories.get(i);
                        if (dir.isDirectory()) {
                            dir.delete();
                        }
                        ++i;
                    }
                    ze = zis.getNextEntry();
                }
            }
            catch (IOException e) {
                throw new TemplateException(I18N.getResourceString("exception.template.cannotDeleteResources", this.getName()), e, this);
            }
        }
        finally {
            try {
                zis.close();
            }
            catch (IOException ioe) {
                throw new TemplateException(I18N.getResourceString("exception.template.cannotDeleteResources", this.getName()), ioe, this);
            }
        }
    }

    private String _getTranslation(String key) {
        try {
            return this._bundle != null ? this._bundle.getString(key) : key;
        }
        catch (MissingResourceException missingResourceException) {
            return key;
        }
    }

    private String _getTranslatedValue(Element contextElt, String path) {
        String value = SPath.getValue(contextElt, path);
        if (value == null) {
            return null;
        }
        if (!value.startsWith(TRANSLATION_IDENTIFIER)) {
            return value;
        }
        return this._getTranslation(value.substring(TRANSLATION_IDENTIFIER.length()));
    }
}

