/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.koneki.tema.core.util;

import org.eclipse.koneki.tema.core.util.StringUtils;

public final class NameController {
    public static final char[] FORBIDDEN_CHARS = new char[]{' ', ',', '?', ';', '.', ':', '/', '!', '\ufffd', '\ufffd', '%', '*', '\ufffd', '\ufffd', '\ufffd', '&', '\ufffd', '\"', '#', '~', '\'', '{', '(', '[', '|', '\ufffd', '`', '\\', '\ufffd', '^', '\ufffd', '@', ')', ']', '\ufffd', '+', '=', '}', '\ufffd', '-', '<', '>', '\ufffd', '\ufffd', '\ufffd', '\ufffd', '\ufffd'};
    public static final String[] FORBIDDEN_JAVA_WORDS = new String[]{"abstract", "case", "catch", "class", "const", "default", "else", "extends", "final", "implements", "import", "new", "package", "private", "protected", "public", "return", "static", "super", "this", "transient", "void", "int", "Integer", "double", "Double", "short", "Short", "long", "Long", "byte", "Byte", "float", "Float", "String", "boolean", "Boolean"};
    public static final String[] FORBIDDEN_SQL_WORDS = new String[]{"access", "add", "all", "alter", "and", "any", "as", "asc", "audit", "between", "by", "char", "check", "cluster", "column", "comment", "compress", "connect", "create", "current", "date", "decimal", "default", "delete", "desc", "distinct", "drop", "else", "exclusive", "exists", "file", "float", "for", "from", "grant", "group", "having", "identified", "immediate", "in", "increment", "index", "initial", "insert", "integer", "intersect", "into", "is", "level", "like", "lock", "long", "maxextents", "minus", "mode", "modify", "noaudit", "nocompress", "not", "nowait", "null", "number", "of", "offline", "on", "online", "option", "or", "order", "pctfree", "prior", "privileges", "public", "raw", "rename", "resource", "revoke", "row", "rowid", "rowlabel", "rownum", "rows", "select", "session", "set", "share", "size", "smallint", "start", "successful", "synonym", "sysdate", "table", "then", "to", "trigger", "uid", "union", "unique", "update", "user", "validate", "values", "varchar", "varchar2", "view", "whenever", "where", "with"};
    private static final String FORBIDDEN_CHARS_STRING = new String(FORBIDDEN_CHARS);

    private NameController() {
    }

    public static boolean validName(String name) {
        if (name.equals("")) {
            return false;
        }
        if (name.equals("Deploy")) {
            return false;
        }
        int i = 0;
        while (i < name.length()) {
            if (FORBIDDEN_CHARS_STRING.indexOf(name.charAt(i)) != -1) {
                return false;
            }
            ++i;
        }
        if (NameController.isJavaKeyword(name)) {
            return false;
        }
        if (NameController.isSQLKeyword(name)) {
            return false;
        }
        if (NameController.isStartingByANumber(name)) {
            return false;
        }
        return !NameController.isStartingOrEndingByUnderscore(name);
    }

    private static boolean isStartingOrEndingByUnderscore(String name) {
        return name.startsWith("_") || name.endsWith("_");
    }

    public static boolean isJavaKeyword(String name) {
        int i = 0;
        while (i < FORBIDDEN_JAVA_WORDS.length) {
            String keyword = FORBIDDEN_JAVA_WORDS[i];
            if (name.equalsIgnoreCase(keyword)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isSQLKeyword(String name) {
        int i = 0;
        while (i < FORBIDDEN_SQL_WORDS.length) {
            String keyword = FORBIDDEN_SQL_WORDS[i];
            if (name.equalsIgnoreCase(keyword)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isStartingByANumber(String name) {
        return StringUtils.getInteger(name.substring(0, 1)) > -1;
    }
}

