/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.koneki.commons.ui;

import java.util.HashMap;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Display;

public final class FontsRegistry {
    private static FontsRegistry instance;
    private static HashMap<String, Font> resources;
    private Runnable displayRunnable = new Runnable(){

        @Override
        public void run() {
            FontsRegistry.dispose();
        }
    };

    static {
        resources = new HashMap();
    }

    private FontsRegistry() {
        Display.getCurrent().disposeExec(this.displayRunnable);
    }

    public static void dispose() {
        for (String fontName : resources.keySet()) {
            resources.get(fontName).dispose();
        }
        resources.clear();
    }

    public static FontsRegistry getInstance() {
        if (instance == null) {
            instance = new FontsRegistry();
        }
        return instance;
    }

    public Font get(int size, int style) {
        String fontName = String.valueOf(size) + "|" + style;
        if (resources.containsKey(fontName)) {
            return resources.get(fontName);
        }
        FontData fd = new FontData(fontName, size, style);
        Font font = new Font((Device)Display.getDefault(), fd);
        resources.put(fontName, font);
        return font;
    }
}

