/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.koneki.dashboard.ui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.koneki.commons.ui.ANWRTToolkit;
import org.eclipse.koneki.dashboard.ui.AbstractDashboardPage;
import org.eclipse.koneki.dashboard.ui.DashboardOutline;
import org.eclipse.koneki.dashboard.ui.extension.DashboardInstance;
import org.eclipse.koneki.dashboard.ui.extension.DashboardsManager;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public class Dashboard
extends EditorPart
implements ISelectionProvider {
    public static final String ID = "org.eclipse.koneki.dashboard.ui";
    public static final String LAST_PAGE_PROP = "lastPage";
    private ANWRTToolkit toolkit = new ANWRTToolkit(Display.getDefault());
    private Composite baseComposite;
    private Composite pagesStackComposite;
    private StackLayout pagesStackLayout;
    private DashboardOutline dashboardOutline;
    private AbstractDashboardPage lastPageForDashboard;
    private List<ISelectionChangedListener> listeners = new ArrayList<ISelectionChangedListener>();

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void createPartControl(Composite parent) {
        this.baseComposite = this.toolkit.createComposite(parent);
        this.toolkit.adapt(this.baseComposite);
        GridLayoutFactory.fillDefaults().margins(0, 0).applyTo(this.baseComposite);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.baseComposite);
        this.pagesStackComposite = this.toolkit.createComposite(this.baseComposite);
        this.pagesStackLayout = new StackLayout();
        this.pagesStackComposite.setLayout((Layout)this.pagesStackLayout);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.pagesStackComposite);
        this.addPages(this.pagesStackComposite);
        this.selectPage();
    }

    private void selectPage() {
        this.lastPageForDashboard = DashboardsManager.getInstance().getLastPage();
        if (this.lastPageForDashboard == null) {
            String productId = Platform.getProduct().getId();
            DashboardInstance dashboardInstance = DashboardsManager.getInstance().getDashboard4Product(productId);
            this.lastPageForDashboard = DashboardsManager.getInstance().getLastPageForDashboard(dashboardInstance);
        }
        if (this.lastPageForDashboard != null) {
            this.pagesStackLayout.topControl = this.lastPageForDashboard.getPageControl();
            this.pagesStackComposite.layout();
        }
    }

    private void addPages(Composite parent) {
        Collection<DashboardInstance> dashboards = DashboardsManager.getInstance().getDashboards();
        for (DashboardInstance dashboardInstance : dashboards) {
            Collection<AbstractDashboardPage> pages = dashboardInstance.getPages();
            for (AbstractDashboardPage abstractDashboardPage : pages) {
                abstractDashboardPage.setDashboard(this);
                abstractDashboardPage.createContent(parent);
            }
        }
    }

    public void setFocus() {
        this.pagesStackComposite.setFocus();
    }

    public void switchPage(String dashboardId, String pageId) {
        this.switchPage(dashboardId, null, pageId);
    }

    public void switchPage(String dashboardID, String previousPageID, String nextPageID) {
        this.switchPage(dashboardID, previousPageID, nextPageID, true);
    }

    public void switchPage(String dashboardID, String previousPageID, String nextPageID, boolean changeFromPage) {
        DashboardInstance dashboardInstance = DashboardsManager.getInstance().getDashboard(dashboardID);
        this.lastPageForDashboard = dashboardInstance.getPage(nextPageID);
        if (changeFromPage) {
            if (previousPageID == null) {
                this.lastPageForDashboard.setFromPage(this.lastPageForDashboard.getDefaultPreviousPage());
            } else {
                this.lastPageForDashboard.setFromPage(previousPageID);
            }
        }
        this.pagesStackLayout.topControl = this.lastPageForDashboard.getPageControl();
        this.pagesStackComposite.layout();
        DashboardsManager.getInstance().switchPage(dashboardID, nextPageID);
        this.getOutlinePage().setSelection((ISelection)new StructuredSelection((Object)this.lastPageForDashboard));
    }

    public void switchtoPrevious(String dashboardID, String pageID) {
        this.switchPage(dashboardID, null, pageID, false);
    }

    public Object getAdapter(Class adapter) {
        return super.getAdapter(adapter);
    }

    private IContentOutlinePage getOutlinePage() {
        if (this.dashboardOutline == null || this.dashboardOutline.getControl() != null && this.dashboardOutline.getControl().isDisposed()) {
            this.dashboardOutline = new DashboardOutline(this);
            this.dashboardOutline.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    IStructuredSelection sel = (IStructuredSelection)event.getSelection();
                    Dashboard.this.setSelection((ISelection)sel);
                }
            });
        }
        return this.dashboardOutline;
    }

    public ANWRTToolkit getToolkit() {
        return this.toolkit;
    }

    public void switchPage(AbstractDashboardPage page) {
        this.switchPage(page.getDashboardID(), page.getId());
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public ISelection getSelection() {
        if (this.lastPageForDashboard == null) {
            return StructuredSelection.EMPTY;
        }
        return new StructuredSelection((Object)this.lastPageForDashboard);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.listeners.remove(listener);
    }

    public void setSelection(ISelection selection) {
        IStructuredSelection sel = (IStructuredSelection)selection;
        AbstractDashboardPage page = (AbstractDashboardPage)sel.getFirstElement();
        this.switchPage(page);
    }
}

