/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.koneki.dashboard.ui;

import java.io.File;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.Platform;
import org.eclipse.koneki.dashboard.ui.DashboardActivator;
import org.eclipse.koneki.dashboard.ui.extension.DashboardInstance;
import org.eclipse.koneki.dashboard.ui.extension.DashboardsManager;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

public class DashboardStarter
implements IStartup {
    private IWorkbenchPage activePage;

    public void earlyStartup() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
        if (window != null) {
            this.activePage = window.getActivePage();
        }
        if (this.activePage == null) {
            IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
            int i = 0;
            while (i < windows.length) {
                if (windows[i] != null) {
                    this.activePage = windows[i].getActivePage();
                    if (this.activePage != null) break;
                }
                ++i;
            }
        }
        if (this.activePage != null) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    DashboardStarter.this.checkAndStartDashboard();
                }
            });
        }
    }

    private void checkAndStartDashboard() {
        String productId = Platform.getProduct().getId();
        DashboardInstance dashboard = DashboardsManager.getInstance().getDashboard4Product(productId);
        if (dashboard != null && !DashboardsManager.getInstance().isStarted(dashboard)) {
            this.startDashboard(dashboard);
        }
    }

    private void startDashboard(DashboardInstance dashboard) {
        File stateFile = DashboardsManager.getInstance().getDashboardStateFile();
        if (stateFile.exists() && stateFile.isFile()) {
            IFileStore fileStore = EFS.getLocalFileSystem().getStore(stateFile.toURI());
            try {
                IDE.openEditorOnFileStore((IWorkbenchPage)this.activePage, (IFileStore)fileStore);
            }
            catch (PartInitException e) {
                DashboardActivator.log(e);
            }
        }
    }
}

