/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.koneki.dashboard.ui.extension;

import org.eclipse.core.expressions.ElementHandler;
import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionConverter;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionDelta;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.core.runtime.Platform;
import org.eclipse.koneki.dashboard.ui.DashboardActivator;

public abstract class AbstractExtensionManager
implements IRegistryChangeListener {
    public static final String TAG_ENABLEMENT = "enablement";
    private final String namespace;
    private final String extensionPoint;

    public AbstractExtensionManager(String namespace, String extensionPoint) {
        this.namespace = namespace;
        this.extensionPoint = extensionPoint;
    }

    protected IExtensionPoint getExtensionPoint() {
        return Platform.getExtensionRegistry().getExtensionPoint(this.namespace, this.extensionPoint);
    }

    public boolean isEnabledFor(IConfigurationElement languageElement, IProject project) {
        IConfigurationElement[] children = languageElement.getChildren(TAG_ENABLEMENT);
        if (children.length == 1) {
            return this.isEnabledFor(children, project);
        }
        return true;
    }

    public boolean isEnabledFor(IConfigurationElement[] children, IProject project) {
        boolean result = false;
        try {
            Expression enablement = ElementHandler.getDefault().create(ExpressionConverter.getDefault(), children[0]);
            EvaluationContext context = new EvaluationContext(null, (Object)project);
            context.setAllowPluginActivation(true);
            result = enablement.evaluate((IEvaluationContext)context) == EvaluationResult.TRUE;
        }
        catch (CoreException ce) {
            DashboardActivator.log(ce);
        }
        return result;
    }

    public void registryChanged(IRegistryChangeEvent event) {
        IExtensionDelta[] extensionDeltas = event.getExtensionDeltas(this.namespace, this.extensionPoint);
        if (event.getExtensionDeltas(this.namespace, this.extensionPoint).length == 0) {
            return;
        }
        this.invalidateCache(extensionDeltas);
    }

    protected abstract void invalidateCache(IExtensionDelta[] var1);
}

