/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.koneki.examples.core.internal.contributions;

import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.koneki.examples.core.contributions.ICategory;
import org.eclipse.koneki.examples.core.contributions.IContributionsManager;
import org.eclipse.koneki.examples.core.internal.contributions.model.Category;
import org.eclipse.koneki.examples.core.internal.contributions.model.Example;
import org.osgi.service.component.ComponentContext;

public class ContributionsManager
implements IContributionsManager {
    private static final String EXTENSION_POINT_ID = "org.eclipse.koneki.examples.core.examplesContributions";
    private static final String CATEGORY_ELEMENT = "category";
    private static final String EXAMPLE_ELEMENT = "example";
    private static final String DESCRIPTION_ELEMENT = "description";
    private static final String ID_ATTRIBUTE = "id";
    private static final String NAME_ATTRIBUTE = "name";
    private static final String ICON_ATTRIBUTE = "icon";
    private static final String TEMPLATE_ATTRIBUTE = "template";
    private static final String CATEGORY_ATTRIBUTE = "category";
    private Map<String, ICategory> parsedCategories = new HashMap<String, ICategory>();

    protected void activate(ComponentContext ctx) {
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(EXTENSION_POINT_ID);
        IExtension[] iExtensionArray = extensionPoint.getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
            int n3 = iConfigurationElementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement configurationElement = iConfigurationElementArray[n4];
                if ("category".equals(configurationElement.getName())) {
                    this.parseCategory(configurationElement);
                } else if (EXAMPLE_ELEMENT.equals(configurationElement.getName())) {
                    this.parseExample(configurationElement);
                }
                ++n4;
            }
            ++n2;
        }
    }

    protected void deactivate(ComponentContext ctx) {
    }

    private void parseCategory(IConfigurationElement configurationElement) {
        String categoryId = configurationElement.getAttribute(ID_ATTRIBUTE);
        String categoryName = configurationElement.getAttribute(NAME_ATTRIBUTE);
        String categoryDescription = null;
        IConfigurationElement[] descriptionElement = configurationElement.getChildren(DESCRIPTION_ELEMENT);
        if (descriptionElement.length > 0) {
            categoryDescription = descriptionElement[0].getValue();
        }
        Category cat = this.getOrCreateCategoryById(categoryId);
        cat.setName(categoryName);
        cat.setDescription(categoryDescription);
    }

    private void parseExample(IConfigurationElement configurationElement) {
        String exampleId = configurationElement.getAttribute(ID_ATTRIBUTE);
        String exampleName = configurationElement.getAttribute(NAME_ATTRIBUTE);
        String exampleCategory = configurationElement.getAttribute("category");
        URL templateUrl = Platform.getBundle((String)configurationElement.getDeclaringExtension().getNamespaceIdentifier()).getEntry(configurationElement.getAttribute(TEMPLATE_ATTRIBUTE));
        String exampleDescription = null;
        IConfigurationElement[] descriptionElement = configurationElement.getChildren(DESCRIPTION_ELEMENT);
        if (descriptionElement.length > 0) {
            exampleDescription = descriptionElement[0].getValue();
        }
        Example example = new Example(exampleId, exampleName, exampleDescription, templateUrl);
        Category cat = this.getOrCreateCategoryById(exampleCategory);
        example.setCategory(cat);
    }

    private Category getOrCreateCategoryById(String categoryId) {
        Category cat;
        if (this.parsedCategories.containsKey(categoryId)) {
            cat = (Category)this.parsedCategories.get(categoryId);
        } else {
            cat = new Category(categoryId);
            this.parsedCategories.put(categoryId, cat);
        }
        return cat;
    }

    @Override
    public List<ICategory> getCategories() {
        List<ICategory> result = Arrays.asList(this.parsedCategories.values().toArray(new ICategory[0]));
        Collections.sort(result, new Comparator<ICategory>(){

            @Override
            public int compare(ICategory cat1, ICategory cat2) {
                if (cat1.getName() == null) {
                    return -1;
                }
                return cat1.getName().compareTo(cat2.getName());
            }
        });
        return result;
    }
}

