/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.koneki.tema.core.internal.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.StringTokenizer;
import org.eclipse.koneki.tema.core.model.IFilePattern;
import org.eclipse.koneki.tema.core.util.SPath;
import org.w3c.dom.Element;

public class FilePattern
implements IFilePattern {
    private static final String EXTENSIONS_ATTR = "@extensions";
    private static final String FILENAMES_ATTR = "@filenames";
    private static final String DELIMITER = ",";
    private Collection<String> _extensions;
    private Collection<String> _filenames;

    public FilePattern() {
    }

    public FilePattern(Element element) {
        StringTokenizer st;
        String value = SPath.getValue(element, EXTENSIONS_ATTR);
        if (value != null) {
            st = new StringTokenizer(value, DELIMITER);
            while (st.hasMoreTokens()) {
                this.addExtension(st.nextToken().trim());
            }
        }
        if ((value = SPath.getValue(element, FILENAMES_ATTR)) != null) {
            st = new StringTokenizer(value, DELIMITER);
            while (st.hasMoreTokens()) {
                this.addFilename(st.nextToken().trim());
            }
        }
    }

    public void addExtension(String extension) {
        if (extension != null) {
            if (this._extensions == null) {
                this._extensions = new ArrayList<String>();
            }
            if (!this._extensions.contains(extension)) {
                this._extensions.add(extension);
            }
        }
    }

    public void removeExtension(String extension) {
        if (this._extensions != null) {
            this._extensions.remove(extension);
        }
    }

    public Collection<String> getExtensions() {
        return this._extensions != null ? this._extensions : Collections.emptyList();
    }

    public void addFilename(String filename) {
        if (filename != null) {
            if (this._filenames == null) {
                this._filenames = new ArrayList<String>();
            }
            if (!this._filenames.contains(filename)) {
                this._filenames.add(filename);
            }
        }
    }

    public void removeFilename(String filename) {
        if (this._filenames != null) {
            this._filenames.remove(filename);
        }
    }

    public Collection<String> getFilenames() {
        return this._filenames != null ? this._filenames : Collections.emptyList();
    }

    @Override
    public boolean matches(String filename) {
        boolean match = this.getExtensions().isEmpty() && this.getFilenames().isEmpty();
        for (String extension : this.getExtensions()) {
            boolean bl = match = match || filename.endsWith(extension);
        }
        for (String name : this.getFilenames()) {
            boolean bl = match = match || filename.endsWith(name);
        }
        return match;
    }
}

