/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.koneki.tema.core.internal.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.eclipse.koneki.tema.core.internal.model.ExcludesPattern;
import org.eclipse.koneki.tema.core.internal.model.IncludesPattern;
import org.eclipse.koneki.tema.core.model.IExcludesPattern;
import org.eclipse.koneki.tema.core.model.IIncludesPattern;
import org.eclipse.koneki.tema.core.model.IParseSet;
import org.eclipse.koneki.tema.core.util.SPath;
import org.w3c.dom.Element;

public class ParseSet
implements IParseSet {
    private static final String INCLUDE_TAG = "include";
    private static final String EXCLUDE_TAG = "exclude";
    private Collection<IExcludesPattern> _excludesPatterns;
    private Collection<IIncludesPattern> _includesPatterns;

    public ParseSet() {
    }

    public ParseSet(Element element) {
        Iterator<?> it = SPath.getIterator(element, INCLUDE_TAG);
        while (it.hasNext()) {
            Element include = (Element)it.next();
            this.addIncludesPattern(new IncludesPattern(include));
        }
        it = SPath.getIterator(element, EXCLUDE_TAG);
        while (it.hasNext()) {
            Element exclude = (Element)it.next();
            this.addExcludesPattern(new ExcludesPattern(exclude));
        }
    }

    public Collection<IExcludesPattern> getExcludesPatterns() {
        return this._excludesPatterns != null ? this._excludesPatterns : Collections.emptyList();
    }

    public void addExcludesPattern(IExcludesPattern pattern) {
        if (this._excludesPatterns == null) {
            this._excludesPatterns = new ArrayList<IExcludesPattern>();
        }
        if (!this._excludesPatterns.contains(pattern)) {
            this._excludesPatterns.add(pattern);
        }
    }

    public void removeExcludesPattern(IExcludesPattern pattern) {
        if (this._excludesPatterns != null) {
            this._excludesPatterns.remove(pattern);
        }
    }

    public Collection<IIncludesPattern> getInludesPatterns() {
        return this._includesPatterns != null ? this._includesPatterns : Collections.emptyList();
    }

    public void addIncludesPattern(IIncludesPattern pattern) {
        if (this._includesPatterns == null) {
            this._includesPatterns = new ArrayList<IIncludesPattern>();
        }
        if (!this._includesPatterns.contains(pattern)) {
            this._includesPatterns.add(pattern);
        }
    }

    public void removeIncludesPattern(IIncludesPattern pattern) {
        if (this._includesPatterns != null) {
            this._includesPatterns.remove(pattern);
        }
    }

    @Override
    public boolean mustParse(String fileName) {
        boolean isIncluded = this.getInludesPatterns().isEmpty() && this.getExcludesPatterns().isEmpty();
        boolean isExcluded = false;
        for (IIncludesPattern iIncludesPattern : this.getInludesPatterns()) {
            boolean bl = isIncluded = isIncluded || iIncludesPattern.isIncluded(fileName);
        }
        for (IExcludesPattern iExcludesPattern : this.getExcludesPatterns()) {
            boolean bl = isExcluded = isExcluded || iExcludesPattern.isExcluded(fileName);
        }
        return isIncluded && !isExcluded;
    }
}

