/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.koneki.tema.core.util;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class StringUtils {
    public static final int MAX_UNSIGNED_SHORT = 65535;
    public static final int MAX_UNSIGNED_BYTE = 255;

    private StringUtils() {
    }

    public static String firstLetterUpperCase(String str) {
        if (str != null && str.length() > 0) {
            return String.valueOf(str.substring(0, 1).toUpperCase()) + str.substring(1);
        }
        return str;
    }

    public static String firstLetterLowerCase(String str) {
        if (str != null && str.length() > 0) {
            return String.valueOf(str.substring(0, 1).toLowerCase()) + str.substring(1);
        }
        return str;
    }

    public static boolean isFirstLetterUpperCase(String str) {
        if (str != null && str.length() > 0) {
            return str.substring(0, 1).equals(StringUtils.firstLetterUpperCase(str).substring(0, 1));
        }
        return false;
    }

    public static boolean isInteger(String str) {
        try {
            Integer.parseInt(str);
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        return true;
    }

    public static int getInteger(String str) {
        try {
            return Integer.parseInt(str);
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    public static boolean isLong(String str) {
        try {
            Long.parseLong(str);
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        return true;
    }

    public static long getLong(String str) {
        try {
            return Long.parseLong(str);
        }
        catch (NumberFormatException numberFormatException) {
            return -1L;
        }
    }

    public static boolean isShort(String str) {
        try {
            Short.parseShort(str);
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        return true;
    }

    public static boolean isUnsignedShort(String str) {
        int value = StringUtils.getInteger(str);
        if (!"-1".equals(str) && value == -1) {
            return false;
        }
        return value >= 0 && value <= 65535;
    }

    public static boolean isDouble(String str) {
        try {
            Double.parseDouble(str);
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        return true;
    }

    public static Double getDouble(String str) {
        try {
            return new Double(str);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public static boolean isFloat(String str) {
        try {
            Float.parseFloat(str);
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        return true;
    }

    public static Float getFloat(String str) {
        try {
            return new Float(str);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public static boolean isByte(String str) {
        try {
            Byte.parseByte(str);
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        return true;
    }

    public static boolean isUnsignedByte(String str) {
        int value = StringUtils.getInteger(str);
        if (!"-1".equals(str) && value == -1) {
            return false;
        }
        return value >= 0 && value <= 255;
    }

    public static ArrayList<String> getVariables(String input, String delimiter) {
        Pattern myPattern = Pattern.compile(String.valueOf(delimiter) + "(.*?)" + delimiter);
        Matcher myMatcher = myPattern.matcher(input);
        ArrayList<String> tokenArray = new ArrayList<String>();
        while (myMatcher.find()) {
            tokenArray.add(myMatcher.group().replaceAll(delimiter, ""));
        }
        return tokenArray;
    }
}

