/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.core.internal.environment;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.RuntimePerformanceMonitor;
import org.eclipse.dltk.core.environment.EnvironmentPathUtils;
import org.eclipse.dltk.core.environment.FileHandles;
import org.eclipse.dltk.core.environment.IEnvironment;
import org.eclipse.dltk.core.environment.IFileHandle;
import org.eclipse.dltk.core.environment.IFileStoreProvider;

public class EFSFileHandle
implements IFileHandle,
IFileStoreProvider {
    private static Map<String, Long> timestamps = new HashMap<String, Long>();
    private static Map<String, Long> lastaccess = new HashMap<String, Long>();
    private IFileStore file;
    private IEnvironment environment;

    public EFSFileHandle(IEnvironment env, IFileStore file) {
        this.environment = env;
        this.file = file;
    }

    public boolean exists() {
        try {
            return this.file.fetchInfo().exists();
        }
        catch (RuntimeException runtimeException) {
            return false;
        }
    }

    public String toOSString() {
        return this.environment.convertPathToString(this.getPath());
    }

    public String getCanonicalPath() {
        return this.environment.getCanonicalPath(this.getPath());
    }

    public IFileHandle getChild(String childname) {
        return new EFSFileHandle(this.environment, this.file.getChild((IPath)new Path(childname)));
    }

    public IFileHandle[] getChildren() {
        try {
            IFileStore[] files = this.file.childStores(0, null);
            IFileHandle[] children = new IFileHandle[files.length];
            int i = 0;
            while (i < files.length) {
                children[i] = new EFSFileHandle(this.environment, files[i]);
                ++i;
            }
            return children;
        }
        catch (CoreException e) {
            if (DLTKCore.DEBUG) {
                e.printStackTrace();
            }
            return null;
        }
    }

    public IEnvironment getEnvironment() {
        return this.environment;
    }

    public URI toURI() {
        return this.file.toURI();
    }

    public String getName() {
        return this.file.getName();
    }

    public IFileHandle getParent() {
        IFileStore parent = this.file.getParent();
        if (parent == null) {
            return null;
        }
        return new EFSFileHandle(this.environment, parent);
    }

    public IPath getPath() {
        try {
            File localFile = this.file.toLocalFile(0, null);
            if (localFile != null) {
                return new Path(localFile.getPath());
            }
        }
        catch (CoreException coreException) {}
        return new Path(this.file.toURI().getPath());
    }

    public boolean isDirectory() {
        return this.file.fetchInfo().isDirectory();
    }

    public boolean isFile() {
        IFileInfo info = this.file.fetchInfo();
        return info.exists() && !info.isDirectory();
    }

    public boolean isSymlink() {
        return this.file.fetchInfo().getAttribute(32);
    }

    public InputStream openInputStream(IProgressMonitor monitor) throws IOException {
        try {
            return this.file.openInputStream(0, monitor);
        }
        catch (CoreException e) {
            if (DLTKCore.DEBUG) {
                e.printStackTrace();
            }
            throw new IOException(e.getLocalizedMessage());
        }
    }

    public OutputStream openOutputStream(IProgressMonitor monitor) throws IOException {
        try {
            return this.file.openOutputStream(0, monitor);
        }
        catch (CoreException e) {
            if (DLTKCore.DEBUG) {
                e.printStackTrace();
            }
            throw new IOException(e.getLocalizedMessage());
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof EFSFileHandle) {
            EFSFileHandle anotherFile = (EFSFileHandle)obj;
            return this.file.equals(anotherFile.file);
        }
        return false;
    }

    public int hashCode() {
        return this.file.hashCode();
    }

    public String toString() {
        return this.toOSString();
    }

    public long lastModified() {
        boolean flag;
        String n = this.toString();
        long c = 0L;
        boolean bl = flag = !this.environment.isLocal();
        if (flag && timestamps.containsKey(n)) {
            c = System.currentTimeMillis();
            Long last = lastaccess.get(n);
            if (last != null && c - last < 86400000L) {
                return timestamps.get(n);
            }
        }
        RuntimePerformanceMonitor.PerformanceNode p = RuntimePerformanceMonitor.begin();
        long lm = this.file.fetchInfo().getLastModified();
        if (flag) {
            timestamps.put(n, lm);
            if (c == 0L) {
                c = System.currentTimeMillis();
            }
            lastaccess.put(n, c);
        }
        p.done("#", "Return file timestamp", 0L);
        return lm;
    }

    public long length() {
        return this.file.fetchInfo().getLength();
    }

    public IPath getFullPath() {
        return EnvironmentPathUtils.getFullPath(this.environment, this.getPath());
    }

    public String getEnvironmentId() {
        return this.environment.getId();
    }

    public IFileStore getFileStore() {
        return this.file;
    }

    public void move(IFileHandle destination) throws CoreException {
        IFileStore destStore = FileHandles.asFileStore(destination);
        this.file.move(destStore, 2, null);
    }
}

