/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.koneki.ldt.editor.formatter;

import java.util.Map;
import org.eclipse.dltk.formatter.AbstractScriptFormatter;
import org.eclipse.dltk.ui.formatter.FormatterException;
import org.eclipse.dltk.ui.text.util.TabStyle;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.koneki.ldt.editor.Activator;
import org.eclipse.koneki.ldt.editor.formatter.Messages;
import org.eclipse.koneki.ldt.parser.format.LuaSourceFormat;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public class LuaFormatter
extends AbstractScriptFormatter {
    static final String ID = "org.eclipse.koneki.ldt.formatter";
    private final TabStyle tabPolicy;
    private final int tabSize;
    private final int indentationSize;
    private final String delimiter;
    private final String tabulation;
    private final boolean formatTableValues;

    protected LuaFormatter(String lineDelimiter, Map<String, String> preferences) {
        super(preferences);
        this.delimiter = lineDelimiter;
        this.tabPolicy = TabStyle.forName((String)preferences.get("formatter.tabulation.char"));
        String string = preferences.get("formatter.tabulation.size");
        this.tabSize = string == null || string.isEmpty() ? 0 : Integer.parseInt(string);
        string = preferences.get("formatter.indentation.size");
        this.indentationSize = string == null || string.isEmpty() ? 0 : Integer.parseInt(string);
        string = preferences.get("formatter.indentation.indentTables");
        boolean bl = this.formatTableValues = string == null || string.isEmpty() ? false : Boolean.parseBoolean(string);
        if (this.tabPolicy == TabStyle.SPACES) {
            StringBuilder sb = new StringBuilder(this.tabSize);
            int k = 0;
            while (k < this.tabSize) {
                sb.append(' ');
                ++k;
            }
            this.tabulation = sb.toString();
        } else {
            this.tabulation = "\t";
        }
    }

    public TextEdit format(String source, int offset, int length, int indentationLevel) throws FormatterException {
        String formatted = this.tabPolicy == TabStyle.MIXED ? LuaSourceFormat.indent((String)source, (String)this.delimiter, (int)this.tabSize, (int)this.indentationSize, (boolean)this.formatTableValues, (int)0) : LuaSourceFormat.indent((String)source, (String)this.delimiter, (String)this.tabulation, (boolean)this.formatTableValues, (int)0);
        if (length < source.length()) {
            Document doc = new Document(source);
            try {
                int startLine = doc.getLineOfOffset(offset);
                int endLine = doc.getLineOfOffset(offset + length);
                StringBuffer code = new StringBuffer();
                Document formattedDoc = new Document(formatted);
                int lengthToReplace = 0;
                int line = startLine;
                while (line <= endLine) {
                    lengthToReplace += doc.getLineLength(line);
                    IRegion lineDescription = formattedDoc.getLineInformation(line);
                    String codeOnTheLine = formattedDoc.get(lineDescription.getOffset(), lineDescription.getLength());
                    code.append(codeOnTheLine);
                    String lineEnd = formattedDoc.getLineDelimiter(line);
                    if (lineEnd != null) {
                        code.append(lineEnd);
                    }
                    ++line;
                }
                int selectionStartOffset = doc.getLineOffset(startLine);
                return new ReplaceEdit(selectionStartOffset, lengthToReplace, code.toString());
            }
            catch (BadLocationException e) {
                MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)Messages.LuaFormatterErrorWhileFormattingTitle, (String)Messages.LuaFormatterUnableToFormatSelection);
                Activator.logError(Messages.LuaFormatterUnableToFormatSelection, e);
            }
        }
        return new ReplaceEdit(offset, length, formatted);
    }

    public int detectIndentationLevel(IDocument document, int offset) {
        return LuaSourceFormat.depth((String)document.get(), (int)offset);
    }
}

