/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.koneki.ldt.parser;

import com.naef.jnlua.LuaException;
import com.naef.jnlua.LuaState;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.dltk.ast.parser.AbstractSourceParser;
import org.eclipse.dltk.ast.parser.IModuleDeclaration;
import org.eclipse.dltk.compiler.env.IModuleSource;
import org.eclipse.dltk.compiler.problem.DefaultProblem;
import org.eclipse.dltk.compiler.problem.IProblem;
import org.eclipse.dltk.compiler.problem.IProblemReporter;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.ElementChangedEvent;
import org.eclipse.dltk.core.IElementChangedListener;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IModelElementDelta;
import org.eclipse.koneki.ldt.internal.parser.DLTKObjectFactory;
import org.eclipse.koneki.ldt.metalua.MetaluaStateFactory;
import org.eclipse.koneki.ldt.parser.Activator;
import org.eclipse.koneki.ldt.parser.LuaASTUtils;
import org.eclipse.koneki.ldt.parser.Messages;
import org.eclipse.koneki.ldt.parser.ast.LuaSourceRoot;

public class AlternativeLuaSourceParser
extends AbstractSourceParser {
    public static final String LIB_PATH = "/scriptMetalua/";
    public static final String BUILDER = "dltk_ast_builder";
    public static final String BUILDER_SCRIPT = "dltk_ast_builder.mlua";
    public static final String MARKER = "declaration_marker";
    public static final String MARKER_SCRIPT = "declaration_marker.mlua";
    private static LuaState lua = null;
    private static Map<IModelElement, IModuleDeclaration> cache = new Hashtable<IModelElement, IModuleDeclaration>();
    private static IElementChangedListener changedListener = new IElementChangedListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void elementChanged(ElementChangedEvent event) {
            Class<AlternativeLuaSourceParser> clazz = AlternativeLuaSourceParser.class;
            synchronized (AlternativeLuaSourceParser.class) {
                IModelElementDelta delta = event.getDelta();
                this.processDelta(delta);
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
        }

        private void processDelta(IModelElementDelta delta) {
            IModelElement element = delta.getElement();
            if (element.getElementType() == 5) {
                if (delta.getKind() == 2) {
                    cache.remove(element);
                } else if (delta.getKind() == 4 && delta.getFlags() == 65536) {
                    cache.remove(element);
                }
            }
            if (delta.getFlags() == 128 && delta.getAffectedChildren().length == 0) {
                for (IModelElement sourcemodule : new ArrayList(cache.keySet())) {
                    if (!LuaASTUtils.isAncestor(sourcemodule, element)) continue;
                    cache.remove(sourcemodule);
                }
            }
            if ((delta.getFlags() & 8) != 0) {
                IModelElementDelta[] affectedChildren = delta.getAffectedChildren();
                int i = 0;
                while (i < affectedChildren.length) {
                    IModelElementDelta child = affectedChildren[i];
                    this.processDelta(child);
                    ++i;
                }
            }
        }
    };

    static {
        DLTKCore.addElementChangedListener((IElementChangedListener)changedListener);
    }

    private static synchronized LuaState getLuaState() {
        if (lua == null) {
            lua = MetaluaStateFactory.newLuaState();
            DLTKObjectFactory.register(lua);
            try {
                URL folderUrl = FileLocator.toFileURL((URL)Platform.getBundle((String)"org.eclipse.koneki.ldt.parser").getEntry(LIB_PATH));
                File folder = new File(folderUrl.getFile());
                AlternativeLuaSourceParser.compileMetaluaFile(folder, BUILDER_SCRIPT);
                AlternativeLuaSourceParser.compileMetaluaFile(folder, MARKER_SCRIPT);
                StringBuffer code = new StringBuffer("package.path=[[");
                code.append(folder.getPath());
                code.append(File.separatorChar);
                code.append("?.luac;]]..package.path");
                lua.load(code.toString(), "reloadingPath");
                lua.call(0, 0);
                lua.getGlobal("require");
                lua.pushString(MARKER);
                lua.call(1, 1);
                lua.setGlobal("mark");
                lua.getGlobal("require");
                lua.pushString(BUILDER);
                lua.call(1, 1);
                lua.setGlobal("parsemod");
            }
            catch (IOException e) {
                Activator.logError(Messages.AlternativeLuaSourceParserUnableToBuild, e);
            }
        }
        return lua;
    }

    private static void compileMetaluaFile(File folder, String fileName) throws IOException {
        File regular = new File(folder, fileName);
        String fileNameWithoutExtension = fileName.substring(0, fileName.lastIndexOf(46));
        File build = new File(folder, String.valueOf(fileNameWithoutExtension) + ".luac");
        LuaState justForCompilation = MetaluaStateFactory.newLuaState();
        try {
            StringBuffer command = new StringBuffer("local bin  = mlc.luafile_to_luacstring([[");
            command.append(regular.getPath());
            command.append("]]) ");
            command.append("local file = io.open([[");
            command.append(build.getPath());
            command.append("]], 'wb') file:write(bin) file:close()");
            justForCompilation.load(command.toString(), "libraryCompilation");
            justForCompilation.call(0, 0);
        }
        finally {
            justForCompilation.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IModuleDeclaration parse(IModuleSource input, IProblemReporter reporter) {
        LuaSourceRoot module = new LuaSourceRoot(input.getSourceContents().length());
        Class<AlternativeLuaSourceParser> clazz = AlternativeLuaSourceParser.class;
        synchronized (AlternativeLuaSourceParser.class) {
            try {
                AlternativeLuaSourceParser.getLuaState().getGlobal("parsemod");
                AlternativeLuaSourceParser.getLuaState().getField(-1, "ast_builder");
                AlternativeLuaSourceParser.getLuaState().pushString(input.getSourceContents());
                AlternativeLuaSourceParser.getLuaState().call(1, 1);
                module = (LuaSourceRoot)((Object)AlternativeLuaSourceParser.getLuaState().checkJavaObject(-1, LuaSourceRoot.class));
                AlternativeLuaSourceParser.getLuaState().pop(2);
            }
            catch (LuaException e) {
                Activator.logError("Unable to load metalua ast builder :" + input.getFileName(), e);
            }
            if (module != null) {
                if (module.hasError()) {
                    LuaSourceRoot cached;
                    DefaultProblem problem = module.getProblem();
                    problem.setOriginatingFileName(input.getFileName());
                    reporter.reportProblem((IProblem)problem);
                    if (input.getModelElement() != null && (cached = (LuaSourceRoot)cache.get(input.getModelElement())) != null) {
                        cached.setError(true);
                        // ** MonitorExit[var4_4] (shouldn't be in output)
                        return cached;
                    }
                } else if (input.getModelElement() != null) {
                    cache.put(input.getModelElement(), (IModuleDeclaration)module);
                }
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return module;
        }
    }
}

