/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.koneki.ldt.parser.ast.expressions;

import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.dltk.ast.statements.Statement;
import org.eclipse.dltk.utils.CorePrinter;
import org.eclipse.koneki.ldt.internal.parser.INavigableNode;

public class BinaryExpression
extends Expression
implements INavigableNode {
    private int kind;
    private Statement left;
    private Statement right;
    private ASTNode parentNode;

    public BinaryExpression(int start, int end, Expression left, int kind, Expression right) {
        super(start, end);
        this.kind = kind;
        this.left = left;
        this.right = right;
        if (left != null) {
            this.setStart(left.sourceStart());
        }
        if (right != null) {
            this.setEnd(right.sourceEnd());
        }
    }

    public BinaryExpression(int start, int end, Expression left, String operatorName, Expression right) {
        this(start, end, left, BinaryExpression.operatorNameToKind(operatorName), right);
    }

    public Statement getLeft() {
        return this.left;
    }

    public String getOperator() {
        switch (this.getKind()) {
            case 1018: {
                return "..";
            }
        }
        return super.getOperator();
    }

    public Statement getRight() {
        return this.right;
    }

    public int getKind() {
        return this.kind;
    }

    public void printNode(CorePrinter output) {
        if (this.left != null) {
            this.left.printNode(output);
        }
        output.formatPrintLn(this.getOperator());
        if (this.right != null) {
            this.right.printNode(output);
        }
    }

    public void traverse(ASTVisitor visitor) throws Exception {
        if (visitor.visit((Expression)this)) {
            if (this.getLeft() != null) {
                this.getLeft().traverse(visitor);
            }
            if (this.getRight() != null) {
                this.getRight().traverse(visitor);
            }
            visitor.endvisit((Expression)this);
        }
    }

    public static int operatorNameToKind(String s) {
        if ("sub".equals(s)) {
            return 1001;
        }
        if ("mul".equals(s)) {
            return 1002;
        }
        if ("div".equals(s)) {
            return 1003;
        }
        if ("eq".equals(s)) {
            return 1013;
        }
        if ("concat".equals(s)) {
            return 1018;
        }
        if ("mod".equals(s)) {
            return 1019;
        }
        if ("pow".equals(s)) {
            return 1078;
        }
        if ("lt".equals(s)) {
            return 1014;
        }
        if ("le".equals(s)) {
            return 1015;
        }
        if ("and".equals(s)) {
            return 1008;
        }
        if ("or".equals(s)) {
            return 1004;
        }
        if ("not".equals(s)) {
            return 1027;
        }
        if ("len".equals(s)) {
            return 38002;
        }
        if ("unm".equals(s)) {
            return 38004;
        }
        assert ("add".equals(s)) : "Unhandled operator: " + s;
        return 1000;
    }

    @Override
    public ASTNode getParent() {
        return this.parentNode;
    }

    @Override
    public void setParent(ASTNode parent) {
        this.parentNode = parent;
    }
}

