/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.koneki.ldt.parser.ast.statements;

import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.dltk.ast.expressions.Literal;
import org.eclipse.dltk.ast.statements.Statement;
import org.eclipse.dltk.ast.statements.StatementConstants;
import org.eclipse.dltk.utils.CorePrinter;
import org.eclipse.koneki.ldt.parser.ast.statements.BinaryStatement;
import org.eclipse.koneki.ldt.parser.ast.statements.Chunk;

public class Local
extends BinaryStatement
implements StatementConstants {
    public Local(int start, int end, Chunk identifiers, Chunk expressions) {
        super(start, end, identifiers, 3, expressions);
    }

    public Local(int start, int end, Chunk identifiers) {
        this(start, end, identifiers, null);
    }

    @Override
    public void printNode(CorePrinter output) {
        StringBuffer varList = new StringBuffer();
        StringBuffer valueList = new StringBuffer();
        Chunk chunk = this.getLeft();
        for (Object var : chunk.getStatements()) {
            Statement state = (Statement)var;
            varList.append(state.toString());
            varList.append(", ");
        }
        if (this.getRight() != null) {
            chunk = this.getRight();
            for (Object e : chunk.getStatements()) {
                Statement statement = (Statement)e;
                if (e instanceof Literal) {
                    Literal literal = (Literal)e;
                    valueList.append(literal.getValue());
                } else {
                    valueList.append(statement.toString());
                }
                valueList.append(", ");
            }
        }
        if (valueList.length() > 0) {
            valueList.insert(0, "= ");
        }
        output.formatPrintLn("local " + varList + valueList);
    }

    @Override
    public void traverse(ASTVisitor visitor) throws Exception {
        if (visitor.visit((Expression)this)) {
            if (this.getLeft() != null) {
                this.getLeft().traverse(visitor);
            }
            visitor.endvisit((Expression)this);
        }
    }
}

