/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.koneki.ldt.parser.ast.visitor;

import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;

public final class ScopeVisitor
extends ASTVisitor {
    private final int offset;
    private ASTNode scope;

    public ScopeVisitor(int position) {
        this.offset = position;
    }

    public boolean visitGeneral(ASTNode node) {
        if (node.sourceStart() > this.offset) {
            return false;
        }
        if (node.sourceStart() <= this.offset) {
            if (this.scope == null) {
                this.scope = node;
            } else {
                boolean closerToOffset;
                int challenger = node.sourceEnd() - node.sourceStart();
                int current = this.scope.sourceEnd() - this.scope.sourceStart();
                boolean bl = closerToOffset = Math.abs(this.offset - node.sourceEnd()) < Math.abs(this.offset - this.scope.sourceEnd());
                if (challenger < current && closerToOffset) {
                    this.scope = node;
                }
            }
        }
        return true;
    }

    public ASTNode getScope() {
        return this.scope;
    }
}

