/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.koneki.ldt.parser.format;

import com.naef.jnlua.LuaRuntimeException;
import com.naef.jnlua.LuaState;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.koneki.ldt.metalua.MetaluaStateFactory;
import org.eclipse.koneki.ldt.parser.Activator;
import org.eclipse.koneki.ldt.parser.format.Messages;

public final class LuaSourceFormat {
    public static final String FORMATTER_PATH = "/scripts/";
    public static final String FORMATTER_LIB_NAME = "format";
    public static final String INDENTATION_FUNTION = "indentCode";

    private LuaSourceFormat() {
    }

    public static int depth(String source, int offset) {
        LuaState lua = LuaSourceFormat.loadState();
        lua.getField(-1, "indentLevel");
        lua.pushString(source);
        lua.pushInteger(offset);
        try {
            lua.call(2, 1);
        }
        catch (LuaRuntimeException e) {
            Activator.logWarning(Messages.LuaSourceFormatDepthError, e);
            return 0;
        }
        int result = lua.toInteger(-1);
        lua.close();
        return result > 0 ? result - 1 : result;
    }

    public static String indent(String source, String delimiter, String tabulation, boolean indentInTable, int originalIndentationLevel) {
        LuaState lua = LuaSourceFormat.loadState();
        lua.getField(-1, INDENTATION_FUNTION);
        lua.pushString(source);
        lua.pushString(delimiter);
        lua.pushString(tabulation);
        lua.pushInteger(originalIndentationLevel);
        lua.pushBoolean(indentInTable);
        try {
            lua.call(5, 1);
        }
        catch (LuaRuntimeException e) {
            Activator.logWarning(Messages.LuaSourceFormatIndentationError, e);
            return source;
        }
        String formattedCode = lua.toString(-1);
        lua.close();
        return formattedCode;
    }

    public static String indent(String source, String delimiter, int tabSize, int indentationSize, boolean indentInTable, int originalIndentationLevel) {
        LuaState lua = LuaSourceFormat.loadState();
        lua.getField(-1, INDENTATION_FUNTION);
        lua.pushString(source);
        lua.pushString(delimiter);
        lua.pushInteger(tabSize);
        lua.pushInteger(indentationSize);
        lua.pushInteger(originalIndentationLevel);
        lua.pushBoolean(indentInTable);
        try {
            lua.call(6, 1);
        }
        catch (LuaRuntimeException e) {
            Activator.logWarning(Messages.LuaSourceFormatIndentationError, e);
            return source;
        }
        String formattedCode = lua.toString(-1);
        lua.close();
        return formattedCode;
    }

    private static LuaState loadState() {
        LuaState lua = MetaluaStateFactory.newLuaState();
        String path = null;
        try {
            URL folderUrl = FileLocator.toFileURL((URL)Platform.getBundle((String)"org.eclipse.koneki.ldt.parser").getEntry(FORMATTER_PATH));
            File folder = new File(folderUrl.getFile());
            path = String.valueOf(folder.getPath()) + File.separatorChar;
        }
        catch (IOException e) {
            Activator.logError(String.valueOf(Messages.LuaSourceFormatUnableToLoad) + FORMATTER_PATH, e);
        }
        String code = "package.path = [[" + path + "?.lua;]] .. package.path";
        lua.load(code, "UpdatingFormatterPath");
        lua.call(0, 0);
        lua.getGlobal("require");
        lua.pushString(FORMATTER_LIB_NAME);
        lua.call(1, 1);
        return lua;
    }
}

