/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.koneki.ldt.ui.internal.documentation;

import java.io.Reader;
import java.io.StringReader;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.core.IMember;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.SourceParserUtil;
import org.eclipse.dltk.ui.documentation.IDocumentationResponse;
import org.eclipse.dltk.ui.documentation.IScriptDocumentationProvider;
import org.eclipse.dltk.ui.documentation.IScriptDocumentationProviderExtension;
import org.eclipse.dltk.ui.documentation.IScriptDocumentationProviderExtension2;
import org.eclipse.dltk.ui.documentation.TextDocumentationResponse;
import org.eclipse.koneki.ldt.Activator;
import org.eclipse.koneki.ldt.parser.LuaASTUtils;
import org.eclipse.koneki.ldt.parser.ast.LuaSourceRoot;

public class LuaDocumentationProvider
implements IScriptDocumentationProvider,
IScriptDocumentationProviderExtension,
IScriptDocumentationProviderExtension2 {
    public Reader getInfo(IMember element, boolean lookIntoParents, boolean lookIntoExternal) {
        try {
            String memberDocumentation = this.getMemberDocumentation(element);
            if (memberDocumentation != null) {
                return new StringReader(memberDocumentation);
            }
        }
        catch (ModelException e) {
            Activator.logWarning((String)("unable to get documentation for :" + element), (Throwable)e);
        }
        return null;
    }

    public Reader getInfo(String content) {
        return null;
    }

    public IDocumentationResponse describeKeyword(String keyword, IModelElement context) {
        return null;
    }

    public IDocumentationResponse getDocumentationFor(Object element) {
        try {
            String moduleDocumentation;
            if (element instanceof IMember) {
                String memberDocumentation = this.getMemberDocumentation((IMember)element);
                if (memberDocumentation != null) {
                    return new TextDocumentationResponse(element, memberDocumentation);
                }
            } else if (element instanceof ISourceModule && (moduleDocumentation = this.getModuleDocumentation((ISourceModule)element)) != null) {
                return new TextDocumentationResponse(element, moduleDocumentation);
            }
        }
        catch (ModelException e) {
            Activator.logWarning((String)("unable to get documentation for :" + element), (Throwable)e);
        }
        return null;
    }

    private String getMemberDocumentation(IMember member) throws ModelException {
        ISourceModule sourceModule = member.getSourceModule();
        if (sourceModule != null) {
            if (LuaASTUtils.isModule((IMember)member)) {
                return this.getModuleDocumentation(sourceModule);
            }
            String elementName = member.getElementName();
            ModuleDeclaration moduleDeclaration = SourceParserUtil.getModuleDeclaration((ISourceModule)sourceModule);
            if (moduleDeclaration instanceof LuaSourceRoot) {
                return ((LuaSourceRoot)moduleDeclaration).getMemberDocumentation(elementName);
            }
        }
        return null;
    }

    private String getModuleDocumentation(ISourceModule module) {
        ModuleDeclaration moduleDeclaration = SourceParserUtil.getModuleDeclaration((ISourceModule)module);
        if (moduleDeclaration instanceof LuaSourceRoot) {
            return ((LuaSourceRoot)moduleDeclaration).getGlobalDocumentation();
        }
        return null;
    }
}

