/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.koneki.ldt.ui.search;

import java.util.ArrayList;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.declarations.Declaration;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.parser.IModuleDeclaration;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.ui.search.IOccurrencesFinder;
import org.eclipse.dltk.ui.search.ModelElementOccurrencesFinder;
import org.eclipse.koneki.ldt.internal.parser.IOccurrenceHolder;
import org.eclipse.koneki.ldt.parser.LuaSelectionEngine;
import org.eclipse.koneki.ldt.parser.ast.LuaSourceRoot;
import org.eclipse.koneki.ldt.parser.ast.expressions.Identifier;

public class LuaModelElementOccurrencesFinder
extends ModelElementOccurrencesFinder {
    private Declaration declaration;

    public String initialize(ISourceModule module, IModuleDeclaration root, int offset, int length) {
        this.declaration = null;
        if (root instanceof LuaSourceRoot && ((LuaSourceRoot)root).hasError()) {
            return null;
        }
        ASTNode node = LuaSelectionEngine.findNodeAt((ModuleDeclaration)((ModuleDeclaration)root), (int)offset, (int)(offset + length - 1));
        if (node instanceof Identifier) {
            Identifier id = (Identifier)node;
            if (id.hasDeclaration()) {
                this.declaration = id.getDeclaration();
                return null;
            }
        } else if (node instanceof Declaration) {
            this.declaration = (Declaration)node;
            return null;
        }
        return null;
    }

    public IOccurrencesFinder.OccurrenceLocation[] getOccurrences() {
        if (this.declaration == null || !(this.declaration instanceof IOccurrenceHolder)) {
            return new IOccurrencesFinder.OccurrenceLocation[0];
        }
        ArrayList<IOccurrencesFinder.OccurrenceLocation> list = new ArrayList<IOccurrencesFinder.OccurrenceLocation>();
        list.add(new IOccurrencesFinder.OccurrenceLocation(this.declaration.getNameStart(), this.declaration.getNameEnd() - this.declaration.getNameStart(), this.declaration.getName()));
        IOccurrenceHolder holder = (IOccurrenceHolder)this.declaration;
        ASTNode[] aSTNodeArray = holder.getOccurrences();
        int n = aSTNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ASTNode node = aSTNodeArray[n2];
            list.add(new IOccurrencesFinder.OccurrenceLocation(node.sourceStart(), node.matchLength(), node.toString()));
            ++n2;
        }
        return list.toArray(new IOccurrencesFinder.OccurrenceLocation[list.size()]);
    }
}

