/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.synchronize.actions;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.core.resources.IEncodedStorage;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.internal.ui.TeamUIMessages;
import org.eclipse.team.internal.ui.synchronize.patch.ApplyPatchOperation;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.SelectionListenerAction;

public class PasteAction
extends SelectionListenerAction {
    private static final String ID = "org.eclipse.team.ui.synchronize.action.paste";
    private Shell fShell;
    private Clipboard fClipboard;

    public PasteAction(IWorkbenchPart part) {
        super(TeamUIMessages.PasteAction_1);
        ISharedImages images = PlatformUI.getWorkbench().getSharedImages();
        this.setActionDefinitionId("org.eclipse.ui.edit.paste");
        this.setImageDescriptor(images.getImageDescriptor("IMG_TOOL_PASTE"));
        this.setDisabledImageDescriptor(images.getImageDescriptor("IMG_TOOL_PASTE_DISABLED"));
        this.fShell = part.getSite().getShell();
        Assert.isNotNull((Object)this.fShell);
        this.fClipboard = new Clipboard(this.fShell.getDisplay());
        this.setToolTipText(TeamUIMessages.PasteAction_2);
        this.setId(ID);
    }

    public void run() {
        IStorage patchStorage = this.getPatchStorage();
        if (patchStorage != null) {
            IResource resource = null;
            IResource[] resources = this.getSelectedResources().toArray(new IResource[0]);
            if (resources.length > 0) {
                resource = resources[0];
            }
            ApplyPatchOperation operation = new ApplyPatchOperation(null, patchStorage, resource, new CompareConfiguration()){

                protected boolean isApplyPatchInSynchronizeView() {
                    return true;
                }
            };
            operation.openWizard();
        } else {
            MessageDialog.openError((Shell)this.fShell, (String)TeamUIMessages.PasteAction_3, (String)TeamUIMessages.PasteAction_4);
        }
    }

    private IStorage getPatchStorage() {
        final String text = this.getClipboardText();
        if (text == null) {
            return null;
        }
        IEncodedStorage storage = new IEncodedStorage(){

            public Object getAdapter(Class adapter) {
                return null;
            }

            public boolean isReadOnly() {
                return false;
            }

            public String getName() {
                return null;
            }

            public IPath getFullPath() {
                return null;
            }

            public InputStream getContents() throws CoreException {
                try {
                    return new ByteArrayInputStream(text.getBytes(this.getCharset()));
                }
                catch (UnsupportedEncodingException e) {
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.team.ui", 4, e.getMessage(), (Throwable)e));
                }
            }

            public String getCharset() throws CoreException {
                return "UTF-8";
            }
        };
        try {
            if (ApplyPatchOperation.isPatch((IStorage)storage)) {
                return storage;
            }
        }
        catch (CoreException coreException) {}
        return null;
    }

    private String getClipboardText() {
        TextTransfer transfer = TextTransfer.getInstance();
        if (PasteAction.isAvailable((Transfer)transfer, this.fClipboard.getAvailableTypes())) {
            return (String)PasteAction.getContents(this.fClipboard, (Transfer)transfer, this.fShell);
        }
        return null;
    }

    private static boolean isAvailable(Transfer transfer, TransferData[] availableDataTypes) {
        int i = 0;
        while (i < availableDataTypes.length) {
            if (transfer.isSupportedType(availableDataTypes[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static Object getContents(final Clipboard clipboard, final Transfer transfer, Shell shell) {
        final Object[] result = new Object[1];
        shell.getDisplay().syncExec(new Runnable(){

            public void run() {
                result[0] = clipboard.getContents(transfer);
            }
        });
        return result[0];
    }

    public void dispose() {
        this.fClipboard.dispose();
    }
}

