/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.ide.dialogs;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.WorkbenchEncoding;
import org.eclipse.ui.ide.IDEEncoding;
import org.eclipse.ui.ide.dialogs.AbstractEncodingFieldEditor;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public final class ResourceEncodingFieldEditor
extends AbstractEncodingFieldEditor {
    private IResource resource;
    private Composite group;
    private Button separateDerivedEncodingsButton = null;

    public ResourceEncodingFieldEditor(String labelText, Composite parent, IResource charsetResource) {
        this.setLabelAndResource(labelText, charsetResource);
        this.createControl(parent);
    }

    public ResourceEncodingFieldEditor(String labelText, Composite parent, IResource charsetResource, String groupTitle) {
        this.setLabelAndResource(labelText, charsetResource);
        this.setGroupTitle(groupTitle);
        this.createControl(parent);
    }

    private void setLabelAndResource(String labelText, IResource charsetResource) {
        Assert.isTrue((charsetResource instanceof IContainer || charsetResource instanceof IFile ? 1 : 0) != 0);
        this.setLabelText(labelText);
        this.resource = charsetResource;
    }

    protected String getStoredValue() {
        try {
            if (this.resource instanceof IContainer) {
                return ((IContainer)this.resource).getDefaultCharset(false);
            }
            return ((IFile)this.resource).getCharset(false);
        }
        catch (CoreException e) {
            IDEWorkbenchPlugin.log(IDEWorkbenchMessages.ResourceEncodingFieldEditor_ErrorLoadingMessage, e.getStatus());
            return WorkbenchEncoding.getWorkbenchDefaultEncoding();
        }
    }

    private boolean getStoredSeparateDerivedEncodingsValue() {
        Preferences node;
        block5: {
            String projectName;
            block4: {
                node = Platform.getPreferencesService().getRootNode().node("project");
                projectName = ((IProject)this.resource).getName();
                try {
                    if (node.nodeExists(projectName)) break block4;
                    return false;
                }
                catch (BackingStoreException backingStoreException) {
                    return false;
                }
            }
            node = node.node(projectName);
            if (node.nodeExists("org.eclipse.core.resources")) break block5;
            return false;
        }
        node = node.node("org.eclipse.core.resources");
        return node.getBoolean("separateDerivedEncodings", false);
    }

    private boolean hasSameSeparateDerivedEncodings() {
        return this.separateDerivedEncodingsButton == null || this.separateDerivedEncodingsButton != null && this.separateDerivedEncodingsButton.getSelection() == this.getStoredSeparateDerivedEncodingsValue();
    }

    protected void doStore() {
        String encoding = this.getSelectedEncoding();
        if (this.isDefaultSelected()) {
            encoding = null;
        }
        final boolean hasSameEncoding = this.hasSameEncoding(encoding);
        final boolean hasSameSeparateDerivedEncodings = this.hasSameSeparateDerivedEncodings();
        if (hasSameEncoding && hasSameSeparateDerivedEncodings) {
            return;
        }
        String descriptionCharset = this.getCharsetFromDescription();
        if (descriptionCharset != null && !descriptionCharset.equals(encoding) && encoding != null) {
            MessageDialog dialog;
            Shell shell = null;
            DialogPage page = this.getPage();
            if (page != null) {
                shell = page.getShell();
            }
            if ((dialog = new MessageDialog(shell, IDEWorkbenchMessages.ResourceEncodingFieldEditor_EncodingConflictTitle, null, NLS.bind((String)IDEWorkbenchMessages.ResourceEncodingFieldEditor_EncodingConflictMessage, (Object)encoding, (Object)descriptionCharset), 4, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 0){

                protected int getShellStyle() {
                    return super.getShellStyle() | 0x10000000;
                }
            }).open() > 0) {
                return;
            }
        }
        IDEEncoding.addIDEEncoding(encoding);
        final String finalEncoding = encoding;
        Job charsetJob = new Job(IDEWorkbenchMessages.IDEEncoding_EncodingJob){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    if (!hasSameEncoding) {
                        if (ResourceEncodingFieldEditor.this.resource instanceof IContainer) {
                            ((IContainer)ResourceEncodingFieldEditor.this.resource).setDefaultCharset(finalEncoding, monitor);
                        } else {
                            ((IFile)ResourceEncodingFieldEditor.this.resource).setCharset(finalEncoding, monitor);
                        }
                    }
                    if (!hasSameSeparateDerivedEncodings) {
                        IEclipsePreferences prefs = new ProjectScope((IProject)ResourceEncodingFieldEditor.this.resource).getNode("org.eclipse.core.resources");
                        if (ResourceEncodingFieldEditor.this.getStoredSeparateDerivedEncodingsValue()) {
                            prefs.remove("separateDerivedEncodings");
                        } else {
                            prefs.putBoolean("separateDerivedEncodings", true);
                        }
                        prefs.flush();
                    }
                    return Status.OK_STATUS;
                }
                catch (CoreException e) {
                    IDEWorkbenchPlugin.log(IDEWorkbenchMessages.ResourceEncodingFieldEditor_ErrorStoringMessage, e.getStatus());
                    return e.getStatus();
                }
                catch (BackingStoreException e) {
                    IDEWorkbenchPlugin.log(IDEWorkbenchMessages.ResourceEncodingFieldEditor_ErrorStoringMessage, e);
                    return new Status(4, "org.eclipse.ui.ide", e.getMessage(), (Throwable)e);
                }
            }
        };
        charsetJob.schedule();
    }

    public void store() {
        this.doStore();
    }

    public void load() {
        this.setPresentsDefaultValue(false);
        this.doLoad();
    }

    public void loadDefault() {
        this.setPresentsDefaultValue(true);
        this.doLoadDefault();
        this.refreshValidState();
    }

    protected void doLoadDefault() {
        super.doLoadDefault();
        if (this.separateDerivedEncodingsButton != null) {
            this.separateDerivedEncodingsButton.setSelection(this.getStoredSeparateDerivedEncodingsValue());
        }
    }

    protected String findDefaultEncoding() {
        if (this.resource instanceof IWorkspaceRoot) {
            return super.findDefaultEncoding();
        }
        String defaultCharset = this.getCharsetFromDescription();
        if (defaultCharset != null && defaultCharset.length() > 0) {
            return defaultCharset;
        }
        try {
            defaultCharset = this.resource.getParent().getDefaultCharset(true);
        }
        catch (CoreException coreException) {}
        if (defaultCharset != null && defaultCharset.length() > 0) {
            return defaultCharset;
        }
        return super.findDefaultEncoding();
    }

    private String getCharsetFromDescription() {
        IContentDescription description = this.getContentDescription();
        if (description != null) {
            return description.getCharset();
        }
        return null;
    }

    protected String defaultButtonText() {
        if (this.resource instanceof IWorkspaceRoot) {
            return super.defaultButtonText();
        }
        if (this.resource instanceof IFile) {
            try {
                IContentDescription description = ((IFile)this.resource).getContentDescription();
                if (description == null || description.getCharset() == null) {
                    return NLS.bind((String)IDEWorkbenchMessages.ResourceInfo_fileContainerEncodingFormat, (Object)this.getDefaultEnc());
                }
                IContentType contentType = description.getContentType();
                if (contentType != null && contentType.getDefaultCharset() == description.getCharset()) {
                    return NLS.bind((String)IDEWorkbenchMessages.ResourceInfo_fileContentTypeEncodingFormat, (Object)this.getDefaultEnc());
                }
                return NLS.bind((String)IDEWorkbenchMessages.ResourceInfo_fileContentEncodingFormat, (Object)this.getDefaultEnc());
            }
            catch (CoreException coreException) {}
        }
        return NLS.bind((String)IDEWorkbenchMessages.ResourceInfo_containerEncodingFormat, (Object)this.getDefaultEnc());
    }

    protected Composite createEncodingGroup(Composite parent, int numColumns) {
        this.group = super.createEncodingGroup(parent, numColumns);
        String byteOrderLabel = IDEEncoding.getByteOrderMarkLabel(this.getContentDescription());
        if (byteOrderLabel != null) {
            Label label = new Label(this.group, 0);
            label.setText(NLS.bind((String)IDEWorkbenchMessages.WorkbenchPreference_encoding_encodingMessage, (Object)byteOrderLabel));
            GridData layoutData = new GridData();
            layoutData.horizontalSpan = numColumns + 1;
            label.setLayoutData((Object)layoutData);
        }
        if (this.resource.getType() == 4) {
            this.separateDerivedEncodingsButton = new Button(this.group, 32);
            GridData data = new GridData();
            data.horizontalSpan = 2;
            this.separateDerivedEncodingsButton.setLayoutData((Object)data);
            this.separateDerivedEncodingsButton.setText(IDEWorkbenchMessages.ResourceEncodingFieldEditor_SeparateDerivedEncodingsLabel);
            this.separateDerivedEncodingsButton.setSelection(this.getStoredSeparateDerivedEncodingsValue());
        }
        return this.group;
    }

    private IContentDescription getContentDescription() {
        try {
            if (this.resource instanceof IFile) {
                return ((IFile)this.resource).getContentDescription();
            }
        }
        catch (CoreException coreException) {}
        return null;
    }

    public void setEnabled(boolean enabled, Composite parent) {
        super.setEnabled(enabled, parent);
        this.group.setEnabled(enabled);
        Control[] children = this.group.getChildren();
        int i = 0;
        while (i < children.length) {
            children[i].setEnabled(enabled);
            ++i;
        }
    }
}

