/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare.internal;

import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.IEditableContent;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.contentmergeviewer.IMergeViewerContentProvider;
import org.eclipse.compare.internal.ResourceCompareInput;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.compare.structuremergeviewer.IDiffContainer;
import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;

public class MergeViewerContentProvider
implements IMergeViewerContentProvider {
    public static final char ANCESTOR_CONTRIBUTOR = 'A';
    public static final char RIGHT_CONTRIBUTOR = 'R';
    public static final char LEFT_CONTRIBUTOR = 'L';
    private CompareConfiguration fCompareConfiguration;
    private String fAncestorError;
    private String fLeftError;
    private String fRightError;

    public MergeViewerContentProvider(CompareConfiguration cc) {
        this.fCompareConfiguration = cc;
    }

    private boolean hasError() {
        return this.fAncestorError != null || this.fLeftError != null || this.fRightError != null;
    }

    public void dispose() {
    }

    public void inputChanged(Viewer v, Object o1, Object o2) {
    }

    public void setAncestorError(String errorMessage) {
        this.fAncestorError = errorMessage;
    }

    public String getAncestorLabel(Object element) {
        if (this.fAncestorError != null) {
            return this.fAncestorError;
        }
        return this.fCompareConfiguration.getAncestorLabel(element);
    }

    public Image getAncestorImage(Object element) {
        if (this.fAncestorError != null) {
            return null;
        }
        return this.fCompareConfiguration.getAncestorImage(element);
    }

    public Object getAncestorContent(Object element) {
        if (element instanceof ICompareInput) {
            return ((ICompareInput)element).getAncestor();
        }
        return null;
    }

    public boolean showAncestor(Object element) {
        return element instanceof ICompareInput;
    }

    public void setLeftError(String errorMessage) {
        this.fLeftError = errorMessage;
    }

    public String getLeftLabel(Object element) {
        if (this.fLeftError != null) {
            return this.fLeftError;
        }
        return this.fCompareConfiguration.getLeftLabel(element);
    }

    public Image getLeftImage(Object element) {
        if (this.fLeftError != null) {
            return null;
        }
        return this.fCompareConfiguration.getLeftImage(element);
    }

    public Object getLeftContent(Object element) {
        if (element instanceof ICompareInput) {
            return ((ICompareInput)element).getLeft();
        }
        return null;
    }

    public boolean isLeftEditable(Object element) {
        if (this.hasError()) {
            return false;
        }
        if (element instanceof ICompareInput) {
            IDiffContainer parent;
            ITypedElement left = ((ICompareInput)element).getLeft();
            if (left == null && element instanceof IDiffElement && (parent = ((IDiffElement)element).getParent()) instanceof ICompareInput) {
                left = ((ICompareInput)((Object)parent)).getLeft();
            }
            if (left instanceof IEditableContent) {
                return ((IEditableContent)((Object)left)).isEditable();
            }
        }
        return false;
    }

    public void saveLeftContent(Object element, byte[] bytes) {
        if (element instanceof ICompareInput) {
            ICompareInput node = (ICompareInput)element;
            if (bytes != null) {
                ITypedElement left = node.getLeft();
                if (left == null) {
                    node.copy(false);
                    left = node.getLeft();
                }
                if (left instanceof IEditableContent) {
                    ((IEditableContent)((Object)left)).setContent(bytes);
                }
                if (node instanceof ResourceCompareInput.MyDiffNode) {
                    ((ResourceCompareInput.MyDiffNode)node).fireChange();
                }
            } else {
                node.copy(false);
            }
        }
    }

    public void setRightError(String errorMessage) {
        this.fRightError = errorMessage;
    }

    public String getRightLabel(Object element) {
        if (this.fRightError != null) {
            return this.fRightError;
        }
        return this.fCompareConfiguration.getRightLabel(element);
    }

    public Image getRightImage(Object element) {
        if (this.fRightError != null) {
            return null;
        }
        return this.fCompareConfiguration.getRightImage(element);
    }

    public Object getRightContent(Object element) {
        if (element instanceof ICompareInput) {
            return ((ICompareInput)element).getRight();
        }
        return null;
    }

    public boolean isRightEditable(Object element) {
        if (this.hasError()) {
            return false;
        }
        if (element instanceof ICompareInput) {
            IDiffContainer parent;
            ITypedElement right = ((ICompareInput)element).getRight();
            if (right == null && element instanceof IDiffElement && (parent = ((IDiffElement)element).getParent()) instanceof ICompareInput) {
                right = ((ICompareInput)((Object)parent)).getRight();
            }
            if (right instanceof IEditableContent) {
                return ((IEditableContent)((Object)right)).isEditable();
            }
        }
        return false;
    }

    public void saveRightContent(Object element, byte[] bytes) {
        if (element instanceof ICompareInput) {
            ICompareInput node = (ICompareInput)element;
            if (bytes != null) {
                ITypedElement right = node.getRight();
                if (right == null) {
                    node.copy(true);
                    right = node.getRight();
                }
                if (right instanceof IEditableContent) {
                    ((IEditableContent)((Object)right)).setContent(bytes);
                }
                if (node instanceof ResourceCompareInput.MyDiffNode) {
                    ((ResourceCompareInput.MyDiffNode)node).fireChange();
                }
            } else {
                node.copy(true);
            }
        }
    }
}

