/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.koneki.ldt.core;

import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.dltk.compiler.env.IModuleSource;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.core.IExternalSourceModule;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IParent;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.IScriptFolder;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.environment.EnvironmentPathUtils;
import org.eclipse.koneki.ldt.Activator;
import org.eclipse.koneki.ldt.core.IProjectSourceVisitor;
import org.eclipse.koneki.ldt.core.buildpath.LuaExecutionEnvironmentBuildpathUtil;

public final class LuaUtils {
    private LuaUtils() {
    }

    public static String getModuleFullName(IModuleSource module) {
        IModelElement modelElement = module.getModelElement();
        if (modelElement instanceof ISourceModule) {
            return LuaUtils.getModuleFullName((ISourceModule)modelElement);
        }
        return module.getFileName();
    }

    public static String getModuleFullName(ISourceModule module) {
        String moduleName = module.getElementName();
        if (moduleName.endsWith(".lua")) {
            moduleName = moduleName.replaceFirst("\\.lua$", "");
        }
        String prefix = null;
        if (module.getParent() instanceof IScriptFolder) {
            prefix = LuaUtils.getFolderFullName((IScriptFolder)module.getParent());
        }
        if (prefix != null) {
            if ("init".equalsIgnoreCase(moduleName)) {
                return prefix;
            }
            return String.valueOf(prefix) + "." + moduleName;
        }
        return moduleName;
    }

    private static String getFolderFullName(IScriptFolder folder) {
        if (!folder.isRootFolder()) {
            String folderName = folder.getElementName().replace("/", ".");
            IModelElement parent = folder.getParent();
            String prefix = null;
            if (parent instanceof IScriptFolder) {
                prefix = String.valueOf(LuaUtils.getFolderFullName((IScriptFolder)parent)) + ".";
            }
            if (prefix != null) {
                return String.valueOf(prefix) + "." + folderName;
            }
            return folderName;
        }
        return null;
    }

    public static IModuleSource getModuleSource(String name, IScriptProject project) {
        if (project == null && name == null || name.isEmpty()) {
            return null;
        }
        try {
            IProjectFragment[] allProjectFragments;
            IProjectFragment[] iProjectFragmentArray = allProjectFragments = project.getAllProjectFragments();
            int n = allProjectFragments.length;
            int n2 = 0;
            while (n2 < n) {
                IProjectFragment projectFragment = iProjectFragmentArray[n2];
                IModuleSource moduleSource = LuaUtils.getModuleSource(name, (IParent)projectFragment);
                if (moduleSource != null) {
                    return moduleSource;
                }
                ++n2;
            }
        }
        catch (ModelException e) {
            Activator.logError(MessageFormat.format("Unable to find module: {0}.", name), e);
            return null;
        }
        return null;
    }

    private static IModuleSource getModuleSource(String name, IParent parent) throws ModelException {
        IModelElement[] children;
        IModelElement[] iModelElementArray = children = parent.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IModuleSource moduleSource;
            IModelElement child = iModelElementArray[n2];
            if (child instanceof IModuleSource) {
                if (name.equals(LuaUtils.getModuleFullName((IModuleSource)child))) {
                    return (IModuleSource)child;
                }
            } else if (child instanceof IParent && (moduleSource = LuaUtils.getModuleSource(name, (IParent)child)) != null) {
                return moduleSource;
            }
            ++n2;
        }
        return null;
    }

    public static ISourceModule getSourceModule(String name, IScriptProject project) {
        IModuleSource moduleSource = LuaUtils.getModuleSource(name, project);
        if (moduleSource instanceof ISourceModule) {
            return (ISourceModule)moduleSource;
        }
        return null;
    }

    public static IModuleSource getModuleSourceFromAbsoluteURI(URI absolutepath, IScriptProject project) {
        if (project == null || absolutepath == null) {
            return null;
        }
        ISourceModule sourceModule = LuaUtils.getSourceModuleFromAbsoluteURI(absolutepath, project);
        if (sourceModule instanceof IModuleSource) {
            return (IModuleSource)sourceModule;
        }
        return null;
    }

    public static ISourceModule getSourceModuleFromAbsoluteURI(URI absolutepath, IScriptProject project) {
        if (project == null || absolutepath == null) {
            return null;
        }
        try {
            IProjectFragment[] allProjectFragments;
            IProjectFragment[] iProjectFragmentArray = allProjectFragments = project.getAllProjectFragments();
            int n = allProjectFragments.length;
            int n2 = 0;
            while (n2 < n) {
                IProjectFragment projectFragment = iProjectFragmentArray[n2];
                ISourceModule moduleSource = LuaUtils.getSourceModuleFromAbsolutePath(absolutepath, (IParent)projectFragment);
                if (moduleSource != null) {
                    return moduleSource;
                }
                ++n2;
            }
        }
        catch (ModelException e) {
            Activator.logError(MessageFormat.format("Unable to find module: {0}.", absolutepath), e);
            return null;
        }
        return null;
    }

    private static ISourceModule getSourceModuleFromAbsolutePath(URI absolutepath, IParent parent) throws ModelException {
        IModelElement[] children;
        IModelElement[] iModelElementArray = children = parent.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            ISourceModule moduleSource;
            IModelElement child = iModelElementArray[n2];
            if (child instanceof ISourceModule) {
                if (URIUtil.sameURI((URI)absolutepath, (URI)LuaUtils.getModuleAbsolutePath((ISourceModule)child))) {
                    return (ISourceModule)child;
                }
            } else if (child instanceof IParent && (moduleSource = LuaUtils.getSourceModuleFromAbsolutePath(absolutepath, (IParent)child)) != null) {
                return moduleSource;
            }
            ++n2;
        }
        return null;
    }

    public static URI getModuleAbsolutePath(ISourceModule module) {
        if (module instanceof IExternalSourceModule) {
            String path = EnvironmentPathUtils.getLocalPath((IPath)module.getPath()).toString();
            if (path.length() != 0 && path.charAt(0) != '/') {
                path = String.valueOf('/') + path;
            }
            try {
                return new URI("file", "", path, null);
            }
            catch (URISyntaxException e) {
                String message = MessageFormat.format("Unable to get file uri for external module : {0}.", module.getPath());
                Activator.logWarning(message, e);
            }
        } else if (module.getResource() != null) {
            return module.getResource().getLocationURI();
        }
        return null;
    }

    public static List<IScriptProject> getDependencies(IScriptProject project) throws ModelException {
        ArrayList<IScriptProject> result = new ArrayList<IScriptProject>();
        IProjectFragment[] projectFragments = project.getAllProjectFragments();
        int i = 0;
        while (i < projectFragments.length) {
            IProjectFragment projectFragment = projectFragments[i];
            if (LuaUtils.isProjectDependencyFragment(project, projectFragment)) {
                IScriptProject currentScriptProject = projectFragment.getScriptProject();
                result.add(currentScriptProject);
            }
            ++i;
        }
        return result;
    }

    public static boolean isProjectDependencyFragment(IScriptProject project, IProjectFragment projectFragment) throws ModelException {
        IScriptProject fragmentProject = projectFragment.getScriptProject();
        if (fragmentProject != null && fragmentProject != project) {
            return !projectFragment.isArchive() && !projectFragment.isBinary() && !projectFragment.isExternal();
        }
        return false;
    }

    public static boolean isExecutionEnvironmentFragment(IProjectFragment projectFragment) throws ModelException {
        IBuildpathEntry rawBuildpathEntry = projectFragment.getRawBuildpathEntry();
        return rawBuildpathEntry != null && LuaExecutionEnvironmentBuildpathUtil.isValidExecutionEnvironmentBuildPath(rawBuildpathEntry.getPath());
    }

    public static void visitSourceFiles(IScriptProject project, EnumSet<ProjectFragmentFilter> filter, IProjectSourceVisitor visitor, IProgressMonitor monitor) throws CoreException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)10);
        ArrayList<IProjectFragment> filteredProjecFragment = new ArrayList<IProjectFragment>();
        IProjectFragment[] projectFragments = project.getAllProjectFragments();
        SubMonitor filteredLoopMonitor = subMonitor.newChild(1).setWorkRemaining(projectFragments.length);
        int i = 0;
        while (i < projectFragments.length && !monitor.isCanceled()) {
            IProjectFragment projectFragment = projectFragments[i];
            if (LuaUtils.isProjectDependencyFragment(project, projectFragment)) {
                if (filter.contains((Object)ProjectFragmentFilter.DEPENDENT_PROJECT)) {
                    filteredProjecFragment.add(projectFragment);
                }
            } else if (LuaUtils.isExecutionEnvironmentFragment(projectFragment)) {
                if (filter.contains((Object)ProjectFragmentFilter.EXECUTION_ENVIRONMENT)) {
                    filteredProjecFragment.add(projectFragment);
                }
            } else if (projectFragment.isArchive()) {
                if (filter.contains((Object)ProjectFragmentFilter.ARCHIVE)) {
                    filteredProjecFragment.add(projectFragment);
                }
            } else {
                filteredProjecFragment.add(projectFragment);
            }
            filteredLoopMonitor.worked(1);
            ++i;
        }
        SubMonitor visitLoopMonitor = subMonitor.newChild(9).setWorkRemaining(filteredProjecFragment.size());
        for (IProjectFragment projectFragment : filteredProjecFragment) {
            if (monitor.isCanceled()) {
                return;
            }
            LuaUtils.visitSourceFiles((IParent)projectFragment, visitor, (IProgressMonitor)visitLoopMonitor.newChild(1));
        }
    }

    @Deprecated
    public static void visitSourceFiles(IParent parent, IProjectSourceVisitor visitor, IProgressMonitor monitor) throws CoreException {
        LuaUtils.visitSourceFiles(parent, visitor, monitor, (IPath)Path.EMPTY);
    }

    private static void visitSourceFiles(IParent parent, IProjectSourceVisitor visitor, IProgressMonitor monitor, IPath currentPath) throws CoreException {
        IModelElement[] children = parent.getChildren();
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)children.length);
        int i = 0;
        while (i < children.length && !monitor.isCanceled()) {
            IModelElement modelElement = children[i];
            if (modelElement instanceof ISourceModule) {
                String charset;
                IPath absolutePath;
                IResource resource = modelElement.getResource();
                if (resource instanceof IFile) {
                    IFile file = (IFile)resource;
                    absolutePath = new Path(resource.getLocationURI().getPath());
                    charset = file.getCharset();
                } else {
                    absolutePath = LuaUtils.getAbsolutePathFromModelElement(modelElement);
                    charset = Charset.defaultCharset().toString();
                }
                IPath relativeFilePath = currentPath.append(absolutePath.lastSegment());
                visitor.processFile(absolutePath, relativeFilePath, charset, (IProgressMonitor)subMonitor.newChild(1));
            } else if (modelElement instanceof IScriptFolder) {
                IScriptFolder innerSourceFolder = (IScriptFolder)modelElement;
                if (!innerSourceFolder.isRootFolder()) {
                    IResource resource = innerSourceFolder.getResource();
                    Object absolutePath = resource != null ? new Path(resource.getLocationURI().getPath()) : LuaUtils.getAbsolutePathFromModelElement(modelElement);
                    IPath newPath = currentPath.append(innerSourceFolder.getElementName());
                    visitor.processDirectory((IPath)absolutePath, newPath, monitor);
                    LuaUtils.visitSourceFiles((IParent)innerSourceFolder, visitor, (IProgressMonitor)subMonitor.newChild(1), newPath);
                } else {
                    LuaUtils.visitSourceFiles((IParent)innerSourceFolder, visitor, (IProgressMonitor)subMonitor.newChild(1));
                }
            }
            ++i;
        }
    }

    private static IPath getAbsolutePathFromModelElement(IModelElement modelElement) throws CoreException {
        IPath folderPath = modelElement.getPath();
        if (EnvironmentPathUtils.isFull((IPath)folderPath)) {
            return EnvironmentPathUtils.getLocalPath((IPath)folderPath);
        }
        String message = MessageFormat.format("Unable to get absolute location for {0}.", modelElement.getElementName());
        Status status = new Status(4, "org.eclipse.koneki.ldt", message);
        throw new CoreException((IStatus)status);
    }

    public static enum ProjectFragmentFilter {
        EXECUTION_ENVIRONMENT,
        DEPENDENT_PROJECT,
        ARCHIVE;

    }
}

