/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.koneki.ldt.debug.ui.internal.launchconfiguration.local;

import java.text.MessageFormat;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.dltk.internal.debug.ui.launcher.AbstractScriptLaunchShortcut;
import org.eclipse.koneki.ldt.debug.ui.internal.Activator;

public class LuaApplicationLaunchShortcut
extends AbstractScriptLaunchShortcut {
    protected ILaunchConfigurationType getConfigurationType() {
        return DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurationType("org.eclipse.koneki.ldt.debug.core.lualocaldebug");
    }

    protected String getNatureId() {
        return "org.eclipse.koneki.ldt.nature";
    }

    protected IResource chooseScript(IResource[] scripts, String title) {
        IPath defaultPath = new Path("src").append("main.lua");
        IResource[] iResourceArray = scripts;
        int n = scripts.length;
        int n2 = 0;
        while (n2 < n) {
            int numberOfSegmentToTest;
            IResource script = iResourceArray[n2];
            IPath scriptPath = script.getLocation();
            if (scriptPath.segmentCount() > defaultPath.segmentCount() && (scriptPath = scriptPath.removeFirstSegments(numberOfSegmentToTest = scriptPath.segmentCount() - defaultPath.segmentCount())).equals((Object)defaultPath)) {
                return script;
            }
            ++n2;
        }
        return super.chooseScript(scripts, title);
    }

    protected ILaunchConfiguration createConfiguration(IResource script) {
        ILaunchConfiguration config = null;
        ILaunchConfigurationWorkingCopy wc = null;
        try {
            ILaunchConfigurationType configType = this.getConfigurationType();
            String fileNameWithoutExtension = script.getLocation().removeFileExtension().lastSegment();
            String configNamePrefix = MessageFormat.format("{0}#{1}", script.getProject().getName(), fileNameWithoutExtension);
            wc = configType.newInstance(null, this.getLaunchManager().generateLaunchConfigurationName(configNamePrefix));
            wc.setAttribute("nature", this.getNatureId());
            wc.setAttribute("project", script.getProject().getName());
            wc.setAttribute("mainScript", script.getProjectRelativePath().toPortableString());
            wc.setAttribute("process_factory_id", "org.eclipse.dltk.launching.scriptProcessFactory");
            wc.setMappedResources(new IResource[]{script});
            config = wc.doSave();
        }
        catch (CoreException e) {
            Activator.logError("Unable to create a launch configuration from a LaunchShortcut", e);
        }
        return config;
    }
}

