/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.koneki.ldt.ui.internal.editor.completion;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dltk.compiler.CharOperation;
import org.eclipse.dltk.ui.DLTKPluginImages;
import org.eclipse.dltk.ui.text.completion.ContentAssistInvocationContext;
import org.eclipse.dltk.ui.text.completion.IScriptCompletionProposalComputer;
import org.eclipse.dltk.ui.text.completion.ScriptCompletionProposal;
import org.eclipse.dltk.ui.text.completion.ScriptContentAssistInvocationContext;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.koneki.ldt.ui.internal.Activator;
import org.eclipse.koneki.ldt.ui.internal.editor.LuaDocumentorTags;
import org.eclipse.koneki.ldt.ui.internal.editor.templates.LuaDocumentorTemplateCompletionProcessor;

public class LuaDocumentorCompletionProposalComputer
implements IScriptCompletionProposalComputer {
    public void sessionStarted() {
    }

    public void sessionEnded() {
    }

    public List<ICompletionProposal> computeCompletionProposals(ContentAssistInvocationContext context, IProgressMonitor monitor) {
        IDocument document = context.getDocument();
        try {
            ITypedRegion[] partitions;
            IRegion contentAssistRegion = document.getLineInformationOfOffset(context.getInvocationOffset());
            char[] contentAssistLine = document.get(contentAssistRegion.getOffset(), contentAssistRegion.getLength()).toCharArray();
            int contentAssistOffsetInLine = context.getInvocationOffset() - contentAssistRegion.getOffset();
            int offsetInCurrentLine = 0;
            ITypedRegion[] iTypedRegionArray = partitions = TextUtilities.computePartitioning((IDocument)document, (String)"__lua_partitioning", (int)0, (int)document.getLength(), (boolean)false);
            int n = partitions.length;
            int n2 = 0;
            while (n2 < n) {
                ITypedRegion region = iTypedRegionArray[n2];
                if (("__lua_doc".equals(region.getType()) || "__lua_doc_multi_line".equals(region.getType())) && context.getInvocationOffset() >= region.getOffset() && context.getInvocationOffset() < region.getOffset() + region.getLength()) {
                    int invocationLine;
                    int blockFirstLine = document.getLineOfOffset(region.getOffset());
                    boolean isInvocationOnFirstLine = blockFirstLine == (invocationLine = document.getLineOfOffset(context.getInvocationOffset()));
                    offsetInCurrentLine = isInvocationOnFirstLine ? region.getOffset() - document.getLineOffset(blockFirstLine) : 0;
                    if ("__lua_doc_multi_line".equals(region.getType())) {
                        if (isInvocationOnFirstLine) {
                            offsetInCurrentLine = LuaDocumentorCompletionProposalComputer.skipOpenningMultiLineChars(contentAssistLine, offsetInCurrentLine, contentAssistOffsetInLine);
                        }
                    } else if ("__lua_doc".equals(region.getType())) {
                        offsetInCurrentLine = isInvocationOnFirstLine ? (offsetInCurrentLine += 3) : (offsetInCurrentLine += 2);
                    }
                }
                ++n2;
            }
            if ((offsetInCurrentLine = LuaDocumentorCompletionProposalComputer.skipSpaces(contentAssistLine, offsetInCurrentLine, contentAssistOffsetInLine)) > contentAssistOffsetInLine) {
                return Collections.emptyList();
            }
            int tagStart = offsetInCurrentLine;
            boolean endOfLine = contentAssistLine.length == contentAssistOffsetInLine;
            boolean isCursorFollowedByWhitespace = !endOfLine && Character.isWhitespace(contentAssistLine[contentAssistOffsetInLine]);
            String partialTag = new String(contentAssistLine, tagStart, contentAssistOffsetInLine - tagStart);
            return this.completionOnTag(context, partialTag, endOfLine, isCursorFollowedByWhitespace);
        }
        catch (BadLocationException e) {
            Activator.logError("Compute completion proposal error", e);
            return Collections.emptyList();
        }
    }

    private static int skipOpenningMultiLineChars(char[] contentAssistLine, int offsetInCurrentLine, int contentAssistOffsetInLine) {
        String startBlockToCursor;
        Pattern pattern = Pattern.compile("^--\\[=*\\[-");
        Matcher matcher = pattern.matcher(startBlockToCursor = new String(contentAssistLine, offsetInCurrentLine, contentAssistOffsetInLine - offsetInCurrentLine));
        if (matcher.find()) {
            return matcher.end() + offsetInCurrentLine;
        }
        return offsetInCurrentLine;
    }

    private static int skipSpaces(char[] line, int offsetInCurrentLine, int offsetInLine) {
        while (offsetInCurrentLine < offsetInLine && Character.isWhitespace(line[offsetInCurrentLine])) {
            ++offsetInCurrentLine;
        }
        return offsetInCurrentLine;
    }

    private List<ICompletionProposal> completionOnTag(ContentAssistInvocationContext context, String tag, boolean nothingAfterOnTheLine, boolean tagFollowedByWhitespace) {
        ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>();
        LuaDocumentorTemplateCompletionProcessor processor = new LuaDocumentorTemplateCompletionProcessor((ScriptContentAssistInvocationContext)context);
        Collections.addAll(proposals, processor.computeCompletionProposals(context.getViewer(), context.getInvocationOffset()));
        HashSet tags = new HashSet();
        Collections.addAll(tags, LuaDocumentorTags.getTags());
        for (String jsdocTag : tags) {
            if (!CharOperation.prefixEquals((String)tag, (String)jsdocTag)) continue;
            int relevance = nothingAfterOnTheLine ? 50 : 95;
            String replacement = jsdocTag;
            if (nothingAfterOnTheLine || !tagFollowedByWhitespace) {
                replacement = String.valueOf(replacement) + ' ';
            }
            proposals.add((ICompletionProposal)new ScriptCompletionProposal(replacement, context.getInvocationOffset() - tag.length(), tag.length(), DLTKPluginImages.get((String)"org.eclipse.dltk.ui.jdoc_tag_obj.gif"), jsdocTag, relevance, true));
        }
        return proposals;
    }

    public List<IContextInformation> computeContextInformation(ContentAssistInvocationContext context, IProgressMonitor monitor) {
        return Collections.emptyList();
    }

    public String getErrorMessage() {
        return null;
    }
}

