/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.koneki.ldt.ui.internal.preferences;

import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.RowDataFactory;
import org.eclipse.jface.layout.RowLayoutFactory;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.koneki.ldt.core.internal.buildpath.LuaExecutionEnvironment;
import org.eclipse.koneki.ldt.core.internal.buildpath.LuaExecutionEnvironmentManager;
import org.eclipse.koneki.ldt.ui.SWTUtil;
import org.eclipse.koneki.ldt.ui.internal.Activator;
import org.eclipse.koneki.ldt.ui.internal.buildpath.LuaExecutionEnvironmentContentProvider;
import org.eclipse.koneki.ldt.ui.internal.buildpath.LuaExecutionEnvironmentLabelProvider;
import org.eclipse.koneki.ldt.ui.internal.preferences.Messages;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class LuaExecutionEnvironmentPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private TreeViewer eeTreeViewer;
    private Button removeButton;

    public LuaExecutionEnvironmentPreferencePage() {
        this.setDescription(Messages.LuaExecutionEnvironmentPreferencePageTitle);
        this.noDefaultAndApplyButton();
    }

    public void init(IWorkbench workbench) {
    }

    protected Control createContents(Composite parent) {
        Composite containerComposite = new Composite(parent, 0);
        GridLayoutFactory.swtDefaults().margins(0, 0).numColumns(2).applyTo(containerComposite);
        this.eeTreeViewer = new TreeViewer(containerComposite, 2820);
        this.eeTreeViewer.setContentProvider((IContentProvider)new LuaExecutionEnvironmentContentProvider());
        this.eeTreeViewer.setLabelProvider((IBaseLabelProvider)new DelegatingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new LuaExecutionEnvironmentLabelProvider()));
        this.eeTreeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                LuaExecutionEnvironmentPreferencePage.this.refreshRemoveButton();
            }
        });
        GridDataFactory.fillDefaults().grab(true, true).applyTo(this.eeTreeViewer.getControl());
        Composite buttonsComposite = new Composite(containerComposite, 0);
        GridDataFactory.fillDefaults().applyTo((Control)buttonsComposite);
        RowLayoutFactory.fillDefaults().type(512).fill(true).applyTo(buttonsComposite);
        Button addButton = new Button(buttonsComposite, 0);
        RowDataFactory.swtDefaults().hint(SWTUtil.getButtonWidthHint(addButton), -1).applyTo((Control)addButton);
        addButton.setText(Messages.LuaExecutionEnvironmentPreferencePage_addbutton);
        this.removeButton = new Button(buttonsComposite, 0);
        RowDataFactory.swtDefaults().hint(SWTUtil.getButtonWidthHint(this.removeButton), -1).applyTo((Control)this.removeButton);
        this.removeButton.setText(Messages.LuaExecutionEnvironmentPreferencePage_removeButton);
        addButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                LuaExecutionEnvironmentPreferencePage.this.doAddButtonSelection(e);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.removeButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                this.widgetDefaultSelected(e);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                LuaExecutionEnvironmentPreferencePage.this.doRemoveSelection(e);
            }
        });
        this.initializePage();
        return containerComposite;
    }

    private void doAddButtonSelection(SelectionEvent se) {
        FileDialog filedialog = new FileDialog(Display.getDefault().getActiveShell());
        filedialog.setFilterExtensions(new String[]{"*.zip"});
        String selectedFilePath = filedialog.open();
        if (selectedFilePath == null) {
            return;
        }
        try {
            boolean okToInstall;
            LuaExecutionEnvironment ee = LuaExecutionEnvironmentManager.getExecutionEnvironmentFromCompressedFile((String)selectedFilePath);
            List embeddedExecutionEnvironments = LuaExecutionEnvironmentManager.getEmbeddedExecutionEnvironments();
            if (embeddedExecutionEnvironments.contains(ee) && !(okToInstall = MessageDialog.openQuestion((Shell)this.getShell(), (String)Messages.LuaExecutionEnvironmentPreferencePage_addEESupportTitle, (String)NLS.bind((String)Messages.LuaExecutionEnvironmentPreferencePage_addEESupportMessage, (Object)ee.getEEIdentifier())))) {
                return;
            }
            LuaExecutionEnvironmentManager.installLuaExecutionEnvironment((String)selectedFilePath);
            this.initializePage();
        }
        catch (CoreException e) {
            ErrorDialog.openError((Shell)filedialog.getParent(), null, null, (IStatus)e.getStatus());
            Activator.log(e.getStatus());
        }
    }

    private void doRemoveSelection(SelectionEvent event) {
        LuaExecutionEnvironment ee = this.getSelectedExecutionEnvironment();
        if (ee == null) {
            return;
        }
        try {
            LuaExecutionEnvironmentManager.uninstallLuaExecutionEnvironment((LuaExecutionEnvironment)ee);
            this.initializePage();
        }
        catch (CoreException e) {
            ErrorDialog.openError((Shell)this.getShell(), null, null, (IStatus)e.getStatus());
            Activator.log(e.getStatus());
        }
    }

    private LuaExecutionEnvironment getSelectedExecutionEnvironment() {
        StructuredSelection sSelection;
        Object currentSelection;
        if (this.eeTreeViewer == null) {
            return null;
        }
        ISelection selection = this.eeTreeViewer.getSelection();
        if (selection.isEmpty()) {
            return null;
        }
        if (selection instanceof StructuredSelection && (currentSelection = (sSelection = (StructuredSelection)selection).getFirstElement()) instanceof LuaExecutionEnvironment) {
            return (LuaExecutionEnvironment)currentSelection;
        }
        return null;
    }

    private void refreshRemoveButton() {
        if (this.removeButton != null) {
            LuaExecutionEnvironment ee = this.getSelectedExecutionEnvironment();
            this.removeButton.setEnabled(ee != null && !ee.isEmbedded());
        }
    }

    private void initializePage() {
        if (this.eeTreeViewer == null) {
            return;
        }
        this.eeTreeViewer.setInput((Object)LuaExecutionEnvironmentManager.getAvailableExecutionEnvironments());
        this.refreshRemoveButton();
    }
}

