/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.koneki.ldt.core.internal.ast.parser;

import com.naef.jnlua.LuaException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.dltk.ast.parser.AbstractSourceParser;
import org.eclipse.dltk.ast.parser.IModuleDeclaration;
import org.eclipse.dltk.compiler.env.IModuleSource;
import org.eclipse.dltk.compiler.problem.DefaultProblem;
import org.eclipse.dltk.compiler.problem.IProblem;
import org.eclipse.dltk.compiler.problem.IProblemReporter;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.ElementChangedEvent;
import org.eclipse.dltk.core.IElementChangedListener;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IModelElementDelta;
import org.eclipse.koneki.ldt.core.internal.Activator;
import org.eclipse.koneki.ldt.core.internal.ast.models.LuaDLTKModelUtils;
import org.eclipse.koneki.ldt.core.internal.ast.models.common.LuaSourceRoot;
import org.eclipse.koneki.ldt.core.internal.ast.parser.ModelsBuilderLuaModule;

public class LuaSourceParser
extends AbstractSourceParser {
    private static ModelsBuilderLuaModule astBuilder = new ModelsBuilderLuaModule();
    private static Map<IModelElement, IModuleDeclaration> cache = new Hashtable<IModelElement, IModuleDeclaration>();
    private static IElementChangedListener changedListener = new IElementChangedListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void elementChanged(ElementChangedEvent event) {
            Class<LuaSourceParser> clazz = LuaSourceParser.class;
            synchronized (LuaSourceParser.class) {
                IModelElementDelta delta = event.getDelta();
                this.processDelta(delta);
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
        }

        private void processDelta(IModelElementDelta delta) {
            IModelElement element = delta.getElement();
            if (element.getElementType() == 5) {
                if (delta.getKind() == 2) {
                    cache.remove(element);
                } else if (delta.getKind() == 4 && delta.getFlags() == 65536) {
                    cache.remove(element);
                }
            }
            if (delta.getFlags() == 128 && delta.getAffectedChildren().length == 0) {
                for (IModelElement sourcemodule : new ArrayList(cache.keySet())) {
                    if (!LuaDLTKModelUtils.isAncestor(sourcemodule, element)) continue;
                    cache.remove(sourcemodule);
                }
            }
            if ((delta.getFlags() & 8) != 0) {
                IModelElementDelta[] affectedChildren = delta.getAffectedChildren();
                int i = 0;
                while (i < affectedChildren.length) {
                    IModelElementDelta child = affectedChildren[i];
                    this.processDelta(child);
                    ++i;
                }
            }
        }
    };

    static {
        DLTKCore.addElementChangedListener((IElementChangedListener)changedListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IModuleDeclaration parse(IModuleSource input, IProblemReporter reporter) {
        LuaSourceRoot module = new LuaSourceRoot(input.getSourceContents().length());
        Class<LuaSourceParser> clazz = LuaSourceParser.class;
        synchronized (LuaSourceParser.class) {
            try {
                module = astBuilder.buildAST(input.getSourceContents());
            }
            catch (LuaException e) {
                Activator.logError("Unable to load metalua ast builder :" + input.getFileName(), e);
            }
            if (module != null) {
                if (module.hasError()) {
                    LuaSourceRoot cached;
                    DefaultProblem problem = module.getProblem();
                    problem.setOriginatingFileName(input.getFileName());
                    reporter.reportProblem((IProblem)problem);
                    if (input.getModelElement() != null && (cached = (LuaSourceRoot)cache.get(input.getModelElement())) != null) {
                        cached.setError(true);
                        // ** MonitorExit[var4_4] (shouldn't be in output)
                        return cached;
                    }
                } else if (input.getModelElement() != null) {
                    cache.put(input.getModelElement(), (IModuleDeclaration)module);
                }
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return module;
        }
    }
}

