/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core.search;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.search.indexing.IProjectIndexer;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectIndexerManager {
    private static final String EXTPOINT = "org.eclipse.dltk.core.projectIndexer";
    private static final String NATURE_ATTR = "nature";
    private static final String CLASS_ATTR = "class";
    private static final String ID_ATTR = "id";
    private static final String INDEXER_ATTR = "indexer";
    private static final String ENABLE_ELEM = "enable";
    private static final String DISABLE_ELEM = "disable";
    private static final String INDEXER_ELEM = "projectIndexer";
    private static Map<String, ProjectIndexerDescriptor> indexers;
    private static final Map<String, Set<String>> enabledIndexers;
    private static final Map<String, Set<String>> disabledIndexers;
    private static boolean enabled;

    static {
        enabledIndexers = new HashMap<String, Set<String>>();
        disabledIndexers = new HashMap<String, Set<String>>();
        enabled = true;
    }

    private static synchronized void initialize() {
        if (indexers != null) {
            return;
        }
        indexers = new HashMap<String, ProjectIndexerDescriptor>();
        IConfigurationElement[] iConfigurationElementArray = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTPOINT);
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            String nature;
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (DISABLE_ELEM.equals(element.getName())) {
                nature = element.getAttribute(NATURE_ATTR);
                Set<String> disabledForNature = disabledIndexers.get(nature);
                if (disabledForNature == null) {
                    disabledForNature = new HashSet<String>();
                    disabledIndexers.put(nature, disabledForNature);
                }
                disabledForNature.add(element.getAttribute(INDEXER_ATTR));
            } else if (ENABLE_ELEM.equals(element.getName())) {
                nature = element.getAttribute(NATURE_ATTR);
                Set<String> enabledForNature = enabledIndexers.get(nature);
                if (enabledForNature == null) {
                    enabledForNature = new HashSet<String>();
                    enabledIndexers.put(nature, enabledForNature);
                }
                enabledForNature.add(element.getAttribute(INDEXER_ATTR));
            } else if (INDEXER_ELEM.equals(element.getName())) {
                String id = element.getAttribute(ID_ATTR);
                if (id == null) {
                    DLTKCore.warn(NLS.bind((String)"{0} contributed by {1} does not have \"{2}\" attribute", (Object[])new Object[]{INDEXER_ELEM, element.getContributor().getName(), ID_ATTR}));
                } else if (indexers.containsKey(id)) {
                    DLTKCore.warn(NLS.bind((String)"Duplicate {0} contribution from {1} (previous one is from \"{2}\")", (Object[])new Object[]{INDEXER_ELEM, element.getContributor().getName(), indexers.get(id).element.getContributor().getName()}));
                } else {
                    indexers.put(id, new ProjectIndexerDescriptor(id, element));
                }
            }
            ++n2;
        }
    }

    public static boolean isEnabled() {
        return enabled;
    }

    public static void setEnabled(boolean value) {
        enabled = value;
    }

    public static IProjectIndexer[] getIndexers(String natureId) {
        ProjectIndexerManager.initialize();
        IProjectIndexer[] nature = ProjectIndexerManager.getByNature(natureId, natureId);
        IProjectIndexer[] all = ProjectIndexerManager.getByNature("#", natureId);
        if (all == null) {
            return nature;
        }
        if (nature == null) {
            return all;
        }
        IProjectIndexer[] result = new IProjectIndexer[nature.length + all.length];
        System.arraycopy(nature, 0, result, 0, nature.length);
        System.arraycopy(all, 0, result, nature.length, all.length);
        return result;
    }

    public static IProjectIndexer[] getAllIndexers() {
        ProjectIndexerManager.initialize();
        HashSet<String> indexerIds = new HashSet<String>();
        for (Set<String> ids : enabledIndexers.values()) {
            indexerIds.addAll(ids);
        }
        return ProjectIndexerManager.getIndexers(indexerIds, null);
    }

    private static IProjectIndexer[] getByNature(String natureId, String disabledNature) {
        Set<String> indexerIds = enabledIndexers.get(natureId);
        if (indexerIds != null) {
            return ProjectIndexerManager.getIndexers(indexerIds, disabledNature);
        }
        return null;
    }

    private static IProjectIndexer[] getIndexers(Set<String> indexerIds, String disabledNature) {
        ArrayList<IProjectIndexer> result = new ArrayList<IProjectIndexer>(indexerIds.size());
        Set<String> disabled = disabledIndexers.get(disabledNature);
        for (String indexerId : indexerIds) {
            IProjectIndexer indexer;
            ProjectIndexerDescriptor descriptor;
            if (disabled != null && disabled.contains(indexerId) || (descriptor = indexers.get(indexerId)) == null || (indexer = descriptor.getObject()) == null) continue;
            result.add(indexer);
        }
        if (!result.isEmpty()) {
            return result.toArray(new IProjectIndexer[result.size()]);
        }
        return null;
    }

    private static IProjectIndexer[] getIndexers(IScriptProject project) {
        return ProjectIndexerManager.getIndexers(project, true);
    }

    private static IProjectIndexer[] getIndexers(IScriptProject project, boolean checkEnable) {
        if (!enabled) {
            return null;
        }
        if (checkEnable && !ProjectIndexerManager.isIndexerEnabled(project.getProject())) {
            return null;
        }
        IDLTKLanguageToolkit toolkit = DLTKLanguageManager.getLanguageToolkit(project);
        if (toolkit == null) {
            return null;
        }
        return ProjectIndexerManager.getIndexers(toolkit.getNatureId());
    }

    public static boolean isIndexerEnabled(IProject project) {
        if (!enabled) {
            return false;
        }
        return new ProjectScope(project).getNode("org.eclipse.dltk.core").getBoolean("org.eclipse.dltk.core.indexer", true);
    }

    public static void removeLibrary(IScriptProject project, IPath path) {
        IProjectIndexer[] indexers = ProjectIndexerManager.getIndexers(project);
        if (indexers != null) {
            int i = 0;
            while (i < indexers.length) {
                indexers[i].removeLibrary(project, path);
                ++i;
            }
        }
    }

    public static void removeProject(IPath projectPath) {
        IProjectIndexer[] indexers = ProjectIndexerManager.getAllIndexers();
        if (indexers != null) {
            int i = 0;
            while (i < indexers.length) {
                indexers[i].removeProject(projectPath);
                ++i;
            }
        }
    }

    public static void indexLibrary(IScriptProject project, IPath path) {
        IProjectIndexer[] indexers = ProjectIndexerManager.getIndexers(project);
        if (indexers != null) {
            int i = 0;
            while (i < indexers.length) {
                indexers[i].indexLibrary(project, path);
                ++i;
            }
        }
    }

    public static void removeProjectFragment(IScriptProject project, IPath path) {
        IProjectIndexer[] indexers = ProjectIndexerManager.getIndexers(project);
        if (indexers != null) {
            int i = 0;
            while (i < indexers.length) {
                indexers[i].removeProjectFragment(project, path);
                ++i;
            }
        }
    }

    public static void indexProjectFragment(IScriptProject project, IPath path) {
        IProjectIndexer[] indexers = ProjectIndexerManager.getIndexers(project);
        if (indexers != null) {
            int i = 0;
            while (i < indexers.length) {
                indexers[i].indexProjectFragment(project, path);
                ++i;
            }
        }
    }

    public static void indexProject(IProject project) {
        if (ProjectIndexerManager.isIndexerEnabled(project)) {
            ProjectIndexerManager.indexProject(project, DLTKCore.create(project));
        }
    }

    public static void indexProject(IScriptProject scriptProject) {
        IProject project = scriptProject.getProject();
        if (ProjectIndexerManager.isIndexerEnabled(project)) {
            ProjectIndexerManager.indexProject(project, scriptProject);
        }
    }

    private static void indexProject(IProject project, IScriptProject scriptProject) {
        IProjectIndexer[] indexers = ProjectIndexerManager.getIndexers(scriptProject, false);
        if (indexers != null) {
            int i = 0;
            while (i < indexers.length) {
                indexers[i].indexProject(scriptProject);
                ++i;
            }
        }
    }

    public static void removeSourceModule(IScriptProject project, String path) {
        IProjectIndexer[] indexers = ProjectIndexerManager.getIndexers(project);
        if (indexers != null) {
            int i = 0;
            while (i < indexers.length) {
                indexers[i].removeSourceModule(project, path);
                ++i;
            }
        }
    }

    public static void indexSourceModule(ISourceModule module, IDLTKLanguageToolkit toolkit) {
        if (!enabled) {
            return;
        }
        IProjectIndexer[] indexers = ProjectIndexerManager.getIndexers(toolkit.getNatureId());
        if (indexers != null) {
            int i = 0;
            while (i < indexers.length) {
                indexers[i].indexSourceModule(module, toolkit);
                ++i;
            }
        }
    }

    public static void reconciled(ISourceModule workingCopy) {
        IScriptProject project = workingCopy.getScriptProject();
        if (project == null) {
            return;
        }
        if (!ProjectIndexerManager.isIndexerEnabled(project.getProject())) {
            return;
        }
        IDLTKLanguageToolkit toolkit = DLTKLanguageManager.getLanguageToolkit(project);
        if (toolkit == null) {
            return;
        }
        IProjectIndexer[] indexers = ProjectIndexerManager.getIndexers(toolkit.getNatureId());
        if (indexers != null) {
            int i = 0;
            while (i < indexers.length) {
                indexers[i].reconciled(workingCopy, toolkit);
                ++i;
            }
        }
    }

    public static void startIndexing() {
        IProjectIndexer[] indexers = ProjectIndexerManager.getAllIndexers();
        if (indexers == null) {
            return;
        }
        boolean wantRefresh = false;
        int i = 0;
        while (i < indexers.length) {
            indexers[i].startIndexing();
            wantRefresh |= indexers[i].wantRefreshOnStart();
            ++i;
        }
        if (wantRefresh) {
            IScriptProject[] projects;
            try {
                projects = DLTKCore.create(ResourcesPlugin.getWorkspace().getRoot()).getScriptProjects();
            }
            catch (Exception e) {
                DLTKCore.error(e);
                return;
            }
            int i2 = 0;
            while (i2 < projects.length) {
                IScriptProject project = projects[i2];
                IProjectIndexer[] projectIndexers = ProjectIndexerManager.getIndexers(project);
                if (projectIndexers != null) {
                    IProjectIndexer[] iProjectIndexerArray = projectIndexers;
                    int n = projectIndexers.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IProjectIndexer projectIndexer = iProjectIndexerArray[n2];
                        if (projectIndexer.wantRefreshOnStart()) {
                            projectIndexer.indexProject(project);
                        }
                        ++n2;
                    }
                }
                ++i2;
            }
        }
    }

    private static class ProjectIndexerDescriptor {
        private final String id;
        private IConfigurationElement element;
        private IProjectIndexer projectIndexer;

        ProjectIndexerDescriptor(String id, IConfigurationElement element) {
            this.id = id;
            this.element = element;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IProjectIndexer getObject() {
            if (this.projectIndexer == null) {
                try {
                    this.projectIndexer = (IProjectIndexer)this.element.createExecutableExtension(ProjectIndexerManager.CLASS_ATTR);
                }
                catch (CoreException e) {
                    DLTKCore.error("Error initializing project indexer", e);
                    Class<ProjectIndexerManager> clazz = ProjectIndexerManager.class;
                    synchronized (ProjectIndexerManager.class) {
                        indexers.remove(this.id);
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                        return null;
                    }
                }
            }
            return this.projectIndexer;
        }
    }
}

