/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.koneki.ldt.debug.ui.internal.launchconfiguration.local;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchHistory;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.ILaunchGroup;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.IScriptFolder;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.debug.ui.launcher.AbstractScriptLaunchShortcut;
import org.eclipse.dltk.launching.LaunchingMessages;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.koneki.ldt.debug.ui.internal.Activator;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class LuaApplicationLaunchShortcut
extends AbstractScriptLaunchShortcut {
    private String launchMode;

    protected ILaunchConfigurationType getConfigurationType() {
        return DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurationType("org.eclipse.koneki.ldt.debug.core.lualocaldebug");
    }

    protected String getNatureId() {
        return "org.eclipse.koneki.ldt.nature";
    }

    public void searchAndLaunch(Object[] search, String mode, String selectMessage, String emptyMessage) {
        String message;
        this.launchMode = mode;
        Object selection = search[0];
        try {
            ILaunchConfiguration config;
            IContainer container = null;
            if (selection instanceof IContainer) {
                container = (IContainer)selection;
            } else if (selection instanceof IScriptProject || selection instanceof IScriptFolder || selection instanceof IProjectFragment) {
                container = (IContainer)((IModelElement)selection).getCorrespondingResource();
            }
            if (container != null && (config = this.findLaunchConfiguration(container)) != null) {
                DebugUITools.launch((ILaunchConfiguration)config, (String)mode);
                return;
            }
        }
        catch (ModelException e) {
            message = MessageFormat.format("Unable to retreive Launch Configuration for the selection: {0}", selection);
            Activator.logWarning(message, e);
        }
        catch (InterruptedException interruptedException) {
        }
        catch (CoreException e) {
            message = MessageFormat.format("Unable to retreive and launch Launch Configuration for the selection: {0}", selection);
            Activator.logWarning(message, e);
        }
        IResource[] scripts = null;
        try {
            scripts = this.findScripts(search, (IRunnableContext)PlatformUI.getWorkbench().getProgressService());
        }
        catch (InterruptedException interruptedException) {
            return;
        }
        catch (CoreException e) {
            MessageDialog.openError((Shell)this.getShell(), (String)LaunchingMessages.ScriptLaunchShortcut_0, (String)e.getMessage());
            return;
        }
        if (scripts.length == 0) {
            MessageDialog.openError((Shell)this.getShell(), (String)LaunchingMessages.ScriptLaunchShortcut_1, (String)emptyMessage);
        } else if (scripts.length == 1) {
            ILaunchConfiguration config = this.findLaunchConfiguration(scripts[0], this.getConfigurationType());
            if (config != null) {
                DebugUITools.launch((ILaunchConfiguration)config, (String)mode);
            }
        } else if (scripts.length > 1) {
            IResource script = this.chooseScript(scripts, selectMessage);
            this.launch(script, mode);
        }
    }

    private ILaunchConfiguration findLaunchConfiguration(IContainer container) throws CoreException, InterruptedException {
        List<ILaunchConfiguration> candidateConfigs = this.retreiveLaunchConfiguration();
        if (!(candidateConfigs = this.filterConfig(container, candidateConfigs)).isEmpty()) {
            return candidateConfigs.get(0);
        }
        return null;
    }

    protected ILaunchConfiguration findLaunchConfiguration(IResource script, ILaunchConfigurationType configType) {
        try {
            List<ILaunchConfiguration> candidateConfigs = this.retreiveLaunchConfiguration();
            candidateConfigs = this.filterConfig(Arrays.asList(script), candidateConfigs);
            if (!candidateConfigs.isEmpty()) {
                return candidateConfigs.get(0);
            }
        }
        catch (CoreException e) {
            String message = MessageFormat.format("Unable to retreive Launch Configuration for the given script: {0}", script);
            Activator.logWarning(message, e);
        }
        return this.createConfiguration(script);
    }

    private List<ILaunchConfiguration> retreiveLaunchConfiguration() throws CoreException {
        ILaunchGroup group = DebugUIPlugin.getDefault().getLaunchConfigurationManager().getLaunchGroup(this.getConfigurationType(), this.launchMode);
        LaunchHistory history = DebugUIPlugin.getDefault().getLaunchConfigurationManager().getLaunchHistory(group.getIdentifier());
        ArrayList<ILaunchConfiguration> candidateConfigs = new ArrayList<ILaunchConfiguration>();
        candidateConfigs.addAll(Arrays.asList(history.getFavorites()));
        candidateConfigs.addAll(Arrays.asList(history.getHistory()));
        if (candidateConfigs.isEmpty()) {
            candidateConfigs.addAll(Arrays.asList(DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurations(this.getConfigurationType())));
        }
        return candidateConfigs;
    }

    private List<ILaunchConfiguration> filterConfig(IContainer container, List<ILaunchConfiguration> candidateConfigs) throws InterruptedException, CoreException {
        IResource[] scripts = this.findScripts(new Object[]{container}, (IRunnableContext)PlatformUI.getWorkbench().getProgressService());
        return this.filterConfig(Arrays.asList(scripts), candidateConfigs);
    }

    private List<ILaunchConfiguration> filterConfig(List<IResource> scripts, List<ILaunchConfiguration> configs) throws CoreException {
        ArrayList<ILaunchConfiguration> candidateConfigs = new ArrayList<ILaunchConfiguration>();
        for (ILaunchConfiguration config : configs) {
            for (IResource script : scripts) {
                if (!config.getAttribute("mainScript", "").equals(script.getProjectRelativePath().toString()) || !config.getAttribute("project", "").equals(script.getProject().getName())) continue;
                candidateConfigs.add(config);
            }
        }
        return candidateConfigs;
    }

    protected IResource chooseScript(IResource[] scripts, String title) {
        IPath defaultPath = new Path("src").append("main.lua");
        IResource[] iResourceArray = scripts;
        int n = scripts.length;
        int n2 = 0;
        while (n2 < n) {
            int numberOfSegmentToTest;
            IResource script = iResourceArray[n2];
            IPath scriptPath = script.getLocation();
            if (scriptPath.segmentCount() > defaultPath.segmentCount() && (scriptPath = scriptPath.removeFirstSegments(numberOfSegmentToTest = scriptPath.segmentCount() - defaultPath.segmentCount())).equals((Object)defaultPath)) {
                return script;
            }
            ++n2;
        }
        return super.chooseScript(scripts, title);
    }

    protected ILaunchConfiguration createConfiguration(IResource script) {
        ILaunchConfiguration config = null;
        ILaunchConfigurationWorkingCopy wc = null;
        try {
            ILaunchConfigurationType configType = this.getConfigurationType();
            String fileNameWithoutExtension = script.getLocation().removeFileExtension().lastSegment();
            String configNamePrefix = MessageFormat.format("{0}#{1}", script.getProject().getName(), fileNameWithoutExtension);
            wc = configType.newInstance(null, this.getLaunchManager().generateLaunchConfigurationName(configNamePrefix));
            wc.setAttribute("nature", this.getNatureId());
            wc.setAttribute("project", script.getProject().getName());
            wc.setAttribute("mainScript", script.getProjectRelativePath().toPortableString());
            wc.setAttribute("process_factory_id", "org.eclipse.dltk.launching.scriptProcessFactory");
            wc.setMappedResources(new IResource[]{script});
            config = wc.doSave();
        }
        catch (CoreException e) {
            Activator.logError("Unable to create a launch configuration from a LaunchShortcut", e);
        }
        return config;
    }
}

