/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.koneki.ldt.ui.internal.documentation;

import java.io.Reader;
import java.io.StringReader;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.core.IMember;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.SourceParserUtil;
import org.eclipse.dltk.ui.documentation.IDocumentationResponse;
import org.eclipse.dltk.ui.documentation.IScriptDocumentationProvider;
import org.eclipse.dltk.ui.documentation.IScriptDocumentationProviderExtension;
import org.eclipse.dltk.ui.documentation.IScriptDocumentationProviderExtension2;
import org.eclipse.dltk.ui.documentation.TextDocumentationResponse;
import org.eclipse.koneki.ldt.core.internal.Activator;
import org.eclipse.koneki.ldt.core.internal.ast.models.LuaASTModelUtils;
import org.eclipse.koneki.ldt.core.internal.ast.models.common.IDocumentationHolder;
import org.eclipse.koneki.ldt.core.internal.ast.models.common.LuaSourceRoot;

public class LuaDocumentationProvider
implements IScriptDocumentationProvider,
IScriptDocumentationProviderExtension,
IScriptDocumentationProviderExtension2 {
    public Reader getInfo(IMember element, boolean lookIntoParents, boolean lookIntoExternal) {
        try {
            String memberDocumentation = this.getMemberDocumentation(element);
            if (memberDocumentation != null) {
                return new StringReader(memberDocumentation);
            }
        }
        catch (ModelException e) {
            Activator.logWarning((String)("unable to get documentation for :" + element), (Throwable)e);
        }
        return null;
    }

    public Reader getInfo(String content) {
        return null;
    }

    public IDocumentationResponse describeKeyword(String keyword, IModelElement context) {
        return null;
    }

    public IDocumentationResponse getDocumentationFor(Object element) {
        try {
            String moduleDocumentation;
            if (element instanceof IMember) {
                String memberDocumentation = this.getMemberDocumentation((IMember)element);
                if (memberDocumentation != null) {
                    return new TextDocumentationResponse(element, memberDocumentation);
                }
            } else if (element instanceof ISourceModule && (moduleDocumentation = this.getModuleDocumentation((ISourceModule)element)) != null) {
                return new TextDocumentationResponse(element, moduleDocumentation);
            }
        }
        catch (ModelException e) {
            Activator.logWarning((String)("unable to get documentation for :" + element), (Throwable)e);
        }
        return null;
    }

    private String getMemberDocumentation(IMember member) throws ModelException {
        ASTNode astNode = LuaASTModelUtils.getASTNode((IModelElement)member);
        if (astNode instanceof IDocumentationHolder) {
            return ((IDocumentationHolder)astNode).getDocumentation();
        }
        return null;
    }

    private String getModuleDocumentation(ISourceModule module) {
        ModuleDeclaration moduleDeclaration = SourceParserUtil.getModuleDeclaration((ISourceModule)module);
        if (moduleDeclaration instanceof LuaSourceRoot) {
            LuaSourceRoot root = (LuaSourceRoot)moduleDeclaration;
            return root.getFileapi().getDocumentation();
        }
        return null;
    }
}

