/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.koneki.ldt.core.internal.ast.models;

import java.util.List;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.core.Flags;
import org.eclipse.dltk.core.IField;
import org.eclipse.dltk.core.IMember;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.SourceParserUtil;
import org.eclipse.koneki.ldt.core.internal.Activator;
import org.eclipse.koneki.ldt.core.internal.ast.models.LuaASTUtils;
import org.eclipse.koneki.ldt.core.internal.ast.models.api.Item;
import org.eclipse.koneki.ldt.core.internal.ast.models.api.LuaFileAPI;
import org.eclipse.koneki.ldt.core.internal.ast.models.api.RecordTypeDef;
import org.eclipse.koneki.ldt.core.internal.ast.models.api.TypeDef;
import org.eclipse.koneki.ldt.core.internal.ast.models.common.LuaASTNode;
import org.eclipse.koneki.ldt.core.internal.ast.models.common.LuaSourceRoot;
import org.eclipse.koneki.ldt.core.internal.ast.models.dltk.FakeField;
import org.eclipse.koneki.ldt.core.internal.ast.models.file.LocalVar;

public final class LuaASTModelUtils {
    private LuaASTModelUtils() {
    }

    public static LuaSourceRoot getLuaSourceRoot(ISourceModule module) {
        ModuleDeclaration moduleDeclaration = SourceParserUtil.getModuleDeclaration((ISourceModule)module);
        if (moduleDeclaration instanceof LuaSourceRoot) {
            return (LuaSourceRoot)moduleDeclaration;
        }
        return null;
    }

    public static ASTNode getASTNode(IModelElement modelElement) {
        if (modelElement instanceof ISourceModule) {
            return LuaASTModelUtils.getLuaSourceRoot((ISourceModule)modelElement);
        }
        if (modelElement instanceof IType) {
            return LuaASTModelUtils.getTypeDef((IType)modelElement);
        }
        if (modelElement instanceof IField) {
            return LuaASTModelUtils.getItem((IField)modelElement);
        }
        if (modelElement instanceof IMethod) {
            return LuaASTModelUtils.getItem((IMethod)modelElement);
        }
        return null;
    }

    public static TypeDef getTypeDef(IType type) {
        LuaSourceRoot luaSourceRoot = LuaASTModelUtils.getLuaSourceRoot(type.getSourceModule());
        LuaFileAPI fileapi = luaSourceRoot.getFileapi();
        return fileapi.getTypes().get(type.getElementName());
    }

    public static Item getItem(IField field) {
        block6: {
            IModelElement parent = field.getParent();
            if (parent instanceof IType) {
                RecordTypeDef typeDef = (RecordTypeDef)LuaASTModelUtils.getTypeDef((IType)parent);
                return typeDef.getFields().get(field.getElementName());
            }
            if (parent instanceof ISourceModule) {
                LuaSourceRoot luaSourceRoot = LuaASTModelUtils.getLuaSourceRoot((ISourceModule)parent);
                try {
                    if (Flags.isPrivate((int)field.getFlags())) {
                        List<LocalVar> localVars = luaSourceRoot.getInternalContent().getContent().getLocalVars();
                        for (LocalVar localVar : localVars) {
                            if (!localVar.getVar().getName().equals(field.getElementName())) continue;
                            return localVar.getVar();
                        }
                        break block6;
                    }
                    return luaSourceRoot.getFileapi().getGlobalvars().get(field.getElementName());
                }
                catch (ModelException e) {
                    Activator.logError("unable to get item from field " + field, e);
                    return null;
                }
            }
        }
        return null;
    }

    public static Item getItem(IMethod method) {
        block6: {
            IModelElement parent = method.getParent();
            if (parent instanceof IType) {
                RecordTypeDef typeDef = (RecordTypeDef)LuaASTModelUtils.getTypeDef((IType)parent);
                return typeDef.getFields().get(method.getElementName());
            }
            if (parent instanceof ISourceModule) {
                LuaSourceRoot luaSourceRoot = LuaASTModelUtils.getLuaSourceRoot((ISourceModule)parent);
                try {
                    if (Flags.isPrivate((int)method.getFlags())) {
                        List<LocalVar> localVars = luaSourceRoot.getInternalContent().getContent().getLocalVars();
                        for (LocalVar localVar : localVars) {
                            if (!localVar.getVar().getName().equals(method.getElementName())) continue;
                            return localVar.getVar();
                        }
                        break block6;
                    }
                    return luaSourceRoot.getFileapi().getGlobalvars().get(method.getElementName());
                }
                catch (ModelException e) {
                    Activator.logError("unable to get item from method " + method, e);
                    return null;
                }
            }
        }
        return null;
    }

    public static IType getIType(ISourceModule module, RecordTypeDef recordtypeDef) {
        IType type = module.getType(recordtypeDef.getName());
        return type;
    }

    public static IMember getIMember(ISourceModule sourceModule, Item item) {
        LuaASTNode parent = item.getParent();
        if (LuaASTUtils.isTypeField(item)) {
            IType iType = LuaASTModelUtils.getIType(sourceModule, (RecordTypeDef)parent);
            if (iType != null) {
                try {
                    IModelElement[] iModelElementArray = iType.getChildren();
                    int n = iModelElementArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IModelElement child = iModelElementArray[n2];
                        if (child.getElementName().equals(item.getName()) && child instanceof IMember) {
                            return (IMember)child;
                        }
                        ++n2;
                    }
                }
                catch (ModelException e) {
                    Activator.logWarning("unable to get IMember corresponding to the given item " + item, e);
                }
            }
        } else {
            if (LuaASTUtils.isLocal(item)) {
                return new FakeField(sourceModule, item.getName(), item.sourceStart(), item.getName().length() + 1, 16);
            }
            if (LuaASTUtils.isGlobal(item)) {
                try {
                    IModelElement[] iModelElementArray = sourceModule.getChildren();
                    int n = iModelElementArray.length;
                    int n3 = 0;
                    while (n3 < n) {
                        IModelElement child = iModelElementArray[n3];
                        if (child.getElementName().equals(item.getName()) && child instanceof IMember) {
                            return (IMember)child;
                        }
                        ++n3;
                    }
                }
                catch (ModelException e) {
                    Activator.logWarning("unable to get IMember corresponding to the given item " + item, e);
                }
            }
        }
        return null;
    }

    public static IModelElement getIModelElement(ISourceModule sourcemodule, LuaASTNode astNode) {
        if (astNode instanceof RecordTypeDef) {
            return LuaASTModelUtils.getIType(sourcemodule, (RecordTypeDef)astNode);
        }
        if (astNode instanceof Item) {
            return LuaASTModelUtils.getIMember(sourcemodule, (Item)astNode);
        }
        return null;
    }
}

