/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.workbench.renderers.swt;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.contexts.RunAndTrack;
import org.eclipse.e4.ui.internal.workbench.ContributionsAnalyzer;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.SideValue;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimBar;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBar;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBarContribution;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBarElement;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBarSeparator;
import org.eclipse.e4.ui.model.application.ui.menu.MToolControl;
import org.eclipse.e4.ui.workbench.modeling.ExpressionContext;
import org.eclipse.e4.ui.workbench.renderers.swt.SWTPartRenderer;
import org.eclipse.jface.layout.RowLayoutFactory;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ToolBarRenderer
extends SWTPartRenderer {
    private MApplication application;
    HashMap<MToolBar, ArrayList<ArrayList<MToolBarElement>>> pendingCleanup = new HashMap();

    @Override
    public void init(IEclipseContext context) {
        super.init(context);
        this.application = (MApplication)context.get(MApplication.class);
    }

    public Object createWidget(final MUIElement element, Object parent) {
        if (!(element instanceof MToolBar) || !(parent instanceof Composite)) {
            return null;
        }
        Composite intermediate = new Composite((Composite)parent, 0);
        this.createToolbar(element, intermediate);
        intermediate.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ToolBarRenderer.this.cleanUp((MToolBar)element);
            }
        });
        return intermediate;
    }

    ToolBar createToolbar(MUIElement element, Composite intermediate) {
        int orientation = this.getOrientation(element);
        RowLayout layout = RowLayoutFactory.fillDefaults().wrap(false).spacing(0).type(orientation).create();
        layout.marginLeft = 3;
        layout.center = true;
        intermediate.setLayout((Layout)layout);
        ToolBar separatorToolBar = new ToolBar(intermediate, orientation | 0x40 | 0x800000 | 0x20000);
        new ToolItem(separatorToolBar, 2);
        return new ToolBar(intermediate, orientation | 0x40 | 0x800000 | 0x20000);
    }

    int getOrientation(MUIElement element) {
        MTrimBar trimContainer;
        SideValue side;
        MElementContainer theParent = element.getParent();
        if (theParent instanceof MTrimBar && ((side = (trimContainer = (MTrimBar)theParent).getSide()).getValue() == 2 || side.getValue() == 3)) {
            return 512;
        }
        return 256;
    }

    public Object getUIContainer(MUIElement childElement) {
        Composite intermediate = (Composite)super.getUIContainer(childElement);
        if (intermediate == null || intermediate.isDisposed()) {
            return null;
        }
        ToolBar toolbar = this.findToolbar(intermediate);
        if (toolbar == null) {
            toolbar = this.createToolbar((MUIElement)childElement.getParent(), intermediate);
        }
        return toolbar;
    }

    ToolBar findToolbar(Composite intermediate) {
        Control[] children;
        int length;
        if (!intermediate.isDisposed() && (length = (children = intermediate.getChildren()).length) > 0 && children[length - 1] instanceof ToolBar) {
            return (ToolBar)children[length - 1];
        }
        return null;
    }

    public void hideChild(MElementContainer<MUIElement> parentElement, MUIElement child) {
        ToolBar toolbar;
        super.hideChild(parentElement, child);
        Widget widget = (Widget)child.getWidget();
        if (widget != null && !widget.isDisposed()) {
            widget.dispose();
        }
        if ((toolbar = (ToolBar)this.getUIContainer(child)) != null && !toolbar.isDisposed()) {
            toolbar.getShell().layout(new Control[]{toolbar}, 4);
        }
        this.disposeToolbarIfNecessary((MUIElement)parentElement);
    }

    private void disposeToolbarIfNecessary(MUIElement element) {
        Composite composite = (Composite)element.getWidget();
        ToolBar toolbar = this.findToolbar(composite);
        if (toolbar != null && this.hasOnlySeparators(toolbar)) {
            toolbar.dispose();
            if (composite.getChildren().length > 0) {
                composite.getChildren()[0].dispose();
            }
        }
    }

    boolean hasOnlySeparators(ToolBar toolbar) {
        ToolItem[] children;
        ToolItem[] toolItemArray = children = toolbar.getItems();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            ToolItem toolItem = toolItemArray[n2];
            if ((toolItem.getStyle() & 2) == 0) {
                return false;
            }
            if (toolItem.getControl() != null && toolItem.getControl().getData("modelElement") instanceof MToolControl) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    @Override
    public void childRendered(MElementContainer<MUIElement> parentElement, MUIElement element) {
        super.childRendered(parentElement, element);
        ToolBar toolbar = (ToolBar)this.getUIContainer(element);
        if (toolbar != null && !toolbar.isDisposed()) {
            toolbar.getShell().layout(new Control[]{toolbar}, 4);
        }
    }

    @Override
    public void processContents(MElementContainer<MUIElement> container) {
        super.processContents(container);
        IEclipseContext ctx = this.getContext((MUIElement)container);
        ExpressionContext eContext = new ExpressionContext(ctx);
        ArrayList<MToolBarContribution> toContribute = new ArrayList<MToolBarContribution>();
        MElementContainer<MUIElement> toolbarObj = container;
        MToolBar toolbarModel = (MToolBar)toolbarObj;
        ContributionsAnalyzer.gatherToolBarContributions((MToolBar)toolbarModel, (List)this.application.getToolBarContributions(), (String)toolbarModel.getElementId(), toContribute, (ExpressionContext)eContext);
        ToolBarRenderer.addToolBarContributions(toolbarModel, toContribute, ctx, eContext, this.pendingCleanup);
    }

    public void postProcess(MUIElement element) {
        super.postProcess(element);
        this.disposeToolbarIfNecessary(element);
    }

    public static void addToolBarContributions(final MToolBar toolbarModel, ArrayList<MToolBarContribution> toContribute, IEclipseContext ctx, final ExpressionContext eContext, HashMap<MToolBar, ArrayList<ArrayList<MToolBarElement>>> pendingCleanup) {
        HashSet<String> existingSeparatorNames = new HashSet<String>();
        for (MToolBarElement child : toolbarModel.getChildren()) {
            String elementId = child.getElementId();
            if (!(child instanceof MToolBarSeparator) || elementId == null) continue;
            existingSeparatorNames.add(elementId);
        }
        boolean done = toContribute.size() == 0;
        while (!done) {
            ArrayList<MToolBarContribution> curList = new ArrayList<MToolBarContribution>(toContribute);
            int retryCount = toContribute.size();
            toContribute.clear();
            for (final MToolBarContribution contribution : curList) {
                ArrayList<ArrayList<Object>> lists;
                ArrayList toRemove;
                if (!ContributionsAnalyzer.processAddition((MToolBar)toolbarModel, (MToolBarContribution)contribution, toRemove = new ArrayList(), existingSeparatorNames)) {
                    toContribute.add(contribution);
                    continue;
                }
                if (contribution.getVisibleWhen() != null) {
                    ctx.runAndTrack(new RunAndTrack(){

                        public boolean changed(IEclipseContext context) {
                            if (!toolbarModel.isToBeRendered() || !toolbarModel.isVisible() || toolbarModel.getWidget() == null) {
                                return false;
                            }
                            boolean rc = ContributionsAnalyzer.isVisible((MToolBarContribution)contribution, (ExpressionContext)eContext);
                            for (MToolBarElement child : toRemove) {
                                child.setToBeRendered(rc);
                            }
                            return true;
                        }
                    });
                }
                if ((lists = pendingCleanup.get(toolbarModel)) == null) {
                    lists = new ArrayList();
                    pendingCleanup.put(toolbarModel, lists);
                }
                lists.add(toRemove);
            }
            boolean bl = done = toContribute.size() == 0 || toContribute.size() == retryCount;
        }
    }

    protected void cleanUp(MToolBar element) {
        ArrayList<ArrayList<MToolBarElement>> lists = this.pendingCleanup.remove(element);
        if (lists == null) {
            return;
        }
        for (ArrayList<MToolBarElement> list : lists) {
            for (MToolBarElement child : list) {
                element.getChildren().remove(child);
            }
        }
    }
}

