/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.koneki.ldt.debug.core.internal.interpreter.generic;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.dltk.launching.InterpreterConfig;
import org.eclipse.dltk.launching.debug.DbgpConnectionConfig;
import org.eclipse.koneki.ldt.debug.core.internal.Activator;
import org.eclipse.koneki.ldt.debug.core.internal.interpreter.generic.LuaGenericInterpreterConfigurer;

public class LuaGenericDebuggingEngineConfigurer
extends LuaGenericInterpreterConfigurer {
    private InterpreterConfig initialConfig;

    @Override
    public InterpreterConfig alterConfig(ILaunch launch, InterpreterConfig config) throws CoreException {
        this.initialConfig = config;
        InterpreterConfig interpreterConfig = (InterpreterConfig)config.clone();
        return super.alterConfig(launch, interpreterConfig);
    }

    @Override
    protected List<IPath> getLuaPath(ILaunch launch, InterpreterConfig config) throws CoreException {
        List<IPath> luaPath = super.getLuaPath(launch, config);
        try {
            URL debuggerEntry = Activator.getDefault().getBundle().getEntry("script/external");
            File debuggerFolder = new File(FileLocator.toFileURL((URL)debuggerEntry).getFile());
            luaPath.add((IPath)new Path(debuggerFolder.getPath()));
        }
        catch (IOException iOException) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.koneki.ldt.debug.core", "Unable to extract debugger files."));
        }
        return luaPath;
    }

    @Override
    protected void addCommands(List<String> commandList, ILaunch launch, InterpreterConfig config) throws CoreException {
        super.addCommands(commandList, launch, config);
        commandList.add(this.createRunDebuggerCommand(launch, config));
    }

    protected String createRunDebuggerCommand(ILaunch launch, InterpreterConfig config) {
        DbgpConnectionConfig dbgpConnectionConfig = DbgpConnectionConfig.load((InterpreterConfig)this.initialConfig);
        String host = dbgpConnectionConfig.getHost();
        int port = dbgpConnectionConfig.getPort();
        String sessionId = dbgpConnectionConfig.getSessionId();
        IPath workingDirectory = config.getWorkingDirectoryPath();
        String oS = Platform.getOS();
        String transportLayer = this.getTransportLayer();
        StringBuilder command = new StringBuilder();
        command.append("require ('debugger')");
        command.append("(");
        command.append("'").append(host).append("'");
        command.append(",");
        command.append(port);
        command.append(",");
        command.append("'").append(sessionId).append("'");
        command.append(",");
        if (transportLayer == null) {
            command.append("nil");
        } else {
            command.append("'").append(transportLayer).append("'");
        }
        command.append(",");
        if (oS.equals("win32")) {
            command.append("'win'");
        } else {
            command.append("'unix'");
        }
        command.append(",");
        if (workingDirectory.isEmpty()) {
            command.append("nil");
        } else {
            command.append("'").append(workingDirectory.toOSString()).append("'");
        }
        command.append(");");
        return command.toString();
    }

    protected String getTransportLayer() {
        return null;
    }
}

