/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.koneki.ldt.remote.debug.core.internal.launch;

import com.jcraft.jsch.Session;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.LaunchConfigurationDelegate;
import org.eclipse.dltk.compiler.env.IModuleSource;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.dbgp.DbgpSessionIdGenerator;
import org.eclipse.dltk.debug.core.DLTKDebugPlugin;
import org.eclipse.dltk.launching.InterpreterConfig;
import org.eclipse.koneki.ldt.core.LuaUtils;
import org.eclipse.koneki.ldt.remote.core.internal.NetworkUtil;
import org.eclipse.koneki.ldt.remote.core.internal.RSEUtil;
import org.eclipse.koneki.ldt.remote.core.internal.lua.LuaRSEUtil;
import org.eclipse.koneki.ldt.remote.core.internal.lua.LuaSubSystem;
import org.eclipse.koneki.ldt.remote.debug.core.internal.launch.LuaRemoteDebuggingEngineRunner;
import org.eclipse.koneki.ldt.remote.debug.core.internal.launch.LuaRemoteLaunchConfigurationUtil;
import org.eclipse.koneki.ldt.remote.debug.core.internal.launch.Messages;
import org.eclipse.koneki.ldt.remote.debug.core.internal.sshprocess.SshProcess;
import org.eclipse.osgi.util.NLS;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.subsystems.IConnectorService;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFileSubSystem;
import org.osgi.framework.Bundle;

public class LuaRemoteLaunchConfigurationDelegate
extends LaunchConfigurationDelegate {
    private static final String[] DEBUG_FILES = new String[]{"script/external/debugger.lua"};
    private static final String DEBGUGGER_MODULE = "debugger";

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        SubMonitor submonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)13);
        try {
            String ldLibraryPath;
            Session session;
            IPath scriptSourcePathRelativePath;
            String remoteApplicationFolderPath;
            LuaSubSystem luaSubSystem;
            IRemoteFileSubSystem remoteFileSubSystem;
            Map env;
            IHost host;
            block44: {
                String outputDirectory;
                IScriptProject scriptProject;
                block43: {
                    IProject project;
                    block42: {
                        RSEUtil.waitForRSEInitialization();
                        String projectName = configuration.getAttribute("project", "");
                        String scriptName = configuration.getAttribute("mainScript", "");
                        host = LuaRemoteLaunchConfigurationUtil.getHost(configuration);
                        env = configuration.getAttribute(ILaunchManager.ATTR_ENVIRONMENT_VARIABLES, Collections.EMPTY_MAP);
                        String errorMessage = LuaRemoteLaunchConfigurationUtil.validateRemoteLaunchConfiguration(projectName, scriptName, host);
                        if (errorMessage != null) {
                            throw new CoreException((IStatus)new Status(4, "org.eclipse.koneki.ldt.remote.debug.core", errorMessage));
                        }
                        submonitor.worked(1);
                        project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
                        remoteFileSubSystem = RSEUtil.getRemoteFileSubsystem((IHost)host);
                        luaSubSystem = LuaRSEUtil.getLuaSubSystem((IHost)host);
                        try {
                            if (!submonitor.isCanceled()) break block42;
                            return;
                        }
                        catch (Exception e) {
                            throw new CoreException((IStatus)new Status(4, "org.eclipse.koneki.ldt.remote.debug.core", Messages.LuaRemoteLaunchConfigurationDelegate_error_connectionfailed, (Throwable)e));
                        }
                    }
                    remoteFileSubSystem.connect((IProgressMonitor)submonitor.newChild(1), false);
                    scriptProject = DLTKCore.create((IProject)project);
                    if (submonitor.isCanceled()) {
                        return;
                    }
                    outputDirectory = luaSubSystem.getOutputDirectory();
                    String defaultRemoteApplicationFolderPath = String.valueOf(outputDirectory) + remoteFileSubSystem.getSeparator() + configuration.getName();
                    remoteApplicationFolderPath = configuration.getAttribute("workingDir", defaultRemoteApplicationFolderPath);
                    String scriptProjectRelativePath = configuration.getAttribute("mainScript", "main.lua");
                    IFile scriptFile = project.getFile(scriptProjectRelativePath);
                    IModuleSource moduleSource = LuaUtils.getModuleSourceFromAbsoluteURI((URI)scriptFile.getLocationURI(), (IScriptProject)scriptProject);
                    if (moduleSource == null) {
                        throw new CoreException((IStatus)new Status(4, "org.eclipse.koneki.ldt.remote.debug.core", NLS.bind((String)Messages.LuaRemoteLaunchConfigurationDelegate_error_unabletofindsourcerelativepath, (Object)scriptProjectRelativePath)));
                    }
                    scriptSourcePathRelativePath = LuaUtils.getSourcePathRelativePath((IModuleSource)moduleSource);
                    session = RSEUtil.getCurrentSshSession((IConnectorService[])host.getConnectorServices());
                    SshProcess.killProcess(session, remoteApplicationFolderPath);
                    if (!submonitor.isCanceled()) break block43;
                    return;
                }
                IRemoteFile remoteApplicationPath = remoteFileSubSystem.getRemoteFileObject(outputDirectory, (IProgressMonitor)submonitor.newChild(1));
                if (remoteApplicationPath.exists()) {
                    if (remoteApplicationPath.isFile()) {
                        throw new CoreException((IStatus)new Status(4, "org.eclipse.koneki.ldt.remote.debug.core", NLS.bind((String)Messages.LuaRemoteLaunchConfigurationDelegate_error_filealreadyexist, (Object)outputDirectory)));
                    }
                } else {
                    remoteFileSubSystem.createFolder(remoteApplicationPath, (IProgressMonitor)submonitor.newChild(1));
                }
                submonitor.setWorkRemaining(9);
                if (submonitor.isCanceled()) {
                    return;
                }
                IRemoteFile remoteWorkingFolder = remoteFileSubSystem.getRemoteFileObject(remoteApplicationFolderPath, (IProgressMonitor)submonitor.newChild(1));
                if (remoteWorkingFolder.exists()) {
                    if (remoteWorkingFolder.isFile()) {
                        throw new CoreException((IStatus)new Status(4, "org.eclipse.koneki.ldt.remote.debug.core", MessageFormat.format(Messages.LuaRemoteLaunchConfigurationDelegate_error_filealreadyexist, remoteApplicationFolderPath)));
                    }
                    remoteFileSubSystem.delete(remoteWorkingFolder, (IProgressMonitor)submonitor.newChild(1));
                }
                submonitor.setWorkRemaining(7);
                if (submonitor.isCanceled()) {
                    return;
                }
                try {
                    remoteFileSubSystem.createFolder(remoteWorkingFolder, (IProgressMonitor)submonitor.newChild(1));
                    LuaRSEUtil.uploadFiles((IRemoteFileSubSystem)remoteFileSubSystem, (IScriptProject)scriptProject, (String)remoteApplicationFolderPath, (IProgressMonitor)submonitor.newChild(2));
                    if (!mode.equals("debug")) break block44;
                    SubMonitor debugmonitor = submonitor.newChild(1);
                    debugmonitor.setWorkRemaining(DEBUG_FILES.length);
                    String localEncoding = Charset.defaultCharset().name();
                    String remoteEncoding = remoteFileSubSystem.getRemoteEncoding();
                    String[] stringArray = DEBUG_FILES;
                    int n = DEBUG_FILES.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String luaFile = stringArray[n2];
                        try {
                            Bundle bundle = Platform.getBundle((String)"org.eclipse.koneki.ldt.debug.core");
                            URL resource = bundle.getResource(luaFile);
                            File result = new File(FileLocator.toFileURL((URL)resource).getPath());
                            String remotePath = String.valueOf(remoteApplicationFolderPath) + remoteFileSubSystem.getSeparator() + result.getName();
                            remoteFileSubSystem.upload(result.getAbsolutePath(), localEncoding, remotePath, remoteEncoding, (IProgressMonitor)submonitor.newChild(1));
                        }
                        catch (IOException e) {
                            throw new CoreException((IStatus)new Status(4, "org.eclipse.koneki.ldt.remote.debug.core", Messages.LuaRemoteLaunchConfigurationDelegate_error_unabletouploaddebuggerfiles, (Throwable)e));
                        }
                        ++n2;
                    }
                }
                catch (SystemMessageException e) {
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.koneki.ldt.remote.debug.core", NLS.bind((String)Messages.LuaRemoteLaunchConfigurationDelegate_error_unabletoaccestoremoteapplicationdir, (Object)outputDirectory), (Throwable)e));
                }
            }
            HashMap<String, String> envVars = new HashMap<String, String>();
            String luaPath = luaSubSystem.getLuaPath();
            if (luaPath == null || luaPath.isEmpty()) {
                luaPath = "$LUA_PATH";
            }
            StringBuilder luaPathBuilder = new StringBuilder(luaPath);
            luaPathBuilder.append(remoteApplicationFolderPath);
            luaPathBuilder.append(remoteFileSubSystem.getSeparator());
            luaPathBuilder.append("?.lua;");
            luaPathBuilder.append(remoteApplicationFolderPath);
            luaPathBuilder.append(remoteFileSubSystem.getSeparator());
            luaPathBuilder.append("?");
            luaPathBuilder.append(remoteFileSubSystem.getSeparator());
            luaPathBuilder.append("init.lua;");
            envVars.put("LUA_PATH", luaPathBuilder.toString());
            String luaCPath = luaSubSystem.getCLuaPath();
            if (luaCPath != null && !luaCPath.isEmpty()) {
                envVars.put("LUA_CPATH", luaCPath);
            }
            if ((ldLibraryPath = luaSubSystem.getLDLibraryPath()) != null && !ldLibraryPath.isEmpty()) {
                envVars.put("LD_LIBRARY_PATH", ldLibraryPath);
            }
            Iterator iterator = env.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry oEntry;
                Map.Entry entry = oEntry = iterator.next();
                envVars.put(entry.getKey().toString(), entry.getValue().toString());
            }
            String sessionID = null;
            if (mode.equals("debug")) {
                sessionID = DbgpSessionIdGenerator.generate();
                if (!envVars.containsKey("DBGP_IDEHOST")) {
                    String bindedAddress = NetworkUtil.findBindedAddress((String)host.getHostName(), (IProgressMonitor)submonitor.newChild(1));
                    if (bindedAddress == null) {
                        throw new CoreException((IStatus)new Status(4, "org.eclipse.koneki.ldt.remote.debug.core", NLS.bind((String)Messages.LuaRemoteLaunchConfigurationDelegate_error_unable_to_define_ideip, (Object)"DBGP_IDEHOST")));
                    }
                    envVars.put("DBGP_IDEHOST", bindedAddress);
                }
                envVars.put("DBGP_IDEKEY", sessionID);
                envVars.put("DBGP_IDEPORT", String.valueOf(DLTKDebugPlugin.getDefault().getDbgpService().getPort()));
                envVars.put("DBGP_PLATFORM", "unix");
                envVars.put("DBGP_WORKINGDIR", remoteApplicationFolderPath);
                envVars.put("DBGP_TRANSPORT", "debugger.transport.luasocket_sched");
            }
            StringBuilder cmd = new StringBuilder();
            cmd.append(luaSubSystem.getLuaCommand());
            cmd.append(' ');
            String interpreterArgs = configuration.getAttribute("interpreterArguments", "");
            if (!interpreterArgs.isEmpty()) {
                cmd.append(interpreterArgs);
                cmd.append(' ');
            }
            String bootstrapCode = "io.stdout:setvbuf('line');";
            if (mode.equals("debug")) {
                bootstrapCode = String.valueOf(bootstrapCode) + " require('debugger')();";
            }
            cmd.append("-e");
            cmd.append(' ');
            cmd.append("\"" + bootstrapCode + "\"");
            cmd.append(' ');
            cmd.append(SshProcess.escapeShell(scriptSourcePathRelativePath.toPortableString()));
            cmd.append(' ');
            String scriptArgs = configuration.getAttribute("scriptArguments", "");
            if (!scriptArgs.isEmpty()) {
                cmd.append(scriptArgs);
                cmd.append(' ');
            }
            submonitor.setWorkRemaining(1);
            if (submonitor.isCanceled()) {
                return;
            }
            SshProcess process = new SshProcess(session, launch, remoteApplicationFolderPath, cmd.toString(), envVars);
            if (mode.equals("debug")) {
                launch.setAttribute("org.eclipse.dltk.debug.debugConsole", "false");
                if (configuration.getAttribute("enableBreakOnFirstLine", false)) {
                    launch.setAttribute("org.eclipse.dltk.debug.breakOnFirstLine", "true");
                }
                LuaRemoteDebuggingEngineRunner debugingEngine = new LuaRemoteDebuggingEngineRunner(process, sessionID, remoteApplicationFolderPath);
                debugingEngine.run(new InterpreterConfig(), launch, (IProgressMonitor)submonitor.newChild(1));
                launch.addProcess((IProcess)process);
            } else {
                process.start();
                launch.addProcess((IProcess)process);
            }
        }
        finally {
            submonitor.done();
        }
    }
}

