/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.koneki.ldt.remote.debug.core.internal.launch;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.koneki.ldt.remote.core.internal.RSEUtil;
import org.eclipse.koneki.ldt.remote.core.internal.lua.LuaRSEUtil;
import org.eclipse.koneki.ldt.remote.core.internal.lua.LuaSubSystem;
import org.eclipse.koneki.ldt.remote.debug.core.internal.launch.Messages;
import org.eclipse.osgi.util.NLS;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.model.ISystemProfile;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFileSubSystem;

public final class LuaRemoteLaunchConfigurationUtil {
    private LuaRemoteLaunchConfigurationUtil() {
    }

    public static final void setConnectionId(ILaunchConfigurationWorkingCopy conf, IHost host) {
        ArrayList<String> hostData = new ArrayList<String>();
        hostData.add(host.getSystemProfileName());
        hostData.add(host.getName());
        conf.setAttribute("org.eclipse.koneki.ldt.remote.debug.core.debug.hostid", hostData);
    }

    public static final IHost getHost(ILaunchConfiguration conf) {
        ISystemProfile systemProfile;
        String hostID;
        block9: {
            Object oHost;
            String profileName;
            block8: {
                Object oProfileName;
                List hostData;
                block7: {
                    block6: {
                        try {
                            hostData = conf.getAttribute("org.eclipse.koneki.ldt.remote.debug.core.debug.hostid", Collections.EMPTY_LIST);
                            if (hostData.size() == 2) break block6;
                            return null;
                        }
                        catch (CoreException coreException) {
                            return null;
                        }
                    }
                    oProfileName = hostData.get(0);
                    if (oProfileName instanceof String) break block7;
                    return null;
                }
                profileName = (String)oProfileName;
                oHost = hostData.get(1);
                if (oHost instanceof String) break block8;
                return null;
            }
            hostID = (String)oHost;
            systemProfile = RSECorePlugin.getTheSystemRegistry().getSystemProfile(profileName);
            if (systemProfile != null) break block9;
            return null;
        }
        IHost host = RSECorePlugin.getTheSystemRegistry().getHost(systemProfile, hostID);
        return host;
    }

    public static String validateRemoteLaunchConfiguration(String projectName, String scriptName, IHost host) {
        if (projectName == null || projectName.isEmpty()) {
            return Messages.LuaRemoteLaunchConfigurationUtil_error_no_project;
        }
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        if (project == null || !project.exists()) {
            return NLS.bind((String)Messages.LuaRemoteLaunchConfigurationUtil_error_unexisted_project, (Object)projectName);
        }
        if (!project.isOpen()) {
            return NLS.bind((String)Messages.LuaRemoteLaunchConfigurationUtil_error_closed_project, (Object)projectName);
        }
        try {
            if (!project.hasNature("org.eclipse.koneki.ldt.nature")) {
                return NLS.bind((String)Messages.LuaRemoteLaunchConfigurationUtil_error_not_lua_project, (Object)projectName);
            }
        }
        catch (CoreException e) {
            return "Unexpected problem :" + e.getMessage();
        }
        if (scriptName == null || scriptName.isEmpty()) {
            return Messages.LuaRemoteLaunchConfigurationUtil_error_no_script_selected;
        }
        IResource script = project.findMember(scriptName);
        if (script == null || !script.exists()) {
            return NLS.bind((String)Messages.LuaRemoteLaunchConfigurationUtil_error_script_desnt_exist, (Object)scriptName);
        }
        if (script.getType() != 1 || !script.getFileExtension().equals("lua")) {
            return NLS.bind((String)Messages.LuaRemoteLaunchConfigurationUtil_error_script_not_lua_file, (Object)scriptName);
        }
        if (host == null) {
            return Messages.LuaRemoteLaunchConfigurationUtil_error_no_host_selected;
        }
        String hostName = host.getName();
        LuaSubSystem luaSubSystem = LuaRSEUtil.getLuaSubSystem((IHost)host);
        if (luaSubSystem == null) {
            return NLS.bind((String)Messages.LuaRemoteLaunchConfigurationUtil_error_no_lua_service, (Object)hostName);
        }
        String luaCommand = luaSubSystem.getLuaCommand();
        if (luaCommand == null || luaCommand.isEmpty()) {
            return NLS.bind((String)Messages.LuaRemoteLaunchConfigurationUtil_error_no_luacommand, (Object)hostName);
        }
        String outputDirectory = luaSubSystem.getOutputDirectory();
        if (outputDirectory == null || outputDirectory.isEmpty()) {
            return NLS.bind((String)Messages.LuaRemoteLaunchConfigurationUtil_error_no_outputdir, (Object)hostName);
        }
        IRemoteFileSubSystem remoteFileSubsystem = RSEUtil.getRemoteFileSubsystem((IHost)host);
        if (remoteFileSubsystem == null) {
            return NLS.bind((String)Messages.LuaRemoteLaunchConfigurationUtil_error_no_remote_file_service, (Object)hostName);
        }
        return null;
    }

    public static String getRemoteApplicationPath(ILaunchConfiguration configuration) {
        IHost host = LuaRemoteLaunchConfigurationUtil.getHost(configuration);
        if (host == null) {
            return "";
        }
        IRemoteFileSubSystem remoteFileSubSystem = RSEUtil.getRemoteFileSubsystem((IHost)host);
        if (remoteFileSubSystem == null) {
            return "";
        }
        LuaSubSystem luaSubSystem = LuaRSEUtil.getLuaSubSystem((IHost)host);
        return String.valueOf(luaSubSystem.getOutputDirectory()) + remoteFileSubSystem.getSeparator() + configuration.getName();
    }
}

