/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.koneki.ldt.remote.debug.ui.internal.launch.tab;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.dltk.debug.ui.messages.DLTKLaunchConfigurationsMessages;
import org.eclipse.dltk.debug.ui.preferences.ScriptDebugPreferencesMessages;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.koneki.ldt.remote.core.internal.RSEUtil;
import org.eclipse.koneki.ldt.remote.debug.core.internal.launch.LuaRemoteLaunchConfigurationUtil;
import org.eclipse.koneki.ldt.remote.debug.ui.internal.Activator;
import org.eclipse.koneki.ldt.remote.debug.ui.internal.launch.tab.Messages;
import org.eclipse.koneki.ldt.ui.LuaDialogUtil;
import org.eclipse.koneki.ldt.ui.SWTUtil;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.ui.widgets.SystemHostCombo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class LuaRemoteLaunchConfigurationMainTab
extends AbstractLaunchConfigurationTab {
    private SystemHostCombo hostCombo;
    private TextModifyListener textModifyListener = new TextModifyListener();
    private SelectionListener selectionChangeListener = new SelectionChangeListener();
    private Text projectNameText;
    private Button projectSelectionButton;
    private Text scriptNameText;
    private Button scriptSelectionButton;
    private Button breakOnFirstLineButton;
    private Button enableLoggingButton;
    private String mode;

    public LuaRemoteLaunchConfigurationMainTab(String mode) {
        this.mode = mode;
    }

    public void createControl(Composite parent) {
        Composite comp = new Composite(parent, 0);
        this.setControl((Control)comp);
        GridLayoutFactory.swtDefaults().spacing(-1, 1).applyTo(comp);
        comp.setFont(parent.getFont());
        RSEUtil.waitForRSEInitialization();
        this.createProjectConfigComponent(comp);
        this.createScriptConfigComponent(comp);
        this.createTargetConfigComponent(comp);
        if ("debug".equals(this.mode)) {
            this.createDebugConfigComponent(comp);
        }
    }

    private void createProjectConfigComponent(Composite comp) {
        Group group = new Group(comp, 0);
        group.setText(DLTKLaunchConfigurationsMessages.mainTab_projectGroup);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)group);
        GridLayoutFactory.swtDefaults().numColumns(2).applyTo((Composite)group);
        this.projectNameText = new Text((Composite)group, 2052);
        GridDataFactory.swtDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)this.projectNameText);
        this.projectSelectionButton = new Button((Composite)group, 8);
        this.projectSelectionButton.setText(Messages.LuaRemoteMainTab_projectgroup_browseprojectbutton);
        int browseButtonHorizontalHint = SWTUtil.getButtonWidthHint((Button)this.projectSelectionButton);
        GridDataFactory.fillDefaults().align(0x1000008, 1).hint(browseButtonHorizontalHint, -1).applyTo((Control)this.projectSelectionButton);
    }

    private void createScriptConfigComponent(Composite comp) {
        Group group = new Group(comp, 0);
        group.setText(DLTKLaunchConfigurationsMessages.mainTab_mainModule);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)group);
        GridLayoutFactory.swtDefaults().numColumns(2).applyTo((Composite)group);
        this.scriptNameText = new Text((Composite)group, 2052);
        GridDataFactory.swtDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)this.scriptNameText);
        this.scriptSelectionButton = new Button((Composite)group, 8);
        this.scriptSelectionButton.setText(Messages.LuaRemoteMainTab_projectgroup_browseprojectbutton);
        int browseButtonHorizontalHint = SWTUtil.getButtonWidthHint((Button)this.projectSelectionButton);
        GridDataFactory.fillDefaults().align(0x1000008, 1).hint(browseButtonHorizontalHint, -1).applyTo((Control)this.scriptSelectionButton);
    }

    private void createTargetConfigComponent(Composite comp) {
        Group group = new Group(comp, 0);
        group.setText(Messages.LuaRemoteMainTab_targetgroup_title);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)group);
        GridLayoutFactory.swtDefaults().numColumns(2).applyTo((Composite)group);
        Label hostLabel = new Label((Composite)group, 0);
        hostLabel.setText(Messages.LuaRemoteMainTab_targetgroup_hostlabel);
        IHost selectfirstHost = null;
        this.hostCombo = new SystemHostCombo((Composite)group, 0, selectfirstHost, true, "files", false);
        int newSystemHint = SWTUtil.getButtonWidthHint((Button)this.hostCombo.getNewButton());
        this.hostCombo.setButtonWidthHint(newSystemHint);
        GridDataFactory.swtDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)this.hostCombo);
    }

    private void createDebugConfigComponent(Composite comp) {
        Group group = new Group(comp, 0);
        group.setText(Messages.LuaRemoteLaunchConfigurationMainTab_debuggroup_title);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)group);
        GridLayoutFactory.swtDefaults().numColumns(2).applyTo((Composite)group);
        this.breakOnFirstLineButton = this.createCheckButton((Composite)group, ScriptDebugPreferencesMessages.BreakOnFirstLineLabel);
        this.createVerticalSpacer((Composite)group, 1);
        this.enableLoggingButton = this.createCheckButton((Composite)group, ScriptDebugPreferencesMessages.EnableDbgpLoggingLabel);
        this.createVerticalSpacer((Composite)group, 1);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        IPath standardPath;
        IFile standardFile;
        IProject defaultProject = null;
        try {
            IProject[] avilableProjects;
            IProject[] iProjectArray = avilableProjects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
            int n = avilableProjects.length;
            int n2 = 0;
            while (n2 < n) {
                IProject project = iProjectArray[n2];
                if (project.hasNature("org.eclipse.koneki.ldt.nature") && defaultProject == null) {
                    defaultProject = project;
                }
                ++n2;
            }
        }
        catch (CoreException coreException) {}
        configuration.setAttribute("project", defaultProject == null ? "" : defaultProject.getName());
        String defaultScript = "";
        if (defaultProject != null && (standardFile = defaultProject.getFile(standardPath = new Path("src").append("main.lua"))).exists()) {
            defaultScript = standardFile.getProjectRelativePath().toPortableString();
        }
        configuration.setAttribute("mainScript", defaultScript);
        IHost[] hosts = RSECorePlugin.getTheSystemRegistry().getHosts();
        if (hosts.length > 0) {
            LuaRemoteLaunchConfigurationUtil.setConnectionId((ILaunchConfigurationWorkingCopy)configuration, (IHost)hosts[0]);
        }
        configuration.setAttribute("enableDbgpLogging", false);
        configuration.setAttribute("enableBreakOnFirstLine", false);
    }

    private void addListeners() {
        if (!this.projectNameText.isListening(24)) {
            this.projectNameText.addModifyListener((ModifyListener)this.textModifyListener);
        }
        if (!this.scriptNameText.isListening(24)) {
            this.scriptNameText.addModifyListener((ModifyListener)this.textModifyListener);
        }
        if (!this.projectSelectionButton.isListening(13)) {
            this.projectSelectionButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    LuaRemoteLaunchConfigurationMainTab.this.selectLuaEmbeddedProject();
                }
            });
        }
        if (!this.scriptSelectionButton.isListening(13)) {
            this.scriptSelectionButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    LuaRemoteLaunchConfigurationMainTab.this.selectScript();
                }
            });
        }
        if (!this.hostCombo.isListening(13)) {
            this.hostCombo.addSelectionListener(this.selectionChangeListener);
        }
        if (this.breakOnFirstLineButton != null && !this.breakOnFirstLineButton.isListening(13)) {
            this.breakOnFirstLineButton.addSelectionListener(this.selectionChangeListener);
        }
        if (this.enableLoggingButton != null && !this.enableLoggingButton.isListening(13)) {
            this.enableLoggingButton.addSelectionListener(this.selectionChangeListener);
        }
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            String scriptName;
            String projectName = configuration.getAttribute("project", "");
            if (!projectName.equals(this.projectNameText.getText())) {
                this.projectNameText.setText(projectName);
            }
            if (!(scriptName = configuration.getAttribute("mainScript", "")).equals(this.scriptNameText.getText())) {
                this.scriptNameText.setText(scriptName);
            }
            IHost host = LuaRemoteLaunchConfigurationUtil.getHost((ILaunchConfiguration)configuration);
            if (this.hostCombo.getHost() != host) {
                this.hostCombo.select(host);
            }
            if (this.breakOnFirstLineButton != null) {
                boolean breakOnFirstLine = configuration.getAttribute("enableBreakOnFirstLine", false);
                this.breakOnFirstLineButton.setSelection(breakOnFirstLine);
            }
            if (this.enableLoggingButton != null) {
                boolean enableDBGPLogging = configuration.getAttribute("enableDbgpLogging", false);
                this.enableLoggingButton.setSelection(enableDBGPLogging);
            }
            this.addListeners();
        }
        catch (CoreException e) {
            Activator.logError("Launch Configuration main tab for lua embedded failed at initialization", e);
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("project", this.projectNameText.getText());
        configuration.setAttribute("mainScript", this.scriptNameText.getText());
        IHost host = this.hostCombo.getHost();
        if (host != null) {
            LuaRemoteLaunchConfigurationUtil.setConnectionId((ILaunchConfigurationWorkingCopy)configuration, (IHost)this.hostCombo.getHost());
        } else {
            configuration.removeAttribute("org.eclipse.koneki.ldt.remote.debug.core.debug.hostid");
        }
        if (this.breakOnFirstLineButton != null) {
            configuration.setAttribute("enableBreakOnFirstLine", this.breakOnFirstLineButton.getSelection());
        }
        if (this.enableLoggingButton != null) {
            configuration.setAttribute("enableDbgpLogging", this.enableLoggingButton.getSelection());
        }
    }

    public String getName() {
        return Messages.LuaRemoteMainTab_tabname;
    }

    public Image getImage() {
        return org.eclipse.koneki.ldt.ui.internal.Activator.getDefault().getImageRegistry().get("icons/obj16/module.gif");
    }

    public boolean isValid(ILaunchConfiguration configuration) {
        String projectName = this.projectNameText.getText();
        String scriptName = this.scriptNameText.getText();
        IHost host = this.hostCombo.getHost();
        return this.innerIsValuesValid(projectName, scriptName, host);
    }

    private boolean innerIsValuesValid(String projectName, String scriptName, IHost host) {
        String error = LuaRemoteLaunchConfigurationUtil.validateRemoteLaunchConfiguration((String)projectName, (String)scriptName, (IHost)host);
        this.setErrorMessage(error);
        return error == null;
    }

    private void selectLuaEmbeddedProject() {
        String currentProjectName = this.projectNameText.getText();
        IProject selectedProject = LuaDialogUtil.openSelectLuaProjectDialog((Shell)this.getShell(), (String)this.projectNameText.getText(), (String)DLTKLaunchConfigurationsMessages.mainTab_chooseProject_title, (String)DLTKLaunchConfigurationsMessages.mainTab_chooseProject_message);
        if (selectedProject != null && !selectedProject.getName().equals(currentProjectName)) {
            this.projectNameText.setText(selectedProject.getName());
        }
    }

    private void selectScript() {
        String currentProjectName = this.projectNameText.getText();
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(currentProjectName);
        IFile selectedScript = LuaDialogUtil.openSelectScriptFromProjectDialog((Shell)this.getShell(), (IProject)project, (String)DLTKLaunchConfigurationsMessages.mainTab_searchButton_title, (String)DLTKLaunchConfigurationsMessages.mainTab_searchButton_message);
        if (selectedScript != null && !selectedScript.getName().equals(this.scriptNameText.getText())) {
            this.scriptNameText.setText(selectedScript.getProjectRelativePath().toPortableString());
        }
    }

    private final class SelectionChangeListener
    extends SelectionAdapter {
        private SelectionChangeListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            LuaRemoteLaunchConfigurationMainTab.this.updateLaunchConfigurationDialog();
        }
    }

    private final class TextModifyListener
    implements ModifyListener {
        private TextModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            LuaRemoteLaunchConfigurationMainTab.this.updateLaunchConfigurationDialog();
        }
    }
}

