/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.ui.actions;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.model.ISystemRegistry;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.internal.ui.SystemResources;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.ui.actions.LazyDownloadJob;
import org.eclipse.rse.ui.actions.SystemBaseAction;
import org.eclipse.rse.ui.internal.model.SystemRegistryUI;
import org.eclipse.rse.ui.validators.IValidatorRemoteSelection;
import org.eclipse.rse.ui.view.ISystemEditableRemoteObject;
import org.eclipse.rse.ui.view.ISystemRemoteElementAdapter;
import org.eclipse.rse.ui.view.ISystemViewElementAdapter;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.PluginTransfer;
import org.eclipse.ui.part.PluginTransferData;
import org.eclipse.ui.part.ResourceTransfer;

public class SystemCopyToClipboardAction
extends SystemBaseAction
implements IValidatorRemoteSelection {
    private IStructuredSelection _selection;
    private boolean _doResourceTransfer = false;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public SystemCopyToClipboardAction(Shell shell, Clipboard clipboard) {
        this(shell);
    }

    private SystemCopyToClipboardAction(Shell shell) {
        super(SystemResources.ACTION_COPY_LABEL, PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_COPY"), shell);
        this.setToolTipText(SystemResources.ACTION_COPY_TOOLTIP);
        this.allowOnMultipleSelection(true);
        this.setContextMenuGroup("group.reorganize");
        this.setHelp("org.eclipse.rse.ui.actn0116");
    }

    public void run() {
        if (this._selection != null) {
            this.copySelectionToClipboard(this._selection);
        }
    }

    private IResource getResource(IAdaptable dragObject) {
        ISystemRemoteElementAdapter remoteAdapter;
        IFile resource = null;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.rse.ui.view.ISystemViewElementAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ISystemViewElementAdapter viewAdapter = (ISystemViewElementAdapter)dragObject.getAdapter((Class)clazz);
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.rse.ui.view.ISystemRemoteElementAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((remoteAdapter = (ISystemRemoteElementAdapter)dragObject.getAdapter((Class)clazz2)) != null) {
            if (remoteAdapter.canEdit(dragObject)) {
                ISystemEditableRemoteObject editable = remoteAdapter.getEditableRemoteObject(dragObject);
                IFile file = editable.getLocalResource();
                if (!file.exists()) {
                    LazyDownloadJob job = new LazyDownloadJob(editable);
                    job.schedule();
                }
                resource = file;
            } else if (viewAdapter != null && viewAdapter.hasChildren(dragObject)) {
                IContainer parentFolder = null;
                Object[] children = viewAdapter.getChildren(dragObject, (IProgressMonitor)new NullProgressMonitor());
                int i = 0;
                while (i < children.length) {
                    IAdaptable child = (IAdaptable)children[i];
                    IResource childResource = this.getResource(child);
                    if (childResource != null && !(parentFolder = childResource.getParent()).exists()) {
                        try {
                            parentFolder.touch((IProgressMonitor)new NullProgressMonitor());
                        }
                        catch (Exception exception) {}
                    }
                    ++i;
                }
                resource = parentFolder;
            }
        }
        return resource;
    }

    private void copySelectionToClipboard(IStructuredSelection ss) {
        String[] ft;
        Iterator iterator = ss.iterator();
        StringBuffer textStream = new StringBuffer("");
        StringBuffer dataStream = new StringBuffer("");
        ArrayList<String> fileNames = new ArrayList<String>();
        ArrayList<IResource> resources = new ArrayList<IResource>();
        ISystemRegistry registry = RSECorePlugin.getTheSystemRegistry();
        while (iterator.hasNext()) {
            IResource resource;
            String subSystemId;
            ISystemViewElementAdapter adapter;
            Object dragObject = iterator.next();
            if (!(dragObject instanceof IAdaptable)) continue;
            IAdaptable iAdaptable = (IAdaptable)dragObject;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = Class.forName("org.eclipse.rse.ui.view.ISystemViewElementAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((adapter = (ISystemViewElementAdapter)iAdaptable.getAdapter((Class)clazz)) == null) continue;
            String text = adapter.getAlternateText(dragObject);
            if (textStream.length() > 0) {
                textStream.append(this.getTextTransferAppend(dragObject, adapter));
            }
            textStream.append(this.getTextTransferPrepend(dragObject, adapter));
            textStream.append(text);
            if (!adapter.canDrag(dragObject)) continue;
            ISubSystem subSystem = null;
            if (dragObject instanceof ISubSystem) {
                subSystem = (ISubSystem)dragObject;
                subSystemId = RSECorePlugin.getTheSystemRegistry().getAbsoluteNameForSubSystem(subSystem);
                dataStream.append(subSystemId);
                continue;
            }
            if (dragObject instanceof IHost) {
                IHost connection = (IHost)dragObject;
                String connectionId = RSECorePlugin.getTheSystemRegistry().getAbsoluteNameForConnection(connection);
                dataStream.append(connectionId);
                continue;
            }
            subSystem = adapter.getSubSystem(dragObject);
            subSystemId = registry.getAbsoluteNameForSubSystem(subSystem);
            dataStream.append(subSystemId);
            dataStream.append(":");
            String objectId = adapter.getAbsoluteName(dragObject);
            dataStream.append(objectId);
            if (iterator.hasNext()) {
                dataStream.append("|");
            }
            if (!this._doResourceTransfer || (resource = this.getResource((IAdaptable)dragObject)) == null) continue;
            resources.add(resource);
            String fileName = resource.getLocation().toOSString();
            fileNames.add(fileName);
        }
        byte[] bytes = null;
        try {
            bytes = dataStream.toString().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            bytes = dataStream.toString().getBytes();
        }
        PluginTransferData data = new PluginTransferData("org.eclipse.rse.ui.view.DropActions", bytes);
        if (this._doResourceTransfer && resources.size() > 0) {
            ft = new IResource[resources.size()];
            int i = 0;
            while (i < ft.length) {
                ft[i] = (IResource)resources.get(i);
                ++i;
            }
            String[] fn = new String[fileNames.size()];
            int j = 0;
            while (j < fn.length) {
                fn[j] = (String)fileNames.get(j);
                ++j;
            }
            Clipboard clipboard = SystemRegistryUI.getInstance().getSystemClipboard();
            clipboard.setContents(new Object[]{data, ft, fn, textStream.toString()}, new Transfer[]{PluginTransfer.getInstance(), ResourceTransfer.getInstance(), FileTransfer.getInstance(), TextTransfer.getInstance()});
            clipboard.dispose();
        } else {
            ft = new String[fileNames.size()];
            int i = 0;
            while (i < ft.length) {
                ft[i] = (String)fileNames.get(i);
                ++i;
            }
            Clipboard clipboard = SystemRegistryUI.getInstance().getSystemClipboard();
            if (ft.length > 0) {
                clipboard.setContents(new Object[]{data, ft, textStream.toString()}, new Transfer[]{PluginTransfer.getInstance(), FileTransfer.getInstance(), TextTransfer.getInstance()});
            } else {
                clipboard.setContents(new Object[]{data, textStream.toString()}, new Transfer[]{PluginTransfer.getInstance(), TextTransfer.getInstance()});
            }
            clipboard.dispose();
        }
    }

    protected String getTextTransferPrepend(Object obj, ISystemViewElementAdapter adapter) {
        return "";
    }

    protected String getTextTransferAppend(Object obj, ISystemViewElementAdapter adapter) {
        return System.getProperty("line.separator");
    }

    public SystemMessage isValid(IHost selectedConnection, Object[] selectedObjects, ISystemRemoteElementAdapter[] remoteAdaptersForSelectedObjects) {
        return null;
    }

    public boolean updateSelection(IStructuredSelection selection) {
        boolean enable = true;
        Iterator e = selection.iterator();
        while (enable && e.hasNext()) {
            Object selectedObject = e.next();
            if (selectedObject instanceof IAdaptable) {
                ISystemViewElementAdapter va;
                IAdaptable adaptable = (IAdaptable)selectedObject;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.rse.ui.view.ISystemViewElementAdapter");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((va = (ISystemViewElementAdapter)adaptable.getAdapter((Class)clazz)) != null) {
                    enable = va.canDrag(selectedObject);
                    continue;
                }
                enable = false;
                continue;
            }
            enable = false;
        }
        if (enable) {
            this._selection = selection;
        }
        return enable;
    }
}

