/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.HandlerEvent;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.NotEnabledException;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.commands.Parameterization;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.core.commands.EHandlerService;
import org.eclipse.e4.core.commands.internal.HandlerServiceImpl;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.handlers.E4HandlerProxy;
import org.eclipse.ui.menus.UIElement;

public class MakeHandlersGo
extends AbstractHandler
implements IElementUpdater {
    private IWorkbench workbench;
    private String commandId;

    public MakeHandlersGo(IWorkbench wb, String commandId) {
        this.workbench = wb;
        this.commandId = commandId;
    }

    public void fireHandlerChanged(HandlerEvent handlerEvent) {
        super.fireHandlerChanged(handlerEvent);
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ParameterizedCommand pcmd;
        WorkbenchPlugin.log("Calling \"" + event.getCommand() + "\" command directly");
        IHandlerService hs = (IHandlerService)this.workbench.getService(IHandlerService.class);
        if (hs != null && (pcmd = this.generateCommand(event)) != null) {
            Event e = null;
            if (event.getTrigger() instanceof Event) {
                e = (Event)event.getTrigger();
            }
            try {
                Object obj = event.getApplicationContext();
                if (obj instanceof IEvaluationContext) {
                    return hs.executeCommandInContext(pcmd, e, (IEvaluationContext)obj);
                }
                return hs.executeCommand(pcmd, e);
            }
            catch (NotDefinedException notDefinedException) {
            }
            catch (NotEnabledException notEnabledException) {
            }
            catch (NotHandledException notHandledException) {}
        }
        return null;
    }

    private ParameterizedCommand generateCommand(ExecutionEvent event) {
        Command cmd = event.getCommand();
        if (cmd == null) {
            ICommandService commandService = (ICommandService)this.workbench.getService(ICommandService.class);
            cmd = commandService.getCommand(this.commandId);
        }
        if (event.getParameters().isEmpty()) {
            return new ParameterizedCommand(cmd, null);
        }
        ArrayList<Parameterization> parms = new ArrayList<Parameterization>();
        Iterator i = event.getParameters().entrySet().iterator();
        try {
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                parms.add(new Parameterization(cmd.getParameter((String)entry.getKey()), (String)entry.getValue()));
            }
            return new ParameterizedCommand(cmd, parms.toArray(new Parameterization[parms.size()]));
        }
        catch (NotDefinedException e) {
            WorkbenchPlugin.log(e);
            return null;
        }
    }

    public boolean isEnabled() {
        EHandlerService hs = (EHandlerService)this.workbench.getService(EHandlerService.class);
        ECommandService cs = (ECommandService)this.workbench.getService(ECommandService.class);
        if (hs == null || cs == null) {
            return false;
        }
        Command command = cs.getCommand(this.commandId);
        this.setBaseEnabled(hs.canExecute(new ParameterizedCommand(command, null)));
        return super.isEnabled();
    }

    public boolean isHandled() {
        EHandlerService service = (EHandlerService)this.workbench.getService(EHandlerService.class);
        if (service == null) {
            return false;
        }
        IEclipseContext ctx = (IEclipseContext)this.workbench.getService(IEclipseContext.class);
        Object handler = HandlerServiceImpl.lookUpHandler((IEclipseContext)ctx, (String)this.commandId);
        if (handler instanceof E4HandlerProxy) {
            IHandler h = ((E4HandlerProxy)handler).getHandler();
            return h == null ? false : h.isHandled();
        }
        return handler != null;
    }

    public void updateElement(UIElement element, Map parameters) {
        Object o = HandlerServiceImpl.lookUpHandler((IEclipseContext)((IEclipseContext)this.workbench.getService(IEclipseContext.class)), (String)this.commandId);
        if (o != this) {
            if (o instanceof E4HandlerProxy) {
                o = ((E4HandlerProxy)o).getHandler();
            }
            if (o instanceof IElementUpdater) {
                ((IElementUpdater)o).updateElement(element, parameters);
            }
        }
    }
}

